/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveClassRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.ParametersPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.ui.MoveClassPanel;
import org.netbeans.modules.refactoring.ui.MoveClassUI;
import org.netbeans.modules.refactoring.ui.RefactoringUIBypass;
import org.openide.awt.Mnemonics;
import org.openide.explorer.view.NodeRenderer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;

public class MoveClassesUI
implements RefactoringUI,
RefactoringUIBypass {
    private List resources;
    private Set javaObjects;
    private MovePanel panel;
    private MoveClassRefactoring refactoring;
    private String targetPkgName = "";
    private boolean disable;
    private FileObject targetFolder;
    private PasteType pasteType;

    static final String getString(String key) {
        return NbBundle.getMessage((Class)MoveClassUI.class, (String)key);
    }

    public MoveClassesUI(Set javaObjects) {
        this(javaObjects, null, null);
    }

    public MoveClassesUI(Set javaObjects, FileObject targetFolder, PasteType paste) {
        this.disable = targetFolder != null;
        this.targetFolder = targetFolder;
        this.javaObjects = javaObjects;
        this.pasteType = paste;
        if (!this.disable) {
            this.resources = new ArrayList(javaObjects.size());
            Iterator i = javaObjects.iterator();
            while (i.hasNext()) {
                this.resources.add(JavaModel.getResource((FileObject)((JavaDataObject)i.next()).getPrimaryFile()));
            }
        }
    }

    public String getName() {
        return MoveClassesUI.getString("LBL_MoveClasses");
    }

    public String getDescription() {
        return this.getName();
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ParametersPanel parent) {
        if (this.panel == null) {
            ClassPath cp;
            String pkgName = null;
            if (this.targetFolder != null && (cp = ClassPath.getClassPath((FileObject)this.targetFolder, (String)"classpath/source")) != null) {
                pkgName = cp.getResourceName(this.targetFolder, '.', false);
            }
            this.panel = new MovePanel(parent, pkgName != null ? pkgName : MoveClassesUI.getDOPackageName((DataObject)((DataObject)this.javaObjects.iterator().next()).getFolder()), MoveClassesUI.getString("LBL_MoveClassesHeadline"));
        }
        return this.panel;
    }

    private static String getResPackageName(Resource res) {
        String name = res.getName();
        if (name.indexOf(47) == -1) {
            return "";
        }
        return name.substring(0, name.lastIndexOf(47)).replace('/', '.');
    }

    private static String getDOPackageName(DataObject f) {
        return ClassPath.getClassPath((FileObject)f.getPrimaryFile(), (String)"classpath/source").getResourceName(f.getPrimaryFile(), '.', false);
    }

    private String packageName() {
        return this.targetPkgName.trim().length() == 0 ? MoveClassesUI.getString("LBL_DefaultPackage") : this.targetPkgName.trim();
    }

    private Problem setParameters(boolean checkOnly) {
        if (this.panel == null) {
            return null;
        }
        this.targetPkgName = this.panel.getPackageName();
        this.refactoring.setTargetClassPathRoot(this.panel.getRootFolder());
        this.refactoring.setTargetPackageName(this.targetPkgName);
        if (checkOnly) {
            return this.refactoring.fastCheckParameters();
        }
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        return this.setParameters(true);
    }

    public Problem setParameters() {
        return this.setParameters(false);
    }

    public AbstractRefactoring getRefactoring() {
        if (this.refactoring == null) {
            this.refactoring = this.disable ? new MoveClassRefactoring(this.javaObjects, this.targetFolder) : new MoveClassRefactoring(this.resources);
        }
        return this.refactoring;
    }

    private final Vector getNodes() {
        Vector<Node> result = new Vector<Node>(this.javaObjects.size());
        Iterator i = this.javaObjects.iterator();
        while (i.hasNext()) {
            result.add(((DataObject)i.next()).getNodeDelegate());
        }
        return result;
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(MoveClassesUI.class);
    }

    public boolean isRefactoringBypassRequired() {
        return !this.panel.isUpdateReferences();
    }

    public void doRefactoringBypass() throws IOException {
        this.pasteType.paste();
    }

    class MovePanel
    extends MoveClassPanel {
        public MovePanel(ParametersPanel parent, String startPackage, String headLine) {
            super(parent, startPackage, headLine, MoveClassesUI.this.targetFolder != null ? MoveClassesUI.this.targetFolder : ((JavaDataObject)MoveClassesUI.this.javaObjects.iterator().next()).getPrimaryFile());
            this.setCombosEnabled(!MoveClassesUI.this.disable);
            JList list = new JList(MoveClassesUI.this.getNodes());
            list.setCellRenderer(new NodeRenderer());
            list.setVisibleRowCount(5);
            JScrollPane pane = new JScrollPane(list);
            this.bottomPanel.setBorder(new EmptyBorder(8, 0, 0, 0));
            this.bottomPanel.setLayout(new BorderLayout());
            this.bottomPanel.add((Component)pane, "Center");
            JLabel listOf = new JLabel();
            Mnemonics.setLocalizedText((JLabel)listOf, (String)NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$ui$MoveClassesUI == null ? (class$org$netbeans$modules$refactoring$ui$MoveClassesUI = MoveClassesUI.class$("org.netbeans.modules.refactoring.ui.MoveClassesUI")) : class$org$netbeans$modules$refactoring$ui$MoveClassesUI), (String)"LBL_ListOfClasses"));
            this.bottomPanel.add((Component)listOf, "North");
        }
    }
}

