/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.plugins;

import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jmi.reflect.RefFeatured;
import org.netbeans.jmi.javamodel.ArrayReference;
import org.netbeans.jmi.javamodel.Assignment;
import org.netbeans.jmi.javamodel.BreakStatement;
import org.netbeans.jmi.javamodel.Case;
import org.netbeans.jmi.javamodel.Catch;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.ContinueStatement;
import org.netbeans.jmi.javamodel.DoStatement;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Expression;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.ForEachStatement;
import org.netbeans.jmi.javamodel.ForStatement;
import org.netbeans.jmi.javamodel.IfStatement;
import org.netbeans.jmi.javamodel.InitialValue;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.LocalVarDeclaration;
import org.netbeans.jmi.javamodel.LocalVarDeclarationClass;
import org.netbeans.jmi.javamodel.LocalVariable;
import org.netbeans.jmi.javamodel.LocalVariableClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MethodInvocation;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.Operator;
import org.netbeans.jmi.javamodel.OperatorEnum;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterClass;
import org.netbeans.jmi.javamodel.PrimaryExpression;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.ReturnStatement;
import org.netbeans.jmi.javamodel.Statement;
import org.netbeans.jmi.javamodel.StatementBlock;
import org.netbeans.jmi.javamodel.SwitchStatement;
import org.netbeans.jmi.javamodel.TryStatement;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.jmi.javamodel.Variable;
import org.netbeans.jmi.javamodel.VariableAccess;
import org.netbeans.jmi.javamodel.VariableAccessClass;
import org.netbeans.jmi.javamodel.WhileStatement;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.refactoring.CheckUtils;
import org.netbeans.modules.refactoring.api.ExtractMethodRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.plugins.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImpl;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ExtractMethodRefactoringPlugin
extends JavaRefactoringPlugin {
    private ExtractMethodRefactoring refactoring;
    private Statement firstStatement;
    private Statement lastStatement;
    private List selectedStatements;
    private Set writeVars;
    private Set readVars;
    private Set unusedDeclVars;
    private Set declVars;
    private Set newLocalVars;
    private Set exceptions;
    private Variable returnedVariable;
    private Feature feature;
    private TypeReference returnType;
    private boolean retValDefinedInSelectedStmts;
    private boolean hasReturn;

    public ExtractMethodRefactoringPlugin(ExtractMethodRefactoring ref) {
        this.refactoring = ref;
        this.writeVars = new HashSet();
        this.readVars = new HashSet();
        this.unusedDeclVars = new HashSet();
        this.declVars = new HashSet();
        this.newLocalVars = new HashSet();
    }

    public Problem checkParameters() {
        String newName;
        Problem p = this.fastCheckParameters();
        if (p != null) {
            return p;
        }
        List params = this.getParamTypes();
        ClassDefinition dc = this.getFeature().getDeclaringClass();
        if (dc.getMethod(newName = this.refactoring.getName(), params, false) != null) {
            String errText = new MessageFormat(ExtractMethodRefactoringPlugin.getString("ERR_MethodClash")).format(new Object[]{newName, this.getDefClassName(dc)});
            return ExtractMethodRefactoringPlugin.createProblem(null, true, errText);
        }
        return null;
    }

    public Problem fastCheckParameters() {
        Problem result = this.checkName(this.refactoring.getName());
        if (result != null) {
            return result;
        }
        ExtractMethodRefactoring.ParameterInfo[] pars = this.refactoring.getParamTable();
        for (int i = 0; i < pars.length; ++i) {
            result = this.checkName(pars[i].getName());
            if (result == null) continue;
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem preCheck() {
        this.fireProgressListenerStart(1, 8);
        try {
            if (this.refactoring.getStartOffset() < 0 || this.refactoring.getEndOffset() < 0) {
                Problem problem = ExtractMethodRefactoringPlugin.createProblem(null, true, ExtractMethodRefactoringPlugin.getString("ERR_ExtractMethodWrongElement"));
                return problem;
            }
            this.fireProgressListenerStep();
            Problem problem = this.checkStatements();
            if (problem != null) {
                Problem problem2 = problem;
                return problem2;
            }
            this.fireProgressListenerStep();
            problem = this.checkJump();
            if (problem != null) {
                Problem problem3 = problem;
                return problem3;
            }
            this.fireProgressListenerStep();
            this.computeAllVaribleAccess(this.selectedStatements);
            this.fireProgressListenerStep();
            problem = this.checkReturnValue();
            if (problem != null) {
                Problem problem4 = problem;
                return problem4;
            }
            this.fireProgressListenerStep();
            problem = this.computeExceptions();
            if (problem != null) {
                Problem problem5 = problem;
                return problem5;
            }
            this.fireProgressListenerStep();
            this.computeDuplicatedVars();
            this.fireProgressListenerStep();
            this.refactoring.setParamTable(this.getInputParameters());
            this.refactoring.setReturnType(this.getReturnType());
            this.refactoring.setStaticMod(Modifier.isStatic(this.getFeature().getModifiers()));
            this.fireProgressListenerStep();
            Problem problem6 = null;
            return problem6;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        refactoringElements.add(this.refactoring, new ExtractMethodElement());
        return null;
    }

    private Problem checkStatements() {
        Resource rsc = this.refactoring.getResource();
        int start = this.refactoring.getStartOffset();
        int end = this.refactoring.getEndOffset();
        this.selectedStatements = JavaModelUtil.getSelectedStatements((Resource)rsc, (int)start, (int)end);
        if (this.selectedStatements == null) {
            return ExtractMethodRefactoringPlugin.createProblem(null, true, ExtractMethodRefactoringPlugin.getString("ERR_ExtractMethodWrongSelection"));
        }
        return null;
    }

    private Problem checkJump() {
        Iterator sIt = this.selectedStatements.iterator();
        Object jumpStatement = null;
        while (sIt.hasNext()) {
            Statement jumpStmt = this.findJump((Statement)sIt.next(), false);
            if (jumpStmt == null) continue;
            if (jumpStatement == null) {
                jumpStatement = jumpStmt;
                continue;
            }
            if (!jumpStatement.refClass().equals(jumpStmt.refClass())) {
                return ExtractMethodRefactoringPlugin.createProblem(null, true, ExtractMethodRefactoringPlugin.getString("ERR_ExtractMethodContainsFixBreakReturn"));
            }
            jumpStatement = jumpStmt;
        }
        if (jumpStatement == null) {
            return null;
        }
        if (!jumpStatement.equals(this.getLastStatement())) {
            return ExtractMethodRefactoringPlugin.createProblem(null, true, ExtractMethodRefactoringPlugin.getString("ERR_ExtractMethodContainsBreakOrReturn"));
        }
        if (jumpStatement instanceof ReturnStatement && ((ReturnStatement)jumpStatement).getExpression() != null) {
            this.hasReturn = true;
            return null;
        }
        this.selectedStatements.remove(this.selectedStatements.size() - 1);
        return null;
    }

    private Boolean readsVariableAfterSelection(Variable var) {
        Element varScope = (Element)var.refImmediateComposite();
        if (varScope instanceof LocalVarDeclaration) {
            varScope = (Element)varScope.refImmediateComposite();
        }
        Statement last = this.getLastStatement();
        int lastOffset = last.getEndOffset();
        List children = varScope.getChildren();
        VariableAnalyzer ca = new VariableAnalyzer(var, lastOffset + 1, varScope.getEndOffset());
        return ca.readsVariableInElement(children);
    }

    private Statement findJump(Statement st, boolean ignoreBreakCont) {
        if (st instanceof ReturnStatement) {
            return st;
        }
        if (!ignoreBreakCont && (st instanceof BreakStatement || st instanceof ContinueStatement)) {
            return st;
        }
        if (st instanceof SwitchStatement || st instanceof WhileStatement || st instanceof DoStatement || st instanceof ForStatement || st instanceof ForEachStatement) {
            ignoreBreakCont = true;
        }
        Iterator chIt = st.getChildren().iterator();
        while (chIt.hasNext()) {
            Statement jumpStmt;
            Element el = (Element)chIt.next();
            if (!(el instanceof Statement) || el instanceof JavaClass || (jumpStmt = this.findJump((Statement)el, ignoreBreakCont)) == null) continue;
            return jumpStmt;
        }
        return null;
    }

    ExtractMethodRefactoring.ParameterInfo[] getInputParameters() {
        VariableAnalyzer ca;
        Variable v;
        ArrayList<ExtractMethodRefactoring.ParameterInfo> pars = new ArrayList<ExtractMethodRefactoring.ParameterInfo>();
        Iterator it = this.readVars.iterator();
        while (it.hasNext()) {
            v = (Variable)it.next();
            ca = new VariableAnalyzer(v);
            if (Boolean.FALSE.equals(ca.readsVariableInElement(this.selectedStatements))) {
                this.newLocalVars.add(v);
                continue;
            }
            pars.add(new ExtractMethodRefactoring.ParameterInfo(v));
        }
        it = this.writeVars.iterator();
        while (it.hasNext()) {
            v = (Variable)it.next();
            ca = new VariableAnalyzer(v);
            if (this.readVars.contains(v) || this.isInsideSelectedStatements((Element)v)) continue;
            if (Boolean.FALSE.equals(ca.readsVariableInElement(this.selectedStatements))) {
                this.newLocalVars.add(v);
                continue;
            }
            pars.add(new ExtractMethodRefactoring.ParameterInfo(v));
        }
        return pars.toArray(new ExtractMethodRefactoring.ParameterInfo[pars.size()]);
    }

    private Problem checkReturnValue() {
        int lastOffset = this.getLastStatement().getEndOffset();
        HashSet<Variable> retVar = new HashSet<Variable>();
        this.checkLoop(retVar);
        Iterator it = this.writeVars.iterator();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            if (!Boolean.TRUE.equals(this.readsVariableAfterSelection(var))) continue;
            retVar.add(var);
        }
        if (retVar.size() > 1) {
            StringBuffer conflictNames = new StringBuffer();
            it = retVar.iterator();
            while (it.hasNext()) {
                Variable v = (Variable)it.next();
                conflictNames.append(v.getName()).append(' ');
            }
            String msg = new MessageFormat(ExtractMethodRefactoringPlugin.getString("ERR_ExtractMethodTooMuchRetValues")).format(new Object[]{conflictNames});
            return ExtractMethodRefactoringPlugin.createProblem(null, true, msg);
        }
        if (this.hasReturn && !retVar.isEmpty()) {
            Variable v = (Variable)retVar.iterator().next();
            String conflictNames = v.getName();
            String msg = new MessageFormat(ExtractMethodRefactoringPlugin.getString("ERR_ExtractMethodRetValueAndReturn")).format(new Object[]{conflictNames});
            return ExtractMethodRefactoringPlugin.createProblem(null, true, msg);
        }
        if (!retVar.isEmpty()) {
            this.returnedVariable = (Variable)retVar.iterator().next();
            this.retValDefinedInSelectedStmts = this.isInsideSelectedStatements((Element)this.returnedVariable);
        }
        return null;
    }

    private void checkLoop(Set retVar) {
        boolean hasLoop = false;
        Statement el = this.getFirstStatement();
        while (!(el instanceof ClassMember)) {
            if (!((el = (Element)el.refImmediateComposite()) instanceof WhileStatement) && !(el instanceof ForStatement) && !(el instanceof DoStatement)) continue;
            hasLoop = true;
            break;
        }
        if (!hasLoop) {
            return;
        }
        Iterator it = this.writeVars.iterator();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            if (!this.readVars.contains(var)) continue;
            retVar.add(var);
        }
    }

    private Problem computeExceptions() {
        this.exceptions = JavaModelUtil.getExceptionsFromStatements((List)this.selectedStatements);
        return null;
    }

    private void computeAllVaribleAccess(List elements) {
        Iterator elIt = elements.iterator();
        while (elIt.hasNext()) {
            Object el;
            block7: {
                block6: {
                    el = elIt.next();
                    if (!(el instanceof VariableAccess)) break block6;
                    VariableAccess acc = (VariableAccess)el;
                    Variable variable = (Variable)acc.getElement();
                    if (variable instanceof Field) break block7;
                    if (this.isInsideSelectedStatements((Element)variable) && !this.selectedStatements.contains(variable)) continue;
                    this.unusedDeclVars.remove(acc);
                    if (acc.isWrite()) {
                        this.writeVars.add(variable);
                    }
                    if (!acc.isRead()) break block7;
                    this.readVars.add(variable);
                    break block7;
                }
                if (el instanceof MultipartId) continue;
                if (el instanceof LocalVarDeclaration && this.selectedStatements.contains(el)) {
                    LocalVarDeclaration varDecl = (LocalVarDeclaration)el;
                    Iterator varIt = varDecl.getVariables().iterator();
                    while (varIt.hasNext()) {
                        LocalVariable locVar = (LocalVariable)varIt.next();
                        if (locVar.getInitialValue() != null) {
                            this.writeVars.add(locVar);
                        } else {
                            this.unusedDeclVars.add(locVar);
                        }
                        this.declVars.add(locVar);
                    }
                }
            }
            this.computeAllVaribleAccess(((Element)el).getChildren());
        }
    }

    private boolean isInsideSelectedStatements(Element el) {
        int elOffset = el.getStartOffset();
        return elOffset >= this.getFirstStatement().getStartOffset() && elOffset <= this.getLastStatement().getEndOffset();
    }

    private Problem checkName(String name) {
        if (!Utilities.isJavaIdentifier((String)name)) {
            String msg = new MessageFormat(ExtractMethodRefactoringPlugin.getString("ERR_InvalidIdentifier")).format(new Object[]{name});
            return ExtractMethodRefactoringPlugin.createProblem(null, true, msg);
        }
        return null;
    }

    private static String getString(String key) {
        return NbBundle.getMessage((Class)ExtractMethodRefactoring.class, (String)key);
    }

    String getDefClassName(ClassDefinition cd) {
        if (cd instanceof JavaClass) {
            return ((JavaClass)cd).getName();
        }
        return "";
    }

    private Statement getFirstStatement() {
        return (Statement)this.selectedStatements.get(0);
    }

    private Statement getLastStatement() {
        return (Statement)this.selectedStatements.get(this.selectedStatements.size() - 1);
    }

    private Feature getFeature() {
        if (this.feature == null) {
            this.feature = JavaModelUtil.getDeclaringFeature((Element)this.getFirstStatement());
        }
        return this.feature;
    }

    private List getParamTypes() {
        ExtractMethodRefactoring.ParameterInfo[] pars = this.refactoring.getParamTable();
        ArrayList<Type> types = new ArrayList<Type>(pars.length);
        for (int i = 0; i < pars.length; ++i) {
            types.add(pars[i].getVariable().getType());
        }
        return types;
    }

    private TypeReference getReturnType() {
        if (this.returnType == null) {
            this.returnType = this.createReturnType();
        }
        return this.returnType;
    }

    private TypeReference createReturnType() {
        int dims;
        TypeReference ref;
        Feature f = this.getFeature();
        JavaModelPackage pck = (JavaModelPackage)f.refImmediatePackage();
        if (this.hasReturn) {
            Method m = (Method)f;
            ref = m.getTypeName();
            dims = m.getDimCount();
        } else if (this.returnedVariable != null) {
            ref = this.returnedVariable.getTypeName();
            dims = this.returnedVariable.getDimCount();
        } else {
            return pck.getMultipartId().createMultipartId("void", null, null);
        }
        ref = (TypeReference)ref.duplicate();
        if (dims == 0) {
            return ref;
        }
        if (ref instanceof ArrayReference) {
            ArrayReference arr = (ArrayReference)ref;
            arr.setDimCount(arr.getDimCount() + dims);
            return arr;
        }
        return pck.getArrayReference().createArrayReference(null, (MultipartId)ref, dims);
    }

    private void computeDuplicatedVars() {
        Iterator locVarIt = this.declVars.iterator();
        while (locVarIt.hasNext()) {
            LocalVariable loc = (LocalVariable)locVarIt.next();
            if (loc.equals(this.returnedVariable)) {
                locVarIt.remove();
                continue;
            }
            if (this.unusedDeclVars.contains(loc)) {
                locVarIt.remove();
                continue;
            }
            if (this.isAccessedAfterSelection(loc)) continue;
            locVarIt.remove();
        }
    }

    private boolean isAccessedAfterSelection(LocalVariable loc) {
        Iterator usagesIt = loc.getReferences().iterator();
        while (usagesIt.hasNext()) {
            Element usage = (Element)usagesIt.next();
            if (this.isInsideSelectedStatements(usage)) continue;
            return true;
        }
        return false;
    }

    private class ExtractMethodElement
    extends SimpleRefactoringElementImpl {
        private Resource rsc;
        private JavaModelPackage pck;

        private ExtractMethodElement() {
            this.rsc = ExtractMethodRefactoringPlugin.this.getFirstStatement().getResource();
            this.pck = (JavaModelPackage)this.rsc.refImmediatePackage();
        }

        public String getDisplayText() {
            return this.getText();
        }

        public Element getJavaElement() {
            return ExtractMethodRefactoringPlugin.this.getFeature();
        }

        public FileObject getParentFile() {
            return JavaModel.getFileObject((Resource)this.getResource());
        }

        public PositionBounds getPosition() {
            PositionBounds st = JavaMetamodel.getManager().getElementPosition((Element)ExtractMethodRefactoringPlugin.this.getFirstStatement());
            PositionBounds end = JavaMetamodel.getManager().getElementPosition((Element)ExtractMethodRefactoringPlugin.this.getLastStatement());
            return new PositionBounds(st.getBegin(), end.getEnd());
        }

        public String getText() {
            String sourceText = this.getResource().getSourceText();
            return CheckUtils.htmlize(sourceText.substring(ExtractMethodRefactoringPlugin.this.getFirstStatement().getStartOffset(), ExtractMethodRefactoringPlugin.this.getLastStatement().getEndOffset()));
        }

        public void performChange() {
            Feature f = ExtractMethodRefactoringPlugin.this.getFeature();
            String name = ExtractMethodRefactoringPlugin.this.refactoring.getName();
            int mods = ExtractMethodRefactoringPlugin.this.refactoring.getModifier() | (ExtractMethodRefactoringPlugin.this.refactoring.isStaticMod() ? 8 : 0);
            List duplVars = this.createDuplicatedVars();
            Statement newStmt = this.createReplacementStatement();
            List statements = this.createStatements(newStmt);
            this.insertDuplicatedVars(duplVars, newStmt);
            StatementBlock body = this.pck.getStatementBlock().createStatementBlock(statements);
            List pars = this.createFormalParameters();
            TypeReference retType = ExtractMethodRefactoringPlugin.this.getReturnType();
            List exNames = this.createExceptionNames(f);
            Method m = this.pck.getMethod().createMethod(name, null, mods, null, null, body, null, null, pars, exNames, retType, 0);
            List features = f.getDeclaringClass().getFeatures();
            int index = features.indexOf(f);
            features.add(index + 1, m);
        }

        private List createExceptionNames(Feature scope) {
            ArrayList<MultipartId> excs = new ArrayList<MultipartId>();
            Iterator exIt = ExtractMethodRefactoringPlugin.this.exceptions.iterator();
            while (exIt.hasNext()) {
                excs.add(JavaModelUtil.resolveImportsForClass((Element)scope, (JavaClass)((JavaClass)exIt.next())));
            }
            return excs;
        }

        private List createFormalParameters() {
            ExtractMethodRefactoring.ParameterInfo[] parTable = ExtractMethodRefactoringPlugin.this.refactoring.getParamTable();
            ParameterClass parCls = this.pck.getParameter();
            ArrayList<Parameter> pars = new ArrayList<Parameter>();
            for (int i = 0; i < parTable.length; ++i) {
                ExtractMethodRefactoring.ParameterInfo pInfo = parTable[i];
                Variable var = pInfo.getVariable();
                int dimcount = var.getDimCount();
                if (var instanceof Parameter && ((Parameter)var).isVarArg()) {
                    ++dimcount;
                }
                TypeReference parType = (TypeReference)var.getTypeName().duplicate();
                Parameter p = parCls.createParameter(pInfo.getName(), null, !ExtractMethodRefactoringPlugin.this.writeVars.contains(var), parType, dimcount, false);
                pars.add(p);
            }
            return pars;
        }

        private Statement createReplacementStatement() {
            List pars = this.createParameters();
            String name = ExtractMethodRefactoringPlugin.this.refactoring.getName();
            MethodInvocation inv = this.pck.getMethodInvocation().createMethodInvocation(name, pars, null, false);
            if (ExtractMethodRefactoringPlugin.this.hasReturn) {
                return this.pck.getReturnStatement().createReturnStatement((Expression)inv);
            }
            if (ExtractMethodRefactoringPlugin.this.returnedVariable != null) {
                if (ExtractMethodRefactoringPlugin.this.retValDefinedInSelectedStmts) {
                    return this.createVarDecl(ExtractMethodRefactoringPlugin.this.returnedVariable, (InitialValue)inv);
                }
                Assignment assign = this.pck.getAssignment().createAssignment((PrimaryExpression)this.createVarAccess(ExtractMethodRefactoringPlugin.this.returnedVariable), (Operator)OperatorEnum.ASSIGN, (Expression)inv);
                return this.pck.getExpressionStatement().createExpressionStatement((Expression)assign);
            }
            return this.pck.getExpressionStatement().createExpressionStatement((Expression)inv);
        }

        private List createParameters() {
            ExtractMethodRefactoring.ParameterInfo[] parTable = ExtractMethodRefactoringPlugin.this.refactoring.getParamTable();
            VariableAccessClass parCls = this.pck.getVariableAccess();
            ArrayList<VariableAccess> pars = new ArrayList<VariableAccess>();
            for (int i = 0; i < parTable.length; ++i) {
                pars.add(parCls.createVariableAccess(parTable[i].getName(), null, false));
            }
            return pars;
        }

        private VariableAccess createVarAccess(Variable var) {
            return this.pck.getVariableAccess().createVariableAccess(ExtractMethodRefactoringPlugin.this.returnedVariable.getName(), null, false);
        }

        private LocalVarDeclaration createVarDecl(Variable var, InitialValue initVal) {
            LocalVariable locVar = this.pck.getLocalVariable().createLocalVariable(var.getName(), null, false, null, var.getDimCount(), initVal, null);
            TypeReference typeName = (TypeReference)var.getTypeName().duplicate();
            return this.pck.getLocalVarDeclaration().createLocalVarDeclaration(false, typeName, Collections.singletonList(locVar));
        }

        private List createStatements(Statement newStmt) {
            ArrayList<Object> stmts = new ArrayList<Object>();
            Element parent = (Element)ExtractMethodRefactoringPlugin.this.getFirstStatement().refImmediateComposite();
            Iterator it = ExtractMethodRefactoringPlugin.this.newLocalVars.iterator();
            while (it.hasNext()) {
                stmts.add(this.createVarDecl((Variable)it.next(), null));
            }
            it = ExtractMethodRefactoringPlugin.this.selectedStatements.iterator();
            while (it.hasNext()) {
                Statement st = (Statement)it.next();
                if (ExtractMethodRefactoringPlugin.this.unusedDeclVars.contains(st)) continue;
                parent.replaceChild((Element)st, (Element)newStmt);
                stmts.add(st);
                newStmt = null;
            }
            if (ExtractMethodRefactoringPlugin.this.returnedVariable != null) {
                stmts.add(this.pck.getReturnStatement().createReturnStatement((Expression)this.createVarAccess(ExtractMethodRefactoringPlugin.this.returnedVariable)));
            }
            return stmts;
        }

        private Resource getResource() {
            return this.rsc;
        }

        private List createDuplicatedVars() {
            LocalVarDeclarationClass declClass = this.pck.getLocalVarDeclaration();
            LocalVariableClass varClass = this.pck.getLocalVariable();
            ArrayList<LocalVarDeclaration> vars = new ArrayList<LocalVarDeclaration>();
            Iterator it = ExtractMethodRefactoringPlugin.this.declVars.iterator();
            while (it.hasNext()) {
                LocalVariable loc = (LocalVariable)it.next();
                LocalVariable lvar = varClass.createLocalVariable(loc.getName(), null, false, null, loc.getDimCount(), null, null);
                TypeReference typeName = (TypeReference)loc.getTypeName().duplicate();
                vars.add(declClass.createLocalVarDeclaration(false, typeName, Collections.singletonList(lvar)));
            }
            return vars;
        }

        private void insertDuplicatedVars(List duplVars, Statement newStmt) {
            RefFeatured parent;
            if (!duplVars.isEmpty() && (parent = newStmt.refImmediateComposite()) instanceof StatementBlock) {
                StatementBlock pblock = (StatementBlock)parent;
                List stmts = pblock.getStatements();
                int offset = stmts.indexOf(newStmt);
                stmts.addAll(offset, duplVars);
            }
        }
    }

    private class VariableAnalyzer {
        private Variable var;
        private int startOffset;
        private int endOffset;

        private VariableAnalyzer(Variable v) {
            this(v, 0, Integer.MAX_VALUE);
        }

        private VariableAnalyzer(Variable v, int start, int end) {
            this.var = v;
            this.startOffset = start;
            this.endOffset = end;
        }

        private Boolean readsVariableInElement(Collection els) {
            Iterator chIt = els.iterator();
            while (chIt.hasNext()) {
                Boolean ret = this.readsVariableInElement((Element)chIt.next());
                if (ret == null) continue;
                return ret;
            }
            return null;
        }

        private boolean isInRange(int offset) {
            return offset >= this.startOffset && offset <= this.endOffset;
        }

        private Boolean readsVariableInElement(Element el) {
            if (el == null || !this.isInRange(el.getStartOffset()) && !this.isInRange(el.getEndOffset())) {
                return null;
            }
            if (el instanceof VariableAccess) {
                VariableAccess acc = (VariableAccess)el;
                Variable variable = (Variable)acc.getElement();
                if (this.var.equals(variable)) {
                    return acc.isRead();
                }
                return null;
            }
            if (el instanceof MultipartId) {
                return null;
            }
            if (el instanceof Assignment) {
                Assignment assign = (Assignment)el;
                Boolean ret = this.readsVariableInElement((Element)assign.getRightSide());
                if (ret == null) {
                    ret = this.readsVariableInElement((Element)assign.getLeftSide());
                }
                return ret;
            }
            if (el instanceof IfStatement) {
                IfStatement ifSt = (IfStatement)el;
                Boolean ret = this.readsVariableInElement((Element)ifSt.getExpression());
                if (ret != null) {
                    return ret;
                }
                Boolean thenPart = this.readsVariableInElement((Element)ifSt.getThenPart());
                Boolean elsePart = this.readsVariableInElement((Element)ifSt.getElsePart());
                if (Boolean.TRUE.equals(thenPart) || Boolean.TRUE.equals(elsePart)) {
                    return Boolean.TRUE;
                }
                if (Boolean.FALSE.equals(thenPart) && Boolean.FALSE.equals(elsePart)) {
                    return Boolean.FALSE;
                }
                return null;
            }
            if (el instanceof WhileStatement) {
                WhileStatement wst = (WhileStatement)el;
                Boolean ret = this.readsVariableInElement((Element)wst.getExpression());
                if (ret != null) {
                    return ret;
                }
                Boolean body = this.readsVariableInElement((Element)wst.getBody());
                if (Boolean.TRUE.equals(body)) {
                    return body;
                }
                return null;
            }
            if (el instanceof ForStatement) {
                ForStatement forSt = (ForStatement)el;
                Boolean ret = this.readsVariableInElement(forSt.getInit());
                if (ret != null) {
                    return ret;
                }
                ret = this.readsVariableInElement((Element)forSt.getExpression());
                if (ret != null) {
                    return ret;
                }
                ArrayList<Statement> bodyList = new ArrayList<Statement>(2);
                Statement body = forSt.getBody();
                if (body != null) {
                    bodyList.add(body);
                }
                bodyList.addAll(forSt.getSteps());
                ret = this.readsVariableInElement(bodyList);
                if (Boolean.TRUE.equals(ret)) {
                    return ret;
                }
                return null;
            }
            if (el instanceof TryStatement) {
                TryStatement trySt = (TryStatement)el;
                Boolean ret = this.readsVariableInElement((Element)trySt.getBody());
                if (ret != null) {
                    return ret;
                }
                Iterator catchIt = trySt.getCatches().iterator();
                while (catchIt.hasNext()) {
                    if (!Boolean.TRUE.equals(this.readsVariableInElement((Element)((Catch)catchIt.next())))) continue;
                    return Boolean.TRUE;
                }
                return this.readsVariableInElement((Element)trySt.getFinalizer());
            }
            if (el instanceof SwitchStatement) {
                SwitchStatement switchSt = (SwitchStatement)el;
                Boolean ret = this.readsVariableInElement((Element)switchSt.getExpression());
                if (ret != null) {
                    return ret;
                }
                Iterator caseIt = switchSt.getCases().iterator();
                while (caseIt.hasNext()) {
                    if (!Boolean.TRUE.equals(this.readsVariableInElement((Element)((Case)caseIt.next())))) continue;
                    return Boolean.TRUE;
                }
                return null;
            }
            return this.readsVariableInElement(el.getChildren());
        }
    }
}

