/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.plugins;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jmi.reflect.RefFeatured;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.GenericElement;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.MultipartIdClass;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.TypeParameter;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.netbeans.modules.refactoring.CheckUtils;
import org.netbeans.modules.refactoring.UndoWatcher;
import org.netbeans.modules.refactoring.Utilities;
import org.netbeans.modules.refactoring.api.ExtractInterfaceRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.plugins.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImpl;
import org.netbeans.modules.refactoring.ui.UIUtilities;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.PositionBounds;
import org.openide.util.NbBundle;

public class ExtractInterfaceRefactoringPlugin
extends JavaRefactoringPlugin {
    private final ExtractInterfaceRefactoring refactoring;
    static /* synthetic */ Class class$org$netbeans$modules$refactoring$plugins$ExtractInterfaceRefactoringPlugin;

    ExtractInterfaceRefactoringPlugin(ExtractInterfaceRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem preCheck() {
        this.fireProgressListenerStart(1, 1);
        try {
            JavaClass sourceType = this.refactoring.getSourceType();
            Problem result = ExtractInterfaceRefactoringPlugin.isElementAvail((Element)sourceType);
            if (result != null) {
                Problem problem = result;
                return problem;
            }
            if (!CheckUtils.isElementInOpenProject((Element)sourceType)) {
                Problem problem = new Problem(true, NbBundle.getMessage((Class)JavaRefactoringPlugin.class, (String)"ERR_ProjectNotOpened"));
                return problem;
            }
            if (sourceType instanceof UnresolvedClass) {
                Problem problem = new Problem(true, NbBundle.getMessage((Class)JavaRefactoringPlugin.class, (String)"ERR_ElementNotAvailable"));
                return problem;
            }
            this.fireProgressListenerStep();
            Problem problem = null;
            return problem;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    public Problem fastCheckParameters() {
        Problem result = null;
        JavaClass sourceType = this.refactoring.getSourceType();
        String oldName = sourceType.getSimpleName();
        String newName = this.refactoring.getIfcName();
        if (!org.openide.util.Utilities.isJavaIdentifier((String)newName)) {
            result = ExtractInterfaceRefactoringPlugin.createProblem(result, true, NbBundle.getMessage((Class)RenameRefactoring.class, (String)"ERR_InvalidIdentifier", (Object)newName));
            return result;
        }
        Resource resource = sourceType.getResource();
        FileObject primFile = JavaModel.getFileObject((Resource)resource);
        FileObject folder = primFile.getParent();
        FileObject[] children = folder.getChildren();
        for (int x = 0; x < children.length; ++x) {
            if (children[x].isVirtual() || !children[x].getName().equals(newName) || !"java".equals(children[x].getExt())) continue;
            result = ExtractInterfaceRefactoringPlugin.createProblem(result, true, NbBundle.getMessage((Class)RenameRefactoring.class, (String)"ERR_ClassClash", (Object)newName, (Object)resource.getPackageName()));
            return result;
        }
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        NamedElement[] members = this.refactoring.getMembers();
        List typeParams = ExtractInterfaceRefactoringPlugin.findUsedGenericTypes(members, this.refactoring.getSourceType());
        CreateIfcElement createIfcElement = new CreateIfcElement(this.refactoring.getSourceType().getResource(), this.refactoring.getIfcName(), typeParams);
        refactoringElements.add(this.refactoring, createIfcElement);
        refactoringElements.add(this.refactoring, new AddImplementsElement(this.refactoring.getSourceType(), this.refactoring.getIfcName(), typeParams));
        for (int i = 0; i < members.length; ++i) {
            refactoringElements.add(this.refactoring, new GenerateMemberElement(members[i], createIfcElement));
        }
        return null;
    }

    static List findUsedGenericTypes(NamedElement[] members, JavaClass javaClass) {
        List typePars = javaClass.getTypeParameters();
        if (typePars.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        HashMap<String, TypeParameter> nameToType = new HashMap<String, TypeParameter>();
        Iterator iter = typePars.iterator();
        while (iter.hasNext()) {
            TypeParameter tp = (TypeParameter)iter.next();
            nameToType.put(tp.getName(), tp);
        }
        HashSet set = new HashSet();
        HashSet redefined = new HashSet();
        for (int x = 0; x < members.length; ++x) {
            ExtractInterfaceRefactoringPlugin.findUsedGenericTypes((Element)members[x], set, redefined, nameToType);
        }
        ArrayList<TypeParameter> result = new ArrayList<TypeParameter>(set.size());
        Iterator iter2 = typePars.iterator();
        while (iter2.hasNext()) {
            TypeParameter tp = (TypeParameter)iter2.next();
            if (!set.contains(tp.getName())) continue;
            result.add(tp);
        }
        return result;
    }

    private static void findUsedGenericTypes(Element elem, Set result, Set hidden, Map nameToType) {
        String tpName;
        MultipartId id;
        GenericElement gelem;
        List tpList;
        if (elem instanceof GenericElement && !(tpList = (gelem = (GenericElement)elem).getTypeParameters()).isEmpty()) {
            boolean extendedHiddenSetCreated = false;
            Iterator iter = tpList.iterator();
            while (iter.hasNext()) {
                TypeParameter tp = (TypeParameter)iter.next();
                String name = tp.getName();
                if (nameToType.get(name) == null || hidden.contains(name)) continue;
                if (!extendedHiddenSetCreated) {
                    hidden = new HashSet<String>(hidden);
                    extendedHiddenSetCreated = true;
                }
                hidden.add(name);
            }
        }
        if (elem instanceof MultipartId && (id = (MultipartId)elem).getElement() instanceof TypeParameter && nameToType.get(tpName = id.getName()) != null && !hidden.contains(tpName)) {
            result.add(tpName);
        }
        Iterator iter = elem.getChildren().iterator();
        while (iter.hasNext()) {
            ExtractInterfaceRefactoringPlugin.findUsedGenericTypes((Element)iter.next(), result, hidden, nameToType);
        }
    }

    private static class GenerateMemberElement
    extends SimpleRefactoringElementImpl {
        private final NamedElement elementToGenerate;
        private final CreateIfcElement cie;
        private final String text;

        GenerateMemberElement(NamedElement elementToGenerate, CreateIfcElement element) {
            this.elementToGenerate = elementToGenerate;
            this.cie = element;
            this.text = NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$plugins$ExtractInterfaceRefactoringPlugin == null ? (class$org$netbeans$modules$refactoring$plugins$ExtractInterfaceRefactoringPlugin = ExtractInterfaceRefactoringPlugin.class$("org.netbeans.modules.refactoring.plugins.ExtractInterfaceRefactoringPlugin")) : class$org$netbeans$modules$refactoring$plugins$ExtractInterfaceRefactoringPlugin), (String)GenerateMemberElement.getBundleKey(elementToGenerate), (Object)UIUtilities.getDisplayText(elementToGenerate));
        }

        private static String getBundleKey(NamedElement element) {
            if (element instanceof Method) {
                RefFeatured comp = element.refImmediateComposite();
                if (comp instanceof JavaClass && ((JavaClass)comp).isInterface()) {
                    return "TXT_ExtractInterface_MoveMethod";
                }
                return "TXT_ExtractInterface_Method";
            }
            if (element instanceof Field) {
                return "TXT_ExtractInterface_Field";
            }
            if (element instanceof JavaClass) {
                return "TXT_ExtractInterface_Class";
            }
            if (element instanceof MultipartId) {
                return "TXT_ExtractInterface_Implements";
            }
            throw new IllegalArgumentException("Wrong type of element: " + element.getClass().getName());
        }

        public void performChange() {
            if (this.cie.getNewInterface() == null) {
                return;
            }
            if (this.elementToGenerate instanceof Method) {
                JavaClass jc;
                JavaModelPackage extent = (JavaModelPackage)this.cie.getNewInterface().refImmediatePackage();
                Method oldMethod = (Method)this.elementToGenerate;
                Method method = extent.getMethod().createMethod(oldMethod.getName(), Utilities.duplicateList(oldMethod.getAnnotations(), extent), 0, oldMethod.getJavadocText(), null, null, null, Utilities.duplicateList(oldMethod.getTypeParameters(), extent), Utilities.duplicateList(oldMethod.getParameters(), extent), Utilities.duplicateList(oldMethod.getExceptionNames(), extent), (TypeReference)oldMethod.getTypeName().duplicate(), oldMethod.getDimCount());
                this.cie.getNewInterface().getFeatures().add(method);
                ((MetadataElement)method).fixImports((Element)this.cie.getNewInterface(), (Element)this.elementToGenerate);
                RefFeatured comp = oldMethod.refImmediateComposite();
                if (comp instanceof JavaClass && (jc = (JavaClass)comp).isInterface()) {
                    jc.replaceChild((Element)oldMethod, null);
                }
            } else {
                Element parent = (Element)this.elementToGenerate.refImmediateComposite();
                parent.replaceChild((Element)this.elementToGenerate, null);
                if (this.elementToGenerate instanceof MultipartId) {
                    this.cie.getNewInterface().getInterfaceNames().add(JavaModelUtil.resolveImportsForClass((Element)this.cie.getNewInterface(), (JavaClass)((JavaClass)((MultipartId)this.elementToGenerate).getElement())));
                    this.elementToGenerate.refDelete();
                } else {
                    Feature feature = (Feature)this.elementToGenerate;
                    feature.setModifiers(feature.getModifiers() & 0xFFFFFFE6);
                    this.cie.getNewInterface().getContents().add(this.elementToGenerate);
                    ((MetadataElement)this.elementToGenerate).fixImports((Element)this.cie.getNewInterface(), (Element)this.elementToGenerate);
                }
            }
        }

        public String getText() {
            return this.text;
        }

        public String getDisplayText() {
            return this.text;
        }

        public FileObject getParentFile() {
            return JavaMetamodel.getManager().getFileObject(this.elementToGenerate.getResource());
        }

        public Element getJavaElement() {
            return JavaModelUtil.getDeclaringFeature((Element)this.elementToGenerate);
        }

        public PositionBounds getPosition() {
            return JavaMetamodel.getManager().getElementPosition((Element)this.elementToGenerate);
        }
    }

    private static class AddImplementsElement
    extends SimpleRefactoringElementImpl {
        private final JavaClass sourceType;
        private final String ifcName;
        private final List typeParams;
        private final String text;

        AddImplementsElement(JavaClass sourceType, String ifcName, List typeParams) {
            this.sourceType = sourceType;
            this.ifcName = ifcName;
            this.typeParams = typeParams;
            this.text = NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$plugins$ExtractInterfaceRefactoringPlugin == null ? (class$org$netbeans$modules$refactoring$plugins$ExtractInterfaceRefactoringPlugin = ExtractInterfaceRefactoringPlugin.class$("org.netbeans.modules.refactoring.plugins.ExtractInterfaceRefactoringPlugin")) : class$org$netbeans$modules$refactoring$plugins$ExtractInterfaceRefactoringPlugin), (String)"TXT_ExtractInterface_AddImplements", (Object)ifcName);
        }

        public void performChange() {
            JavaModelPackage extent = (JavaModelPackage)this.sourceType.refImmediatePackage();
            MultipartIdClass idProxy = extent.getMultipartId();
            MultipartId mpi = idProxy.createMultipartId(this.ifcName, null, null);
            if (this.typeParams != null && this.typeParams.size() > 0) {
                List typeArgs = mpi.getTypeArguments();
                Iterator iter = this.typeParams.iterator();
                while (iter.hasNext()) {
                    typeArgs.add(idProxy.createMultipartId(((TypeParameter)iter.next()).getName(), null, null));
                }
            }
            this.sourceType.getInterfaceNames().add(mpi);
        }

        public String getText() {
            return this.text;
        }

        public String getDisplayText() {
            return this.text;
        }

        public FileObject getParentFile() {
            return JavaMetamodel.getManager().getFileObject(this.sourceType.getResource());
        }

        public Element getJavaElement() {
            return this.sourceType;
        }

        public PositionBounds getPosition() {
            return JavaMetamodel.getManager().getElementPosition((Element)this.sourceType);
        }
    }

    private static class CreateIfcElement
    extends SimpleRefactoringElementImpl {
        private final String ifcName;
        private final Resource source;
        private final String text;
        private final List typeParams;
        private JavaClass newIfc = null;

        CreateIfcElement(Resource source, String ifcName, List typeParams) {
            this.source = source;
            this.ifcName = ifcName;
            this.typeParams = typeParams;
            this.text = NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$plugins$ExtractInterfaceRefactoringPlugin == null ? (class$org$netbeans$modules$refactoring$plugins$ExtractInterfaceRefactoringPlugin = ExtractInterfaceRefactoringPlugin.class$("org.netbeans.modules.refactoring.plugins.ExtractInterfaceRefactoringPlugin")) : class$org$netbeans$modules$refactoring$plugins$ExtractInterfaceRefactoringPlugin), (String)"TXT_ExtractInterface_CreateIfc", (Object)ifcName);
        }

        public void performChange() {
            ExternalChange ec = new ExternalChange(){
                private FileSystem fs;
                private String newIfcName;
                private String folderName;

                public void performExternalChange() {
                    try {
                        FileObject folderFO;
                        FileObject tempFO = Repository.getDefault().getDefaultFileSystem().findResource("Templates/Classes/Interface.java");
                        if (this.fs == null) {
                            FileObject sourceFO = JavaModel.getFileObject((Resource)CreateIfcElement.this.source);
                            folderFO = sourceFO.getParent();
                            this.folderName = folderFO.getPath();
                            this.fs = folderFO.getFileSystem();
                        } else {
                            folderFO = this.fs.findResource(this.folderName);
                        }
                        DataFolder folder = (DataFolder)DataObject.find((FileObject)folderFO);
                        DataObject template = DataObject.find((FileObject)tempFO);
                        DataObject newIfcDO = template.createFromTemplate(folder, CreateIfcElement.this.ifcName);
                        UndoWatcher.watch(newIfcDO);
                        FileObject newIfcFO = newIfcDO.getPrimaryFile();
                        this.newIfcName = newIfcFO.getPath();
                        CreateIfcElement.this.newIfc = (JavaClass)JavaMetamodel.getManager().getResource(newIfcFO).getClassifiers().iterator().next();
                    }
                    catch (DataObjectNotFoundException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }

                public void undoExternalChange() {
                    try {
                        FileObject newIfcFO = this.fs.findResource(this.newIfcName);
                        DataObject newIfcDO = DataObject.find((FileObject)newIfcFO);
                        newIfcDO.delete();
                    }
                    catch (DataObjectNotFoundException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }
            };
            ec.performExternalChange();
            JavaMetamodel.getManager().registerUndoElement(ec);
            List ifcTypeParams = this.newIfc.getTypeParameters();
            Iterator iter = this.typeParams.iterator();
            while (iter.hasNext()) {
                ifcTypeParams.add(((TypeParameter)iter.next()).duplicate());
            }
        }

        JavaClass getNewInterface() {
            return this.newIfc;
        }

        public String getText() {
            return this.text;
        }

        public String getDisplayText() {
            return this.text;
        }

        public FileObject getParentFile() {
            return null;
        }

        public Element getJavaElement() {
            return (Element)this.source.refImmediateComposite();
        }

        public PositionBounds getPosition() {
            return null;
        }
    }
}

