/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring;

import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.modules.refactoring.JavadocElement;

public class JavadocRenameElement
extends JavadocElement {
    private String newName;
    private boolean enabled = true;
    private JavadocRenameElement previous;
    private boolean changePerformed;

    public JavadocRenameElement(int offset, String txt, ClassMember f, String name, JavadocRenameElement prev) {
        super(offset, txt, f);
        this.newName = name;
        this.previous = prev;
    }

    public void performChange() {
        StringBuffer newComment = new StringBuffer(this.feature.getJavadocText());
        int start = this.textoffset;
        if (this.previous != null) {
            start += this.previous.getDiff();
        }
        newComment.replace(start, start + this.text.length(), this.newName);
        this.feature.setJavadocText(newComment.toString());
        this.changePerformed = true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.enabled = isEnabled;
    }

    private int getDiff() {
        int diff = 0;
        if (this.previous != null) {
            diff = this.previous.getDiff();
        }
        if (this.changePerformed) {
            diff += this.newName.length() - this.text.length();
        }
        return diff;
    }
}

