/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Stack;
import javax.imageio.stream.IIOByteBuffer;
import javax.imageio.stream.ImageInputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ImageInputStreamImpl
implements ImageInputStream {
    private boolean closed;
    private Stack markStack;
    byte[] buffer;
    protected int bitOffset;
    protected ByteOrder byteOrder;
    protected long flushedPos;
    protected long streamPos;

    protected final void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
    }

    public void close() throws IOException {
        this.checkClosed();
        this.closed = true;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public void flush() throws IOException {
        this.flushBefore(this.getStreamPosition());
    }

    public void flushBefore(long l) throws IOException {
        if (l < this.flushedPos) {
            throw new IndexOutOfBoundsException();
        }
        if (l > this.streamPos) {
            throw new IndexOutOfBoundsException();
        }
        this.flushedPos = l;
    }

    public int getBitOffset() throws IOException {
        this.checkClosed();
        return this.bitOffset;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public long getFlushedPosition() {
        return this.flushedPos;
    }

    public long getStreamPosition() throws IOException {
        this.checkClosed();
        return this.streamPos;
    }

    public boolean isCached() {
        return false;
    }

    public boolean isCachedFile() {
        return false;
    }

    public boolean isCachedMemory() {
        return false;
    }

    public long length() {
        return -1;
    }

    public void mark() {
        try {
            this.markStack.push(new Long(this.getStreamPosition()));
        }
        catch (IOException iOException) {}
    }

    public abstract int read() throws IOException;

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public abstract int read(byte[] var1, int var2, int var3) throws IOException;

    public int readBit() throws IOException {
        this.checkClosed();
        int n = this.bitOffset + 1 & 7;
        byte by = this.readByte();
        if (this.bitOffset != 0) {
            this.seek(this.getStreamPosition() - 1L);
            by = (byte)(by >> 8 - n);
        }
        this.bitOffset = n;
        return by & 1;
    }

    public long readBits(int n) throws IOException {
        this.checkClosed();
        if (n < 0 || n > 64) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return 0L;
        }
        long l = 0L;
        int n2 = 0;
        while (n2 < n) {
            l <<= 1;
            l |= (long)this.readBit();
            ++n2;
        }
        return l;
    }

    public boolean readBoolean() throws IOException {
        byte by = this.readByte();
        boolean bl = false;
        if (by != 0) {
            bl = true;
        }
        return bl;
    }

    public byte readByte() throws IOException {
        int n = this.read();
        if (n == -1) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public void readBytes(IIOByteBuffer iIOByteBuffer, int n) throws IOException {
        int n2 = this.read(iIOByteBuffer.getData(), iIOByteBuffer.getOffset(), n);
        if (n2 == -1 || n2 < n) {
            throw new EOFException();
        }
        iIOByteBuffer.setLength(n);
    }

    public char readChar() throws IOException {
        return (char)this.readShort();
    }

    public double readDouble() throws IOException {
        return this.readLong();
    }

    public float readFloat() throws IOException {
        return this.readInt();
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            byArray[n + n3] = this.readByte();
            ++n3;
        }
    }

    public void readFully(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            cArray[n + n3] = this.readChar();
            ++n3;
        }
    }

    public void readFully(double[] dArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            dArray[n + n3] = this.readDouble();
            ++n3;
        }
    }

    public void readFully(float[] fArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            fArray[n + n3] = this.readFloat();
            ++n3;
        }
    }

    public void readFully(int[] nArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            nArray[n + n3] = this.readInt();
            ++n3;
        }
    }

    public void readFully(long[] lArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            lArray[n + n3] = this.readLong();
            ++n3;
        }
    }

    public void readFully(short[] sArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            sArray[n + n3] = this.readShort();
            ++n3;
        }
    }

    public int readInt() throws IOException {
        int n = this.read(this.buffer, 0, 4);
        if (n == -1) {
            throw new EOFException();
        }
        if (this.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
            return (this.buffer[0] & 0xFF) + (this.buffer[1] << 8) + (this.buffer[2] << 16) + (this.buffer[3] << 24);
        }
        return (this.buffer[4] << 24) + (this.buffer[3] << 16) + (this.buffer[2] << 8) + (this.buffer[1] & 0xFF);
    }

    public String readLine() throws IOException {
        this.checkClosed();
        int n = -1;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        while (!bl && (n = this.read()) != -1) {
            switch (n) {
                case 13: {
                    long l = this.getStreamPosition();
                    if (this.read() != 10) {
                        this.seek(l);
                    }
                }
                case 10: {
                    bl = true;
                    break;
                }
                default: {
                    stringBuffer.append((char)n);
                }
            }
        }
        if (n == -1 && stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public long readLong() throws IOException {
        int n = this.read(this.buffer, 0, 8);
        if (n == -1) {
            throw new EOFException();
        }
        if (this.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
            return (long)((this.buffer[0] & 0xFF) + ((this.buffer[1] & 0xFF) << 8) + ((this.buffer[2] & 0xFF) << 16)) + (((long)this.buffer[3] & 0xFFL) << 24) + (((long)this.buffer[4] & 0xFFL) << 32) + (((long)this.buffer[5] & 0xFFL) << 40) + (((long)this.buffer[6] & 0xFFL) << 48) + ((long)this.buffer[7] << 56);
        }
        return ((long)this.buffer[7] << 56) + (((long)this.buffer[6] & 0xFFL) << 48) + (((long)this.buffer[5] & 0xFFL) << 40) + (((long)this.buffer[4] & 0xFFL) << 32) + (((long)this.buffer[3] & 0xFFL) << 24) + (long)((this.buffer[2] & 0xFF) << 16) + (long)((this.buffer[1] & 0xFF) << 8) + (long)(this.buffer[0] & 0xFF);
    }

    public short readShort() throws IOException {
        int n = this.read(this.buffer, 0, 2);
        if (n == -1) {
            throw new EOFException();
        }
        if (this.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
            return (short)((this.buffer[0] & 0xFF) + (this.buffer[1] << 8));
        }
        return (short)((this.buffer[0] << 8) + (this.buffer[1] & 0xFF));
    }

    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    public long readUnsignedInt() throws IOException {
        return this.readInt() & 0xFFFFFFFF;
    }

    public int readUnsignedShort() throws IOException {
        return this.readShort() & (char)-1;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String readUTF() throws IOException {
        String string;
        this.checkClosed();
        ByteOrder byteOrder = this.getByteOrder();
        this.setByteOrder(ByteOrder.BIG_ENDIAN);
        try {
            string = DataInputStream.readUTF(this);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.setByteOrder(byteOrder);
            throw throwable;
        }
        {
            Object var4_5 = null;
            this.setByteOrder(byteOrder);
            return string;
        }
    }

    public void reset() throws IOException {
        this.checkClosed();
        long l = (Long)this.markStack.pop();
        this.seek(l);
    }

    public void seek(long l) throws IOException {
        this.checkClosed();
        if (l < this.getFlushedPosition()) {
            throw new IndexOutOfBoundsException("position < flushed position");
        }
        this.streamPos = l;
        this.bitOffset = 0;
    }

    public void setBitOffset(int n) throws IOException {
        this.checkClosed();
        if (n < 0 || n > 7) {
            throw new IllegalArgumentException();
        }
        this.bitOffset = n;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public int skipBytes(int n) throws IOException {
        this.checkClosed();
        this.seek(this.getStreamPosition() + (long)n);
        this.bitOffset = 0;
        return n;
    }

    public long skipBytes(long l) throws IOException {
        this.checkClosed();
        this.seek(this.getStreamPosition() + l);
        this.bitOffset = 0;
        return l;
    }

    private final /* synthetic */ void this() {
        this.markStack = new Stack();
        this.buffer = new byte[8];
    }

    public ImageInputStreamImpl() {
        this.this();
    }
}

