/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.search;

import com.ca.commons.cbutil.CBBasicComboBoxRenderer;
import com.ca.commons.cbutil.CBButton;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBJComboBox;
import com.ca.commons.cbutil.CBPanel;
import com.ca.directory.jxplorer.search.SearchModel;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class JoinFilterPanel
extends CBPanel {
    CBPanel panel = new CBPanel();
    JCheckBox notCheckBox;
    static final String[] andOrArray = new String[]{CBIntText.get("And"), CBIntText.get("Or")};
    static final int AND = 0;
    static final int OR = 1;
    JLabel[] andOrLabel = new JLabel[50];
    CBJComboBox[] filterCombo = new CBJComboBox[50];
    CBJComboBox andOrCombo;
    CBButton[] btnEdit = new CBButton[50];
    int rowCount = 0;
    int labelCount = 0;
    SearchModel searchModel = new SearchModel();
    private static Logger log = Logger.getLogger(JoinFilterPanel.class.getName());

    public JoinFilterPanel(CBButton btnEdit) {
        this.notCheckBox = new JCheckBox(CBIntText.get("Not"));
        this.notCheckBox.setToolTipText(CBIntText.get("Not this filter"));
        this.makeLight();
        this.add(this.notCheckBox);
        this.newLine();
        this.makeHeavy();
        this.add(new JScrollPane(this.panel));
        this.makeLight();
        this.addFilterRow(btnEdit);
    }

    protected void addFilterRow(CBButton btnEdit) {
        if (this.rowCount < 50) {
            this.panel.newLine();
            this.panel.makeLight();
            if (this.rowCount == 0) {
                this.andOrCombo = new CBJComboBox(andOrArray);
                this.panel.add(this.andOrCombo);
                this.andOrCombo.setPreferredSize(new Dimension(50, 20));
                this.andOrCombo.setVisible(false);
            } else if (this.rowCount == 1) {
                this.andOrCombo = new CBJComboBox(andOrArray);
                this.panel.add(this.andOrCombo);
                this.andOrCombo.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        try {
                            for (int i = 0; i < JoinFilterPanel.this.labelCount; ++i) {
                                JoinFilterPanel.this.andOrLabel[i].setText(JoinFilterPanel.this.andOrCombo.getSelectedItem().toString());
                            }
                        }
                        catch (Exception ee) {
                            log.log(Level.WARNING, "Problem updating the 'And/Or' labels in the Join tab of the search dialog:", ee);
                        }
                    }
                });
                this.andOrCombo.setPreferredSize(new Dimension(50, 20));
            } else if (this.rowCount > 1) {
                this.andOrLabel[this.labelCount] = new JLabel();
                try {
                    this.andOrLabel[this.labelCount].setText(this.andOrCombo.getSelectedItem().toString());
                }
                catch (Exception e) {
                    this.andOrLabel[this.labelCount].setText(" ");
                    log.log(Level.WARNING, "Problem updating the 'And/Or' labels in the Join tab of the search dialog:", e);
                }
                this.panel.add(this.andOrLabel[this.labelCount]);
                ++this.labelCount;
            }
            this.panel.makeWide();
            ArrayList list = this.searchModel.getFilterNames(6);
            Object[] listOb = list.toArray();
            Arrays.sort(listOb, new SearchModel.StringComparator());
            this.filterCombo[this.rowCount] = new CBJComboBox(listOb);
            this.panel.add(this.filterCombo[this.rowCount]);
            this.filterCombo[this.rowCount].setPreferredSize(new Dimension(140, 20));
            this.filterCombo[this.rowCount].setRenderer(new CBBasicComboBoxRenderer(listOb));
            this.panel.makeLight();
            this.panel.add(btnEdit);
            ++this.rowCount;
            this.panel.revalidate();
        }
    }

    protected void updateFilterCombo(String item) {
        ArrayList list = this.searchModel.getFilterNames(2);
        list.add(item);
        for (int i = 0; i < this.rowCount; ++i) {
            this.filterCombo[i].setRenderer(new CBBasicComboBoxRenderer(list.toArray()));
            this.filterCombo[i].addItem(item);
        }
    }

    protected void removeFilterRow(CBButton btnEdit) {
        if (this.rowCount > 1) {
            --this.rowCount;
            if (this.rowCount == 1) {
                this.panel.remove(this.andOrCombo);
            }
            this.panel.remove(this.filterCombo[this.rowCount]);
            this.panel.remove(btnEdit);
            if (this.rowCount > 1) {
                --this.labelCount;
                this.panel.remove(this.andOrLabel[this.labelCount]);
            }
            this.panel.repaint();
        }
        this.panel.revalidate();
    }

    protected boolean isFilterValid() {
        try {
            for (int i = 0; i < this.rowCount; ++i) {
                String andOr;
                String name = this.filterCombo[i].getSelectedItem().toString();
                if (name.trim().length() <= 0) {
                    return false;
                }
                if (this.rowCount < 2 || (andOr = this.andOrCombo.getSelectedItem().toString()).trim().length() > 0) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected String getFilter() {
        StringBuffer buffy = new StringBuffer();
        for (int i = 0; i < this.rowCount; ++i) {
            buffy.append("JXFilter." + this.filterCombo[i].getSelectedItem().toString());
        }
        if (this.rowCount >= 2) {
            switch (this.andOrCombo.getSelectedIndex()) {
                case 0: {
                    buffy.insert(0, "&");
                    break;
                }
                case 1: {
                    buffy.insert(0, "|");
                }
            }
        }
        if (this.notCheckBox.isSelected()) {
            buffy.insert(0, "!");
        }
        return buffy.toString();
    }

    protected String getFilterComboValue(int row) {
        try {
            return this.filterCombo[row].getSelectedItem().toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected boolean displayFilter(ArrayList list, String value) {
        boolean not = value.startsWith("!");
        int andOr = -1;
        if (value.indexOf("&") < 2 && value.indexOf("&") > -1) {
            andOr = 0;
        } else if (value.indexOf("|") < 2 && value.indexOf("|") > -1) {
            andOr = 1;
        } else {
            return false;
        }
        this.setItems(not, andOr);
        String[] names = list.toArray(new String[list.size()]);
        for (int i = 0; i < names.length; ++i) {
            this.setItems(names[i], i);
        }
        return true;
    }

    protected void setItems(String filter, int row) {
        this.filterCombo[row].setSelectedItem(filter);
        this.panel.revalidate();
    }

    protected void setItems(boolean not, int index) {
        this.notCheckBox.setSelected(not);
        if (index == -1) {
            index = 0;
        }
        this.andOrCombo.setSelectedIndex(index);
        this.panel.revalidate();
    }
}

