/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.CompiledMethod;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class ReflectedCompiledMethod
extends CompiledMethod {
    private final Method method;

    public ReflectedCompiledMethod(RubyModule implementationClass, Arity arity, Visibility visibility, StaticScope staticScope, Object scriptObject, Method method, CallConfiguration callConfig) {
        super(implementationClass, arity, visibility, staticScope, scriptObject, callConfig);
        this.method = method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
        this.callConfig.pre(context, self, this.getImplementationClass(), name, block, this.staticScope, this);
        Ruby runtime = context.getRuntime();
        try {
            boolean isTrace = runtime.hasEventHooks();
            try {
                if (isTrace) {
                    runtime.callEventHooks(context, 3, context.getFile(), context.getLine(), name, this.getImplementationClass());
                }
                IRubyObject iRubyObject = (IRubyObject)this.method.invoke(this.$scriptObject, context, self, args, block);
                if (isTrace) {
                    Frame frame = context.getPreviousFrame();
                    runtime.callEventHooks(context, 4, frame.getFile(), frame.getLine(), name, this.getImplementationClass());
                }
                return iRubyObject;
            }
            catch (Throwable throwable) {
                try {
                    if (isTrace) {
                        Frame frame = context.getPreviousFrame();
                        runtime.callEventHooks(context, 4, frame.getFile(), frame.getLine(), name, this.getImplementationClass());
                    }
                    throw throwable;
                }
                catch (IllegalArgumentException e) {
                    throw RaiseException.createNativeRaiseException(runtime, e);
                }
                catch (IllegalAccessException e) {
                    throw RaiseException.createNativeRaiseException(runtime, e);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof JumpException.ReturnJump) {
                        IRubyObject iRubyObject = this.handleReturn(context, (JumpException.ReturnJump)cause);
                        return iRubyObject;
                    }
                    if (cause instanceof JumpException.RedoJump) {
                        IRubyObject iRubyObject = this.handleRedo(runtime);
                        return iRubyObject;
                    }
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                    throw RaiseException.createNativeRaiseException(runtime, cause);
                }
            }
        }
        finally {
            this.callConfig.post(context);
        }
    }
}

