/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.preferences.IPreferenceConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Assert;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

abstract class AbstractConfigurationBlock
implements IPreferenceConfigurationBlock {
    protected static final int INDENT = 20;
    private OverlayPreferenceStore fStore;
    private Map fCheckBoxes = new HashMap();
    private SelectionListener fCheckBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            AbstractConfigurationBlock.this.fStore.setValue((String)AbstractConfigurationBlock.this.fCheckBoxes.get(button), button.getSelection());
        }
    };
    private Map fTextFields = new HashMap();
    private ModifyListener fTextFieldListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            Text text = (Text)e.widget;
            AbstractConfigurationBlock.this.fStore.setValue((String)AbstractConfigurationBlock.this.fTextFields.get(text), text.getText());
        }
    };
    private ArrayList fNumberFields = new ArrayList();
    private ModifyListener fNumberFieldListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            AbstractConfigurationBlock.this.numberFieldChanged((Text)e.widget);
        }
    };
    private ArrayList fMasterSlaveListeners = new ArrayList();
    private StatusInfo fStatus;
    private final PreferencePage fMainPage;

    public AbstractConfigurationBlock(OverlayPreferenceStore store) {
        Assert.isNotNull((Object)store);
        this.fStore = store;
        this.fMainPage = null;
    }

    public AbstractConfigurationBlock(OverlayPreferenceStore store, PreferencePage mainPreferencePage) {
        Assert.isNotNull((Object)store);
        Assert.isNotNull((Object)mainPreferencePage);
        this.fStore = store;
        this.fMainPage = mainPreferencePage;
    }

    protected final ScrolledPageContent getParentScrolledComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ScrolledPageContent) && parent != null) {
            parent = parent.getParent();
        }
        if (parent instanceof ScrolledPageContent) {
            return (ScrolledPageContent)parent;
        }
        return null;
    }

    private final ExpandableComposite getParentExpandableComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ExpandableComposite) && parent != null) {
            parent = parent.getParent();
        }
        if (parent instanceof ExpandableComposite) {
            return (ExpandableComposite)parent;
        }
        return null;
    }

    protected void updateSectionStyle(ExpandableComposite excomposite) {
        excomposite.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
    }

    private void makeScrollableCompositeAware(Control control) {
        ScrolledPageContent parentScrolledComposite = this.getParentScrolledComposite(control);
        if (parentScrolledComposite != null) {
            parentScrolledComposite.adaptChild(control);
        }
    }

    private boolean isNestedInScrolledComposite(Composite parent) {
        return this.getParentScrolledComposite((Control)parent) != null;
    }

    protected Button addCheckBox(Composite parent, String label, String key, int indentation) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.fCheckBoxListener);
        this.makeScrollableCompositeAware((Control)checkBox);
        this.fCheckBoxes.put(checkBox, key);
        return checkBox;
    }

    protected Control[] addLabelledTextField(Composite composite, String label, String key, int textLimit, int indentation, boolean isNumber) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label labelControl = new Label(composite, 0);
        labelControl.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        labelControl.setLayoutData((Object)gd);
        Text textControl = new Text(composite, 2052);
        gd = new GridData(32);
        gd.widthHint = pixelConverter.convertWidthInCharsToPixels(textLimit + 1);
        textControl.setLayoutData((Object)gd);
        textControl.setTextLimit(textLimit);
        this.fTextFields.put(textControl, key);
        if (isNumber) {
            this.fNumberFields.add(textControl);
            textControl.addModifyListener(this.fNumberFieldListener);
        } else {
            textControl.addModifyListener(this.fTextFieldListener);
        }
        return new Control[]{labelControl, textControl};
    }

    protected void createDependency(Button master, Control slave) {
        this.createDependency(master, new Control[]{slave});
    }

    protected void createDependency(final Button master, final Control[] slaves) {
        Assert.isTrue((slaves.length > 0 ? 1 : 0) != 0);
        AbstractConfigurationBlock.indent(slaves[0]);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean state = master.getSelection();
                int i = 0;
                while (i < slaves.length) {
                    slaves[i].setEnabled(state);
                    ++i;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        master.addSelectionListener(listener);
        this.fMasterSlaveListeners.add(listener);
    }

    protected static void indent(Control control) {
        ((GridData)control.getLayoutData()).horizontalIndent += 20;
    }

    public void initialize() {
        this.initializeFields();
    }

    private void initializeFields() {
        String key;
        for (Button b : this.fCheckBoxes.keySet()) {
            key = (String)this.fCheckBoxes.get(b);
            b.setSelection(this.fStore.getBoolean(key));
        }
        for (Text t : this.fTextFields.keySet()) {
            key = (String)this.fTextFields.get(t);
            t.setText(this.fStore.getString(key));
        }
        for (SelectionListener listener : this.fMasterSlaveListeners) {
            listener.widgetSelected(null);
        }
        this.updateStatus(new StatusInfo());
    }

    public void performOk() {
    }

    public void performDefaults() {
        this.initializeFields();
    }

    IStatus getStatus() {
        if (this.fStatus == null) {
            this.fStatus = new StatusInfo();
        }
        return this.fStatus;
    }

    public void dispose() {
    }

    private void numberFieldChanged(Text textControl) {
        String number = textControl.getText();
        IStatus status = this.validatePositiveNumber(number);
        if (!status.matches(4)) {
            this.fStore.setValue((String)this.fTextFields.get(textControl), number);
        }
        this.updateStatus(status);
    }

    private IStatus validatePositiveNumber(String number) {
        StatusInfo status = new StatusInfo();
        if (number.length() == 0) {
            status.setError(PreferencesMessages.JavaEditorPreferencePage_empty_input);
        } else {
            try {
                int value = Integer.parseInt(number);
                if (value < 0) {
                    status.setError(Messages.format(PreferencesMessages.JavaEditorPreferencePage_invalid_input, number));
                }
            }
            catch (NumberFormatException numberFormatException) {
                status.setError(Messages.format(PreferencesMessages.JavaEditorPreferencePage_invalid_input, number));
            }
        }
        return status;
    }

    protected void updateStatus(IStatus status) {
        if (this.fMainPage == null) {
            return;
        }
        this.fMainPage.setValid(status.isOK());
        StatusUtil.applyToStatusLine((DialogPage)this.fMainPage, status);
    }

    protected final OverlayPreferenceStore getPreferenceStore() {
        return this.fStore;
    }

    protected Composite createSubsection(Composite parent, SectionManager manager, String label) {
        if (manager != null) {
            return manager.createSection(label);
        }
        Group group = new Group(parent, 32);
        group.setText(label);
        GridData data = new GridData(4, 0x1000000, true, false);
        group.setLayoutData((Object)data);
        return group;
    }

    protected final class SectionManager {
        private static final String __NONE = "__none";
        private Set fSections = new HashSet();
        private boolean fIsBeingManaged = false;
        private ExpansionAdapter fListener = new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ScrolledPageContent parentScrolledComposite;
                ExpandableComposite exComp;
                ExpandableComposite source = (ExpandableComposite)e.getSource();
                AbstractConfigurationBlock.this.updateSectionStyle(source);
                if (SectionManager.this.fIsBeingManaged) {
                    return;
                }
                if (e.getState()) {
                    try {
                        SectionManager.this.fIsBeingManaged = true;
                        for (ExpandableComposite composite : SectionManager.this.fSections) {
                            if (composite == source) continue;
                            composite.setExpanded(false);
                        }
                    }
                    finally {
                        SectionManager.this.fIsBeingManaged = false;
                    }
                    if (SectionManager.this.fLastOpenKey != null && SectionManager.this.fDialogSettingsStore != null) {
                        SectionManager.this.fDialogSettingsStore.setValue(SectionManager.this.fLastOpenKey, source.getText());
                    }
                } else if (!SectionManager.this.fIsBeingManaged && SectionManager.this.fLastOpenKey != null && SectionManager.this.fDialogSettingsStore != null) {
                    SectionManager.this.fDialogSettingsStore.setValue(SectionManager.this.fLastOpenKey, SectionManager.__NONE);
                }
                if ((exComp = AbstractConfigurationBlock.this.getParentExpandableComposite((Control)source)) != null) {
                    exComp.layout(true, true);
                }
                if ((parentScrolledComposite = AbstractConfigurationBlock.this.getParentScrolledComposite((Control)source)) != null) {
                    parentScrolledComposite.reflow(true);
                }
            }
        };
        private Composite fBody;
        private final String fLastOpenKey;
        private final IPreferenceStore fDialogSettingsStore;
        private ExpandableComposite fFirstChild = null;

        public SectionManager() {
            this(null, null);
        }

        public SectionManager(IPreferenceStore dialogSettingsStore, String lastOpenKey) {
            this.fDialogSettingsStore = dialogSettingsStore;
            this.fLastOpenKey = lastOpenKey;
        }

        private void manage(ExpandableComposite section) {
            if (section == null) {
                throw new NullPointerException();
            }
            if (this.fSections.add(section)) {
                section.addExpansionListener((IExpansionListener)this.fListener);
            }
            AbstractConfigurationBlock.this.makeScrollableCompositeAware((Control)section);
        }

        public Composite createSectionComposite(Composite parent) {
            ScrolledPageContent composite;
            Assert.isTrue((this.fBody == null ? 1 : 0) != 0);
            boolean isNested = AbstractConfigurationBlock.this.isNestedInScrolledComposite(parent);
            if (isNested) {
                composite = new Composite(parent, 0);
                this.fBody = composite;
            } else {
                composite = new ScrolledPageContent(parent);
                this.fBody = composite.getBody();
            }
            this.fBody.setLayout((Layout)new GridLayout());
            return composite;
        }

        public Composite createSection(String label) {
            Assert.isNotNull((Object)this.fBody);
            ExpandableComposite excomposite = new ExpandableComposite(this.fBody, 0, 50);
            if (this.fFirstChild == null) {
                this.fFirstChild = excomposite;
            }
            excomposite.setText(label);
            String last = null;
            if (this.fLastOpenKey != null && this.fDialogSettingsStore != null) {
                last = this.fDialogSettingsStore.getString(this.fLastOpenKey);
            }
            if (this.fFirstChild == excomposite && !__NONE.equals(last) || label.equals(last)) {
                excomposite.setExpanded(true);
                if (this.fFirstChild != excomposite) {
                    this.fFirstChild.setExpanded(false);
                }
            } else {
                excomposite.setExpanded(false);
            }
            excomposite.setLayoutData((Object)new GridData(4, 1, true, false));
            AbstractConfigurationBlock.this.updateSectionStyle(excomposite);
            this.manage(excomposite);
            Composite contents = new Composite((Composite)excomposite, 0);
            excomposite.setClient((Control)contents);
            return contents;
        }
    }
}

