/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsDialog;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public abstract class RelaunchLastAction
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow fWorkbenchWindow;
    private IAction fAction;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.fWorkbenchWindow = window;
    }

    public void run(IAction action) {
        try {
            ILaunchConfiguration configuration = this.getLastLaunch();
            if (configuration != null) {
                if (configuration.supportsMode(this.getMode())) {
                    DebugUITools.launch(configuration, this.getMode());
                } else {
                    String configName = configuration.getName();
                    String title = ActionMessages.RelaunchLastAction_Cannot_relaunch_1;
                    String message = MessageFormat.format((String)ActionMessages.RelaunchLastAction_Cannot_relaunch___0___because_it_does_not_support__2__mode_2, (Object[])new String[]{configName, this.getMode()});
                    MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
                }
            } else {
                this.openLaunchConfigurationDialog();
            }
        }
        catch (CoreException ce) {
            DebugUIPlugin.errorDialog(this.getShell(), ActionMessages.RelaunchLastAction_Error_relaunching_3, ActionMessages.RelaunchLastAction_Error_encountered_attempting_to_relaunch_4, ce);
        }
    }

    private void openLaunchConfigurationDialog() {
        IWorkbenchWindow dwindow = DebugUIPlugin.getActiveWorkbenchWindow();
        if (dwindow == null) {
            return;
        }
        LaunchConfigurationsDialog dialog = new LaunchConfigurationsDialog(DebugUIPlugin.getShell(), DebugUIPlugin.getDefault().getLaunchConfigurationManager().getDefaultLanuchGroup(this.getMode()));
        dialog.setOpenMode(2);
        dialog.open();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.fAction == null) {
            this.initialize(action);
        }
    }

    private void initialize(IAction action) {
        this.fAction = action;
        action.setEnabled(this.existsConfigTypesForMode());
    }

    private boolean existsConfigTypesForMode() {
        ILaunchConfigurationType[] configTypes = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationTypes();
        int i = 0;
        while (i < configTypes.length) {
            ILaunchConfigurationType configType = configTypes[i];
            if (configType.supportsMode(this.getMode())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected ILaunchConfiguration getLastLaunch() {
        return DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLastLaunch(this.getLaunchGroupId());
    }

    protected Shell getShell() {
        return this.fWorkbenchWindow.getShell();
    }

    public abstract String getMode();

    public abstract String getLaunchGroupId();
}

