/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.adapters;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDBaseAdapter;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.model.IActionProvider;
import org.eclipse.wst.xsd.ui.internal.adt.outline.ITreeElement;
import org.eclipse.wst.xsd.ui.internal.editor.Messages;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDRedefinableComponent;
import org.eclipse.xsd.XSDRedefine;
import org.eclipse.xsd.XSDRedefineContent;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public class XSDSchemaDirectiveAdapter
extends XSDBaseAdapter
implements IActionProvider {
    public Image getImage() {
        XSDSchemaDirective object = (XSDSchemaDirective)this.target;
        if (object instanceof XSDImport) {
            return XSDEditorPlugin.getXSDImage("icons/XSDImport.gif");
        }
        if (object instanceof XSDInclude) {
            return XSDEditorPlugin.getXSDImage("icons/XSDInclude.gif");
        }
        if (object instanceof XSDRedefine) {
            return XSDEditorPlugin.getXSDImage("icons/XSDRedefine.gif");
        }
        return null;
    }

    public String getText() {
        XSDImport importObj;
        String namespace;
        XSDSchemaDirective directive = (XSDSchemaDirective)this.target;
        String result = "";
        String location = directive.getSchemaLocation();
        result = location == null || location.equals("") ? "(" + Messages._UI_LABEL_NO_LOCATION_SPECIFIED + ")" : location;
        if (directive instanceof XSDImport && (namespace = (importObj = (XSDImport)directive).getNamespace()) != null) {
            result = String.valueOf(result) + "  {" + namespace + "}";
        }
        return result;
    }

    public ITreeElement[] getChildren() {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.target instanceof XSDRedefine) {
            XSDRedefine redefine = (XSDRedefine)this.target;
            Iterator i = redefine.getContents().iterator();
            while (i.hasNext()) {
                XSDRedefineContent redefineContent = (XSDRedefineContent)i.next();
                if (redefineContent instanceof XSDAttributeGroupDefinition || redefineContent instanceof XSDModelGroupDefinition) {
                    list.add(redefineContent);
                    continue;
                }
                if (redefineContent instanceof XSDRedefinableComponent) {
                    XSDRedefinableComponent comp = (XSDRedefinableComponent)redefineContent;
                    if (!(comp instanceof XSDAttributeGroupDefinition) && !(comp instanceof XSDModelGroupDefinition) && !(comp instanceof XSDComplexTypeDefinition) && !(comp instanceof XSDSimpleTypeDefinition)) continue;
                    list.add(comp);
                    continue;
                }
                if (redefineContent instanceof XSDComplexTypeDefinition) {
                    list.add(redefineContent);
                    continue;
                }
                if (!(redefineContent instanceof XSDSimpleTypeDefinition)) continue;
                list.add(redefineContent);
            }
        }
        ArrayList adapterList = new ArrayList();
        this.populateAdapterList(list, adapterList);
        return adapterList.toArray(new ITreeElement[0]);
    }

    public String[] getActions(Object object) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("OpenInNewEditor");
        list.add("org.eclipse.wst.xsd.ui.internal.common.actions.DeleteXSDConcreteComponentAction");
        list.add("org.eclipse.jface.action.Separator");
        list.add("org.eclipse.wst.xsd.ui.internal.adt.actions.ShowPropertiesViewAction");
        return list.toArray(new String[0]);
    }
}

