/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeLifecycleListener;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerType;
import org.eclipse.wst.server.core.util.SocketUtil;
import org.eclipse.wst.server.ui.editor.ServerEditorPart;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.command.SetServerAutoPublishDefaultCommand;
import org.eclipse.wst.server.ui.internal.command.SetServerAutoPublishTimeCommand;
import org.eclipse.wst.server.ui.internal.command.SetServerConfigurationFolderCommand;
import org.eclipse.wst.server.ui.internal.command.SetServerHostnameCommand;
import org.eclipse.wst.server.ui.internal.command.SetServerNameCommand;
import org.eclipse.wst.server.ui.internal.command.SetServerRuntimeCommand;
import org.eclipse.wst.server.ui.internal.wizard.ClosableWizardDialog;
import org.eclipse.wst.server.ui.internal.wizard.TaskWizard;
import org.eclipse.wst.server.ui.internal.wizard.WizardTaskUtil;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class OverviewEditorPart
extends ServerEditorPart {
    protected Text serverName;
    protected Text serverConfigurationName;
    protected Text hostname;
    protected Combo runtimeCombo;
    protected Button autoPublishDefault;
    protected Button autoPublishDisable;
    protected Button autoPublishOverride;
    protected Spinner autoPublishTime;
    protected Color colorDefault;
    protected Color colorRed;
    protected boolean updating;
    protected IRuntime[] runtimes;
    protected PropertyChangeListener listener;
    protected IRuntimeLifecycleListener runtimeListener;

    protected void addChangeListener() {
        this.listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getPropertyName().equals("configuration-id") && OverviewEditorPart.this.serverConfigurationName != null) {
                    IFolder folder = OverviewEditorPart.this.getServer().getServerConfiguration();
                    if (folder == null || !folder.exists()) {
                        OverviewEditorPart.this.serverConfigurationName.setForeground(OverviewEditorPart.this.colorRed);
                    } else {
                        OverviewEditorPart.this.serverConfigurationName.setForeground(OverviewEditorPart.this.colorDefault);
                    }
                }
                OverviewEditorPart.this.validate();
                if (OverviewEditorPart.this.updating) {
                    return;
                }
                OverviewEditorPart.this.updating = true;
                if (event.getPropertyName().equals("name")) {
                    OverviewEditorPart.this.updateNames();
                } else if (event.getPropertyName().equals("hostname") && OverviewEditorPart.this.hostname != null) {
                    OverviewEditorPart.this.hostname.setText((String)event.getNewValue());
                } else if (event.getPropertyName().equals("runtime-id")) {
                    String runtimeId = (String)event.getNewValue();
                    IRuntime runtime = null;
                    if (runtimeId != null) {
                        runtime = ServerCore.findRuntime((String)runtimeId);
                    }
                    if (OverviewEditorPart.this.runtimeCombo != null) {
                        int size = OverviewEditorPart.this.runtimes.length;
                        int i = 0;
                        while (i < size) {
                            if (OverviewEditorPart.this.runtimes[i].equals(runtime)) {
                                OverviewEditorPart.this.runtimeCombo.select(i);
                            }
                            ++i;
                        }
                    }
                } else if (event.getPropertyName().equals("configuration-id") && OverviewEditorPart.this.serverConfigurationName != null) {
                    String path = (String)event.getNewValue();
                    OverviewEditorPart.this.serverConfigurationName.setText(path);
                } else if (event.getPropertyName().equals("auto-publish-time")) {
                    Integer curAutoPublishTime = (Integer)event.getNewValue();
                    OverviewEditorPart.this.autoPublishTime.setSelection(curAutoPublishTime.intValue());
                    OverviewEditorPart.this.validate();
                } else if (event.getPropertyName().equals("auto-publish-setting")) {
                    Integer autoPublishSetting = (Integer)event.getNewValue();
                    int setting = autoPublishSetting;
                    OverviewEditorPart.this.autoPublishDefault.setSelection(setting == 0);
                    OverviewEditorPart.this.autoPublishOverride.setSelection(setting == 2);
                    OverviewEditorPart.this.autoPublishDisable.setSelection(setting == 1);
                    OverviewEditorPart.this.autoPublishTime.setEnabled(setting == 2);
                    OverviewEditorPart.this.validate();
                }
                OverviewEditorPart.this.updating = false;
            }
        };
        if (this.server != null) {
            this.server.addPropertyChangeListener(this.listener);
        }
    }

    protected void updateNames() {
        if (this.serverName != null) {
            this.serverName.setText(this.server.getName());
        }
    }

    public final void createPartControl(Composite parent) {
        FormToolkit toolkit = this.getFormToolkit(parent.getDisplay());
        ScrolledForm form = toolkit.createScrolledForm(parent);
        form.setText(Messages.serverEditorOverviewPageTitle);
        form.getBody().setLayout((Layout)new GridLayout());
        Composite columnComp = toolkit.createComposite(form.getBody());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 10;
        columnComp.setLayout((Layout)layout);
        columnComp.setLayoutData((Object)new GridData(784));
        Composite leftColumnComp = toolkit.createComposite(columnComp);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 0;
        leftColumnComp.setLayout((Layout)layout);
        leftColumnComp.setLayoutData((Object)new GridData(784));
        this.createGeneralSection(leftColumnComp, toolkit);
        this.insertSections(leftColumnComp, "org.eclipse.wst.server.editor.overview.left");
        Composite rightColumnComp = toolkit.createComposite(columnComp);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 0;
        rightColumnComp.setLayout((Layout)layout);
        rightColumnComp.setLayoutData((Object)new GridData(784));
        this.createAutoPublishSection(rightColumnComp, toolkit);
        this.insertSections(rightColumnComp, "org.eclipse.wst.server.editor.overview.right");
        form.reflow(true);
        this.initialize();
    }

    protected void createGeneralSection(Composite leftColumnComp, FormToolkit toolkit) {
        ILaunchConfigurationType launchType;
        IServerType serverType;
        Section section = toolkit.createSection(leftColumnComp, 458);
        section.setText(Messages.serverEditorOverviewGeneralSection);
        section.setDescription(Messages.serverEditorOverviewGeneralDescription);
        section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 15;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(784));
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        whs.setHelp((Control)composite, "org.eclipse.wst.server.ui.seop0000");
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
        if (this.server != null) {
            this.createLabel(toolkit, composite, Messages.serverEditorOverviewServerName);
            this.serverName = toolkit.createText(composite, this.server.getName());
            GridData data = new GridData(768);
            data.horizontalSpan = 2;
            this.serverName.setLayoutData((Object)data);
            this.serverName.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (OverviewEditorPart.this.updating) {
                        return;
                    }
                    OverviewEditorPart.this.updating = true;
                    OverviewEditorPart.this.execute((IUndoableOperation)new SetServerNameCommand(OverviewEditorPart.this.getServer(), OverviewEditorPart.this.serverName.getText()));
                    OverviewEditorPart.this.updating = false;
                }
            });
            whs.setHelp((Control)this.serverName, "org.eclipse.wst.server.ui.seop0002");
            this.createLabel(toolkit, composite, Messages.serverEditorOverviewServerHostname);
            this.hostname = toolkit.createText(composite, this.server.getHost());
            data = new GridData(768);
            data.horizontalSpan = 2;
            this.hostname.setLayoutData((Object)data);
            this.hostname.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (OverviewEditorPart.this.updating) {
                        return;
                    }
                    OverviewEditorPart.this.updating = true;
                    OverviewEditorPart.this.execute((IUndoableOperation)new SetServerHostnameCommand(OverviewEditorPart.this.getServer(), OverviewEditorPart.this.hostname.getText()));
                    OverviewEditorPart.this.updating = false;
                }
            });
            whs.setHelp((Control)this.hostname, "org.eclipse.wst.server.ui.seop0006");
        }
        if (this.server != null && this.server.getServerType() != null && this.server.getServerType().hasRuntime()) {
            final IRuntime runtime = this.server.getRuntime();
            this.createLabel(toolkit, composite, Messages.serverEditorOverviewRuntime);
            IRuntimeType runtimeType = this.server.getServerType().getRuntimeType();
            this.runtimes = ServerUIPlugin.getRuntimes(runtimeType);
            this.runtimeCombo = new Combo(composite, 8);
            this.runtimeCombo.setLayoutData((Object)new GridData(768));
            this.updateRuntimeCombo();
            int size = this.runtimes.length;
            int i = 0;
            while (i < size) {
                if (this.runtimes[i].equals(runtime)) {
                    this.runtimeCombo.select(i);
                }
                ++i;
            }
            this.runtimeCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        if (OverviewEditorPart.this.updating) {
                            return;
                        }
                        OverviewEditorPart.this.updating = true;
                        IRuntime newRuntime = OverviewEditorPart.this.runtimes[OverviewEditorPart.this.runtimeCombo.getSelectionIndex()];
                        OverviewEditorPart.this.execute((IUndoableOperation)new SetServerRuntimeCommand(OverviewEditorPart.this.getServer(), newRuntime));
                        OverviewEditorPart.this.updating = false;
                    }
                    catch (Exception exception) {}
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            whs.setHelp((Control)this.runtimeCombo, "org.eclipse.wst.server.ui.seop0008");
            Hyperlink link = toolkit.createHyperlink(composite, Messages.serverEditorOverviewRuntimeEdit, 0);
            link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    OverviewEditorPart.this.editRuntime(runtime);
                }
            });
            link.setLayoutData((Object)new GridData(128));
            this.runtimeListener = new IRuntimeLifecycleListener(){

                public void runtimeChanged(IRuntime runtime2) {
                    Display.getDefault().syncExec(new Runnable(this, runtime2, runtime){
                        final /* synthetic */ 6 this$1;
                        private final /* synthetic */ IRuntime val$runtime2;
                        private final /* synthetic */ IRuntime val$runtime;
                        {
                            this.this$1 = var1_1;
                            this.val$runtime2 = iRuntime;
                            this.val$runtime = iRuntime2;
                        }

                        public void run() {
                            if (this.val$runtime2.equals(6.access$0(this.this$1).getServer().getRuntime())) {
                                try {
                                    if (6.access$0(this.this$1).updating) {
                                        return;
                                    }
                                    6.access$0(this.this$1).updating = true;
                                    6.access$0(this.this$1).execute((IUndoableOperation)new SetServerRuntimeCommand(6.access$0(this.this$1).getServer(), this.val$runtime2));
                                    6.access$0(this.this$1).updating = false;
                                }
                                catch (Exception exception) {}
                            }
                            if (6.access$0(this.this$1).runtimeCombo != null) {
                                6.access$0(this.this$1).updateRuntimeCombo();
                                int size2 = 6.access$0(this.this$1).runtimes.length;
                                int i = 0;
                                while (i < size2) {
                                    if (6.access$0(this.this$1).runtimes[i].equals(this.val$runtime)) {
                                        6.access$0(this.this$1).runtimeCombo.select(i);
                                    }
                                    ++i;
                                }
                            }
                        }
                    });
                }

                public void runtimeAdded(IRuntime runtime2) {
                    Display.getDefault().syncExec(new Runnable(this, runtime){
                        final /* synthetic */ 6 this$1;
                        private final /* synthetic */ IRuntime val$runtime;
                        {
                            this.this$1 = var1_1;
                            this.val$runtime = iRuntime;
                        }

                        public void run() {
                            if (6.access$0(this.this$1).runtimeCombo != null) {
                                6.access$0(this.this$1).updateRuntimeCombo();
                                int size2 = 6.access$0(this.this$1).runtimes.length;
                                int i = 0;
                                while (i < size2) {
                                    if (6.access$0(this.this$1).runtimes[i].equals(this.val$runtime)) {
                                        6.access$0(this.this$1).runtimeCombo.select(i);
                                    }
                                    ++i;
                                }
                            }
                        }
                    });
                }

                public void runtimeRemoved(IRuntime runtime2) {
                    Display.getDefault().syncExec(new Runnable(this, runtime){
                        final /* synthetic */ 6 this$1;
                        private final /* synthetic */ IRuntime val$runtime;
                        {
                            this.this$1 = var1_1;
                            this.val$runtime = iRuntime;
                        }

                        public void run() {
                            if (6.access$0(this.this$1).runtimeCombo != null) {
                                6.access$0(this.this$1).updateRuntimeCombo();
                                int size2 = 6.access$0(this.this$1).runtimes.length;
                                int i = 0;
                                while (i < size2) {
                                    if (6.access$0(this.this$1).runtimes[i].equals(this.val$runtime)) {
                                        6.access$0(this.this$1).runtimeCombo.select(i);
                                    }
                                    ++i;
                                }
                            }
                        }
                    });
                }

                static /* synthetic */ OverviewEditorPart access$0(6 var0) {
                    return var0.OverviewEditorPart.this;
                }
            };
            ServerCore.addRuntimeLifecycleListener((IRuntimeLifecycleListener)this.runtimeListener);
        }
        if (this.server != null && this.server.getServerType().hasServerConfiguration()) {
            this.createLabel(toolkit, composite, Messages.serverEditorOverviewServerConfigurationPath);
            IFolder folder = this.server.getServerConfiguration();
            this.serverConfigurationName = folder == null ? toolkit.createText(composite, Messages.elementUnknownName) : toolkit.createText(composite, "" + this.server.getServerConfiguration().getFullPath());
            this.colorDefault = this.serverConfigurationName.getForeground();
            this.colorRed = this.serverConfigurationName.getDisplay().getSystemColor(3);
            if (folder == null || !folder.exists()) {
                this.serverConfigurationName.setForeground(this.colorRed);
            }
            this.serverConfigurationName.setEditable(false);
            this.serverConfigurationName.setLayoutData((Object)new GridData(768));
            whs.setHelp((Control)this.serverConfigurationName, "org.eclipse.wst.server.ui.seop0004");
            final IFolder currentFolder = this.server.getServerConfiguration();
            Button browse = toolkit.createButton(composite, Messages.serverEditorOverviewServerConfigurationBrowse, 8);
            browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Object[] result;
                    ContainerSelectionDialog dialog = new ContainerSelectionDialog(OverviewEditorPart.this.serverConfigurationName.getShell(), (IContainer)currentFolder, true, Messages.serverEditorOverviewServerConfigurationBrowseMessage);
                    dialog.showClosedProjects(false);
                    if (dialog.open() != 1 && (result = dialog.getResult()) != null && result.length == 1) {
                        IPath path = (IPath)result[0];
                        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                        IResource resource = root.findMember(path);
                        if (resource != null && resource instanceof IFolder) {
                            IFolder folder2 = (IFolder)resource;
                            if (OverviewEditorPart.this.updating) {
                                return;
                            }
                            OverviewEditorPart.this.updating = true;
                            OverviewEditorPart.this.execute((IUndoableOperation)new SetServerConfigurationFolderCommand(OverviewEditorPart.this.getServer(), folder2));
                            OverviewEditorPart.this.serverConfigurationName.setText(folder2.getFullPath().toString());
                            OverviewEditorPart.this.updating = false;
                        }
                    }
                }
            });
            browse.setLayoutData((Object)new GridData(128));
        }
        if (this.server != null && ((serverType = this.server.getServerType()).supportsLaunchMode("run") || serverType.supportsLaunchMode("debug") || serverType.supportsLaunchMode("profile")) && (launchType = ((ServerType)serverType).getLaunchConfigurationType()) != null && launchType.isPublic()) {
            final Hyperlink link = toolkit.createHyperlink(composite, Messages.serverEditorOverviewOpenLaunchConfiguration, 0);
            GridData data = new GridData();
            data.horizontalSpan = 2;
            link.setLayoutData((Object)data);
            link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    try {
                        ILaunchConfiguration launchConfig = ((Server)OverviewEditorPart.this.getServer()).getLaunchConfiguration(true, null);
                        DebugUITools.openLaunchConfigurationPropertiesDialog((Shell)link.getShell(), (ILaunchConfiguration)launchConfig, (String)"org.eclipse.debug.ui.launchGroup.run");
                    }
                    catch (CoreException ce) {
                        Trace.trace(Trace.SEVERE, "Could not create launch configuration", ce);
                    }
                }
            });
        }
    }

    protected void createAutoPublishSection(Composite rightColumnComp, FormToolkit toolkit) {
        Section section = toolkit.createSection(rightColumnComp, 394);
        section.setText(Messages.serverEditorOverviewAutoPublishSection);
        section.setDescription(Messages.serverEditorOverviewAutoPublishDescription);
        section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 15;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(784));
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        whs.setHelp((Control)composite, "org.eclipse.wst.server.ui.seop0000");
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
        if (this.server != null) {
            Server svr = (Server)this.server;
            int publishSetting = svr.getAutoPublishSetting();
            this.autoPublishDefault = toolkit.createButton(composite, Messages.serverEditorOverviewAutoPublishDefault, 16);
            GridData data = new GridData(768);
            this.autoPublishDefault.setLayoutData((Object)data);
            this.autoPublishDefault.setSelection(publishSetting == 0);
            whs.setHelp((Control)this.autoPublishDefault, "org.eclipse.wst.server.ui.seop0010");
            Hyperlink editDefaults = toolkit.createHyperlink(composite, Messages.serverEditorOverviewAutoPublishDefaultEdit, 0);
            editDefaults.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    OverviewEditorPart.this.showPreferencePage();
                }
            });
            editDefaults.setLayoutData((Object)new GridData(128));
            whs.setHelp((Control)editDefaults, "org.eclipse.wst.server.ui.seop0010");
            this.autoPublishDisable = toolkit.createButton(composite, Messages.serverEditorOverviewAutoPublishDisable, 16);
            data = new GridData(768);
            data.horizontalSpan = 2;
            this.autoPublishDisable.setLayoutData((Object)data);
            this.autoPublishDisable.setSelection(publishSetting == 1);
            whs.setHelp((Control)this.autoPublishDisable, "org.eclipse.wst.server.ui.seop0016");
            this.autoPublishOverride = toolkit.createButton(composite, Messages.serverEditorOverviewAutoPublishOverride, 16);
            this.autoPublishOverride.setSelection(publishSetting == 2);
            data = new GridData(768);
            data.horizontalSpan = 2;
            this.autoPublishOverride.setLayoutData((Object)data);
            whs.setHelp((Control)this.autoPublishOverride, "org.eclipse.wst.server.ui.seop0012");
            final Label autoPublishTimeLabel = toolkit.createLabel(composite, Messages.serverEditorOverviewAutoPublishOverrideInterval);
            data = new GridData();
            data.horizontalIndent = 20;
            autoPublishTimeLabel.setLayoutData((Object)data);
            autoPublishTimeLabel.setEnabled(this.autoPublishOverride.getSelection());
            this.autoPublishTime = new Spinner(composite, 2048);
            this.autoPublishTime.setMinimum(0);
            this.autoPublishTime.setMaximum(120);
            this.autoPublishTime.setSelection(svr.getAutoPublishTime());
            data = new GridData(32);
            data.widthHint = 60;
            this.autoPublishTime.setLayoutData((Object)data);
            this.autoPublishTime.setEnabled(this.autoPublishOverride.getSelection());
            whs.setHelp((Control)this.autoPublishTime, "org.eclipse.wst.server.ui.seop0012");
            this.autoPublishOverride.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (OverviewEditorPart.this.updating || !OverviewEditorPart.this.autoPublishOverride.getSelection()) {
                        return;
                    }
                    OverviewEditorPart.this.updating = true;
                    OverviewEditorPart.this.execute((IUndoableOperation)new SetServerAutoPublishDefaultCommand(OverviewEditorPart.this.getServer(), 2));
                    OverviewEditorPart.this.updating = false;
                    autoPublishTimeLabel.setEnabled(OverviewEditorPart.this.autoPublishOverride.getSelection());
                    OverviewEditorPart.this.autoPublishTime.setEnabled(OverviewEditorPart.this.autoPublishOverride.getSelection());
                    OverviewEditorPart.this.validate();
                }
            });
            this.autoPublishDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (OverviewEditorPart.this.updating || !OverviewEditorPart.this.autoPublishDefault.getSelection()) {
                        return;
                    }
                    OverviewEditorPart.this.updating = true;
                    OverviewEditorPart.this.execute((IUndoableOperation)new SetServerAutoPublishDefaultCommand(OverviewEditorPart.this.getServer(), 0));
                    OverviewEditorPart.this.updating = false;
                    autoPublishTimeLabel.setEnabled(OverviewEditorPart.this.autoPublishOverride.getSelection());
                    OverviewEditorPart.this.autoPublishTime.setEnabled(OverviewEditorPart.this.autoPublishOverride.getSelection());
                    OverviewEditorPart.this.validate();
                }
            });
            this.autoPublishDisable.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (OverviewEditorPart.this.updating || !OverviewEditorPart.this.autoPublishDisable.getSelection()) {
                        return;
                    }
                    OverviewEditorPart.this.updating = true;
                    OverviewEditorPart.this.execute((IUndoableOperation)new SetServerAutoPublishDefaultCommand(OverviewEditorPart.this.getServer(), 1));
                    OverviewEditorPart.this.updating = false;
                    autoPublishTimeLabel.setEnabled(OverviewEditorPart.this.autoPublishOverride.getSelection());
                    OverviewEditorPart.this.autoPublishTime.setEnabled(OverviewEditorPart.this.autoPublishOverride.getSelection());
                    OverviewEditorPart.this.validate();
                }
            });
            this.autoPublishTime.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (OverviewEditorPart.this.updating) {
                        return;
                    }
                    OverviewEditorPart.this.updating = true;
                    try {
                        OverviewEditorPart.this.execute((IUndoableOperation)new SetServerAutoPublishTimeCommand(OverviewEditorPart.this.getServer(), OverviewEditorPart.this.autoPublishTime.getSelection()));
                    }
                    catch (Exception exception) {}
                    OverviewEditorPart.this.updating = false;
                    OverviewEditorPart.this.validate();
                }
            });
        }
    }

    protected void editRuntime(IRuntime runtime) {
        IRuntimeWorkingCopy runtimeWorkingCopy = runtime.createWorkingCopy();
        if (this.showWizard(runtimeWorkingCopy) != 1) {
            try {
                runtimeWorkingCopy.save(false, null);
            }
            catch (Exception exception) {}
        }
    }

    protected boolean showPreferencePage() {
        String id = "org.eclipse.wst.server.ui.preferencePage";
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getSite().getShell(), (String)id, (String[])new String[]{id}, null);
        return dialog.open() == 0;
    }

    protected int showWizard(IRuntimeWorkingCopy runtimeWorkingCopy) {
        String title = Messages.wizEditRuntimeWizardTitle;
        final WizardFragment fragment2 = ServerUIPlugin.getWizardFragment(runtimeWorkingCopy.getRuntimeType().getId());
        if (fragment2 == null) {
            return 1;
        }
        TaskModel taskModel = new TaskModel();
        taskModel.putObject("runtime", (Object)runtimeWorkingCopy);
        WizardFragment fragment = new WizardFragment(){

            protected void createChildFragments(List list) {
                list.add(fragment2);
                list.add(new WizardFragment(this){
                    final /* synthetic */ 17 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void performFinish(IProgressMonitor monitor) throws CoreException {
                        WizardTaskUtil.saveRuntime(this.getTaskModel(), monitor);
                    }
                });
            }
        };
        TaskWizard wizard = new TaskWizard(title, fragment, taskModel);
        wizard.setForcePreviousAndNextButtons(true);
        ClosableWizardDialog dialog = new ClosableWizardDialog(this.getEditorSite().getShell(), wizard);
        return dialog.open();
    }

    protected void updateRuntimeCombo() {
        int i;
        IRuntimeType runtimeType = this.server.getServerType().getRuntimeType();
        this.runtimes = ServerUIPlugin.getRuntimes(runtimeType);
        if (SocketUtil.isLocalhost((String)this.server.getHost()) && this.runtimes != null) {
            ArrayList<IRuntime> runtimes2 = new ArrayList<IRuntime>();
            int size = this.runtimes.length;
            i = 0;
            while (i < size) {
                IRuntime runtime2 = this.runtimes[i];
                if (!runtime2.isStub()) {
                    runtimes2.add(runtime2);
                }
                ++i;
            }
            this.runtimes = new IRuntime[runtimes2.size()];
            runtimes2.toArray(this.runtimes);
        }
        int size = this.runtimes.length;
        String[] items = new String[size];
        i = 0;
        while (i < size) {
            items[i] = this.runtimes[i].getName();
            ++i;
        }
        this.runtimeCombo.setItems(items);
    }

    protected Label createLabel(FormToolkit toolkit, Composite parent, String text) {
        Label label = toolkit.createLabel(parent, text);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        return label;
    }

    public void dispose() {
        super.dispose();
        if (this.server != null) {
            this.server.removePropertyChangeListener(this.listener);
        }
        if (this.runtimeListener != null) {
            ServerCore.removeRuntimeLifecycleListener((IRuntimeLifecycleListener)this.runtimeListener);
        }
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.addChangeListener();
        this.initialize();
    }

    protected void initialize() {
        if (this.serverName == null) {
            return;
        }
        this.updating = true;
        if (this.server != null) {
            this.serverName.setText(this.server.getName());
            if (this.readOnly) {
                this.serverName.setEditable(false);
            } else {
                this.serverName.setEditable(true);
            }
        }
        this.updating = false;
        this.validate();
    }

    protected void validate() {
        int i;
        IFolder folder;
        if (this.server != null && this.server.getServerType().hasServerConfiguration() && ((folder = this.getServer().getServerConfiguration()) == null || !folder.exists())) {
            this.setErrorMessage(Messages.errorMissingConfiguration);
            return;
        }
        if (this.autoPublishTime.isEnabled() && this.autoPublishOverride.getSelection() && (i = this.autoPublishTime.getSelection()) < 1) {
            this.setErrorMessage(NLS.bind((String)Messages.serverEditorOverviewAutoPublishInvalid, (Object)"1"));
            return;
        }
        this.setErrorMessage(null);
    }

    public void setFocus() {
        if (this.serverName != null) {
            this.serverName.setFocus();
        } else if (this.serverConfigurationName != null) {
            this.serverConfigurationName.setFocus();
        }
    }
}

