/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.contentmodel.modelqueryimpl;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.XMLCoreMessages;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.ContentModelManager;
import org.eclipse.wst.xml.core.internal.contentmodel.internal.annotation.AnnotationUtility;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.CMDocumentManager;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.CMDocumentManagerListener;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.CMDocumentReferenceProvider;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMDocumentCache;

public class CMDocumentManagerImpl
implements CMDocumentManager {
    protected CMDocumentCache cmDocumentCache;
    protected CMDocumentReferenceProvider cmDocumentReferenceProvider;
    protected List listenerList = new Vector();
    protected Hashtable propertyTable = new Hashtable();
    protected Hashtable publicIdTable = new Hashtable();
    static /* synthetic */ Class class$0;

    public CMDocumentManagerImpl(CMDocumentCache cmDocumentCache, CMDocumentReferenceProvider cmDocumentReferenceProvider) {
        this.cmDocumentCache = cmDocumentCache;
        this.cmDocumentReferenceProvider = cmDocumentReferenceProvider;
        this.setPropertyEnabled("autoLoad", true);
        this.setPropertyEnabled("useCachedResovledURI", false);
    }

    public CMDocumentCache getCMDocumentCache() {
        return this.cmDocumentCache;
    }

    public void setPropertyEnabled(String propertyName, boolean value) {
        this.propertyTable.put(propertyName, value ? "true" : "false");
        Iterator i = this.listenerList.iterator();
        while (i.hasNext()) {
            CMDocumentManagerListener listener = (CMDocumentManagerListener)i.next();
            listener.propertyChanged(this, propertyName);
        }
    }

    public boolean getPropertyEnabled(String propertyName) {
        Object object = this.propertyTable.get(propertyName);
        return object != null && object.equals("true");
    }

    public void addListener(CMDocumentManagerListener listener) {
        this.listenerList.add(listener);
        this.cmDocumentCache.addListener(listener);
    }

    public void removeListener(CMDocumentManagerListener listener) {
        this.listenerList.remove(listener);
        this.cmDocumentCache.removeListener(listener);
    }

    protected String lookupResolvedURI(String publicId) {
        String key = publicId != null ? publicId : "";
        return (String)this.publicIdTable.get(key);
    }

    protected String lookupOrCreateResolvedURI(String publicId, String systemId) {
        String key;
        String resolvedURI = null;
        String string = key = publicId != null ? publicId : "";
        if (this.getPropertyEnabled("useCachedResovledURI")) {
            resolvedURI = (String)this.publicIdTable.get(key);
        }
        if (resolvedURI == null) {
            resolvedURI = this.cmDocumentReferenceProvider.resolveGrammarURI(publicId, systemId);
            if (resolvedURI == null) {
                resolvedURI = "";
            }
            this.publicIdTable.put(key, resolvedURI);
        }
        return resolvedURI;
    }

    public int getCMDocumentStatus(String publicId) {
        int status = 0;
        String resolvedURI = this.lookupResolvedURI(publicId);
        if (resolvedURI != null) {
            status = this.cmDocumentCache.getStatus(resolvedURI);
        }
        return status;
    }

    public CMDocument getCMDocument(String publicId) {
        CMDocument result = null;
        String resolvedURI = this.lookupResolvedURI(publicId);
        if (resolvedURI != null) {
            result = this.cmDocumentCache.getCMDocument(resolvedURI);
        }
        return result;
    }

    public CMDocument getCMDocument(String publicId, String systemId, String type) {
        CMDocument cmDocument = null;
        String resolvedURI = null;
        resolvedURI = this.getPropertyEnabled("autoLoad") ? this.lookupOrCreateResolvedURI(publicId, systemId) : this.lookupResolvedURI(publicId);
        if (resolvedURI != null) {
            int status = this.cmDocumentCache.getStatus(resolvedURI);
            if (status == 3) {
                cmDocument = this.cmDocumentCache.getCMDocument(resolvedURI);
            } else if (status == 0 && this.getPropertyEnabled("autoLoad")) {
                cmDocument = this.loadCMDocument(publicId, resolvedURI, type, this.getPropertyEnabled("asyncLoad"));
            }
        }
        return cmDocument;
    }

    public void addCMDocumentReference(String publicId, String systemId, String type) {
        int status;
        String resolvedURI = this.lookupOrCreateResolvedURI(publicId, systemId);
        if (resolvedURI != null && resolvedURI.length() > 0 && (status = this.cmDocumentCache.getStatus(resolvedURI)) == 0) {
            this.loadCMDocument(publicId, resolvedURI, type, this.getPropertyEnabled("asyncLoad"));
        }
    }

    public void addCMDocument(String publicId, String systemId, String resolvedURI, String type, CMDocument cmDocument) {
        String key = publicId != null ? publicId : "";
        this.publicIdTable.put(key, resolvedURI);
        this.cmDocumentCache.putCMDocument(resolvedURI, cmDocument);
    }

    protected CMDocument loadCMDocument(final String publicId, final String resolvedURI, final String type, boolean async) {
        CMDocument result = null;
        if (async) {
            this.cmDocumentCache.setStatus(resolvedURI, 2);
            Job job = new Job(String.valueOf(XMLCoreMessages.loading) + resolvedURI){

                public boolean belongsTo(Object family) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.wst.xml.core.internal.contentmodel.modelquery.CMDocumentManager");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    boolean result = family == clazz;
                    return result;
                }

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        CMDocumentManagerImpl.this.buildCMDocument(publicId, resolvedURI, type);
                    }
                    catch (Exception e) {
                        Logger.logException(e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        } else {
            result = this.buildCMDocument(publicId, resolvedURI, type);
        }
        return result;
    }

    public synchronized CMDocument buildCMDocument(String publicId, String resolvedURI, String type) {
        this.cmDocumentCache.setStatus(resolvedURI, 2);
        CMDocument result = null;
        int x = 1;
        ++x;
        if (resolvedURI != null && resolvedURI.length() > 0) {
            result = ContentModelManager.getInstance().createCMDocument(resolvedURI, type);
        }
        if (result != null) {
            if (publicId != null) {
                AnnotationUtility.loadAnnotationsForGrammar(publicId, result);
            }
            this.cmDocumentCache.putCMDocument(resolvedURI, result);
        } else {
            this.cmDocumentCache.setStatus(resolvedURI, 4);
        }
        return result;
    }

    public void removeAllReferences() {
        this.publicIdTable = new Hashtable();
    }
}

