/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageEvent;
import org.eclipse.uml2.uml.MessageKind;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.MessageSort;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.ReceiveOperationEvent;
import org.eclipse.uml2.uml.ReceiveSignalEvent;
import org.eclipse.uml2.uml.SendOperationEvent;
import org.eclipse.uml2.uml.SendSignalEvent;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.internal.operations.NamedElementOperations;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class MessageOperations
extends NamedElementOperations {
    protected MessageOperations() {
    }

    public static boolean validateSendingReceivingMessageEvent(Message message, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public static boolean validateSignatureReferTo(Message message, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public static boolean validateSignatureIsOperation(Message message, DiagnosticChain diagnostics, Map context) {
        EList arguments;
        boolean result = true;
        NamedElement signature = message.getSignature();
        if (signature instanceof Operation && !(arguments = message.getArguments()).isEmpty()) {
            UniqueEList.FastCompare parameters = new UniqueEList.FastCompare((Collection)((Operation)signature).getOwnedParameters());
            if (message.getMessageSort() == MessageSort.REPLY_LITERAL) {
                Iterator p = parameters.iterator();
                while (p.hasNext()) {
                    if (((Parameter)p.next()).getDirection() != ParameterDirectionKind.IN_LITERAL) continue;
                    p.remove();
                }
            }
            if (arguments.size() != parameters.size()) {
                result = false;
            } else {
                Iterator a = arguments.iterator();
                Iterator p = parameters.iterator();
                while (a.hasNext() && p.hasNext()) {
                    Type argumentType = ((ValueSpecification)a.next()).getType();
                    Type parameterType = ((Parameter)p.next()).getType();
                    if (!(argumentType == null ? parameterType != null : !argumentType.conformsTo(parameterType))) continue;
                    result = false;
                    break;
                }
            }
        }
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 206, UMLPlugin.INSTANCE.getString("_UI_Message_SignatureIsOperation_diagnostic", MessageOperations.getMessageSubstitutions((Map)context, (Object)message)), new Object[]{message}));
        }
        return result;
    }

    public static boolean validateSignatureIsSignal(Message message, DiagnosticChain diagnostics, Map context) {
        EList arguments;
        boolean result = true;
        NamedElement signature = message.getSignature();
        if (signature instanceof Signal && !(arguments = message.getArguments()).isEmpty()) {
            EList attributes = ((Signal)signature).getAttributes();
            if (arguments.size() != attributes.size()) {
                result = false;
            } else {
                Iterator ma = arguments.iterator();
                Iterator sa = attributes.iterator();
                while (ma.hasNext() && sa.hasNext()) {
                    Type argumentType = ((ValueSpecification)ma.next()).getType();
                    Type attributeType = ((Property)sa.next()).getType();
                    if (!(argumentType == null ? attributeType != null : !argumentType.conformsTo(attributeType))) continue;
                    result = false;
                    break;
                }
            }
        }
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 207, UMLPlugin.INSTANCE.getString("_UI_Message_SignatureIsSignal_diagnostic", MessageOperations.getMessageSubstitutions((Map)context, (Object)message)), new Object[]{message}));
        }
        return result;
    }

    public static boolean validateArguments(Message message, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public static boolean validateCannotCrossBoundaries(Message message, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public static boolean validateOccurrenceSpecifications(Message message, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public static MessageKind getMessageKind(Message message) {
        return message.eGet((EStructuralFeature)UMLPackage.Literals.MESSAGE__SEND_EVENT, false) == null ? (message.eGet((EStructuralFeature)UMLPackage.Literals.MESSAGE__RECEIVE_EVENT, false) == null ? MessageKind.UNKNOWN_LITERAL : MessageKind.FOUND_LITERAL) : (message.eGet((EStructuralFeature)UMLPackage.Literals.MESSAGE__RECEIVE_EVENT, false) == null ? MessageKind.LOST_LITERAL : MessageKind.COMPLETE_LITERAL);
    }

    public static NamedElement getSignature(Message message) {
        Event event;
        MessageEnd receiveEvent;
        Event event2;
        MessageEvent messageEvent = null;
        MessageEnd sendEvent = message.getSendEvent();
        if (sendEvent instanceof MessageOccurrenceSpecification && (event2 = ((MessageOccurrenceSpecification)sendEvent).getEvent()) instanceof MessageEvent) {
            messageEvent = (MessageEvent)event2;
        }
        if (messageEvent == null && (receiveEvent = message.getReceiveEvent()) instanceof MessageOccurrenceSpecification && (event = ((MessageOccurrenceSpecification)receiveEvent).getEvent()) instanceof MessageEvent) {
            messageEvent = (MessageEvent)event;
        }
        if (messageEvent == null) {
            return null;
        }
        return (NamedElement)new UMLSwitch(){

            public Object caseCallEvent(CallEvent callEvent) {
                return callEvent.eGet((EStructuralFeature)UMLPackage.Literals.CALL_EVENT__OPERATION, false);
            }

            public Object caseReceiveOperationEvent(ReceiveOperationEvent receiveOperationEvent) {
                return receiveOperationEvent.eGet((EStructuralFeature)UMLPackage.Literals.RECEIVE_OPERATION_EVENT__OPERATION, false);
            }

            public Object caseReceiveSignalEvent(ReceiveSignalEvent receiveSignalEvent) {
                return receiveSignalEvent.eGet((EStructuralFeature)UMLPackage.Literals.RECEIVE_SIGNAL_EVENT__SIGNAL, false);
            }

            public Object caseSendOperationEvent(SendOperationEvent sendOperationEvent) {
                return sendOperationEvent.eGet((EStructuralFeature)UMLPackage.Literals.SEND_OPERATION_EVENT__OPERATION, false);
            }

            public Object caseSendSignalEvent(SendSignalEvent sendSignalEvent) {
                return sendSignalEvent.eGet((EStructuralFeature)UMLPackage.Literals.SEND_SIGNAL_EVENT__SIGNAL, false);
            }

            public Object caseSignalEvent(SignalEvent signalEvent) {
                return signalEvent.eGet((EStructuralFeature)UMLPackage.Literals.SIGNAL_EVENT__SIGNAL, false);
            }
        }.doSwitch((EObject)messageEvent);
    }
}

