/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui.preferences;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiMessages;
import org.rubypeople.rdt.internal.launching.RubyInterpreter;
import org.rubypeople.rdt.internal.ui.dialogs.StatusDialog;

public class EditInterpreterDialog
extends StatusDialog {
    protected RubyInterpreter interpreterToEdit;
    protected Text interpreterNameText;
    protected Text interpreterLocationText;
    protected IStatus[] allStatus = new IStatus[2];

    public EditInterpreterDialog(Shell shell, String string) {
        super(shell);
        this.setTitle(string);
    }

    public void setInterpreterToEdit(RubyInterpreter rubyInterpreter) {
        this.interpreterToEdit = rubyInterpreter;
        String string = this.interpreterToEdit.getName();
        this.interpreterNameText.setText(string != null ? string : "");
        IPath iPath = this.interpreterToEdit.getInstallLocation();
        this.interpreterLocationText.setText(iPath != null ? iPath.toOSString() : "");
    }

    protected void createLocationEntryField(Composite composite) {
        new Label(composite, 0).setText(RdtDebugUiMessages.getString("EditInterpreterDialog.rubyInterpreter.path.label"));
        Composite composite2 = new Composite(composite, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.marginLeft = 0;
        composite2.setLayout((Layout)rowLayout);
        this.interpreterLocationText = new Text(composite2, 2052);
        this.interpreterLocationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                EditInterpreterDialog.this.allStatus[1] = EditInterpreterDialog.this.validateInterpreterLocationText();
                EditInterpreterDialog.this.updateStatusLine();
            }
        });
        this.interpreterLocationText.setLayoutData((Object)new RowData(120, -1));
        Button button = new Button(composite, 8);
        button.setLayoutData((Object)new GridData(128));
        button.setText(RdtDebugUiMessages.getString("EditInterpreterDialog.rubyInterpreter.path.browse.button.label"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditInterpreterDialog.this.browseForInstallLocation();
            }
        });
    }

    protected void updateStatusLine() {
        this.updateStatus(this.getMostSevereStatus());
    }

    protected IStatus getMostSevereStatus() {
        Status status = new Status(0, "org.rubypeople.rdt.debug.ui", 0, "", null);
        int n = 0;
        while (n < this.allStatus.length) {
            IStatus iStatus = this.allStatus[n];
            if (iStatus != null) {
                if (iStatus.matches(4)) {
                    return iStatus;
                }
                if (status == null || iStatus.getSeverity() > status.getSeverity()) {
                    status = iStatus;
                }
            }
            ++n;
        }
        return status;
    }

    protected IStatus validateInterpreterLocationText() {
        File file = new File(this.interpreterLocationText.getText());
        if (file.isFile()) {
            return new Status(0, "org.rubypeople.rdt.debug.ui", 0, "", null);
        }
        return new Status(4, "org.rubypeople.rdt.debug.ui", 1, RdtDebugUiMessages.getString("EditInterpreterDialog.rubyInterpreter.path.error"), null);
    }

    protected void createNameEntryField(Composite composite) {
        new Label(composite, 0).setText(RdtDebugUiMessages.getString("EditInterpreterDialog.rubyInterpreter.name"));
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        this.interpreterNameText = new Text(composite, 2052);
        this.interpreterNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                EditInterpreterDialog.this.allStatus[0] = EditInterpreterDialog.this.validateInterpreterNameText();
                EditInterpreterDialog.this.updateStatusLine();
            }
        });
        this.interpreterNameText.setLayoutData((Object)gridData);
    }

    protected IStatus validateInterpreterNameText() {
        int n = 0;
        String string = "";
        if (this.interpreterNameText.getText() == null || this.interpreterNameText.getText().length() <= 0) {
            n = 4;
            string = RdtDebugUiMessages.getString("EditInterpreterDialog.rubyInterpreter.name.error");
        }
        return new Status(n, "org.rubypeople.rdt.debug.ui", 0, string, null);
    }

    protected void browseForInstallLocation() {
        FileDialog fileDialog = new FileDialog(this.getShell());
        fileDialog.setFilterPath(this.interpreterLocationText.getText());
        fileDialog.setText(RdtDebugUiMessages.getString("EditInterpreterDialog.rubyInterpreter.path.browse.message"));
        String string = fileDialog.open();
        if (string != null) {
            this.interpreterLocationText.setText(string);
        }
    }

    protected void okPressed() {
        if (this.interpreterToEdit == null) {
            this.interpreterToEdit = new RubyInterpreter(null, null);
        }
        this.interpreterToEdit.setName(this.interpreterNameText.getText());
        this.interpreterToEdit.setInstallLocation((IPath)new Path(this.interpreterLocationText.getText()));
        super.okPressed();
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        this.createNameEntryField(composite2);
        this.createLocationEntryField(composite2);
        return composite2;
    }
}

