/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.rubyeditor;

import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.formatter.Indents;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.rubyeditor.TabExpander;

public class RubySourceViewer
extends ProjectionViewer
implements IPropertyChangeListener {
    private boolean isTabReplacing = false;
    private boolean fIgnoreTextConverters = false;
    private TabExpander tabExpander;
    private Color fForegroundColor;
    private Color fBackgroundColor;
    private Color fSelectionForegroundColor;
    private Color fSelectionBackgroundColor;
    private IPreferenceStore fPreferenceStore;
    private boolean fIsConfigured;

    public RubySourceViewer(Composite composite, IVerticalRuler iVerticalRuler, IOverviewRuler iOverviewRuler, boolean bl, int n, IPreferenceStore iPreferenceStore) {
        super(composite, iVerticalRuler, iOverviewRuler, bl, n);
        this.setPreferenceStore(iPreferenceStore);
        this.initializeTabReplace();
    }

    public void setPreferenceStore(IPreferenceStore iPreferenceStore) {
        if (this.fIsConfigured && this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        this.fPreferenceStore = iPreferenceStore;
        if (this.fIsConfigured && this.fPreferenceStore != null) {
            this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
            this.initializeViewerColors();
        }
    }

    protected void initializeViewerColors() {
        if (this.fPreferenceStore != null) {
            StyledText styledText = this.getTextWidget();
            Color color = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.Foreground.SystemDefault") ? null : this.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.Foreground", styledText.getDisplay());
            styledText.setForeground(color);
            if (this.fForegroundColor != null) {
                this.fForegroundColor.dispose();
            }
            this.fForegroundColor = color;
            color = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") ? null : this.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.Background", styledText.getDisplay());
            styledText.setBackground(color);
            if (this.fBackgroundColor != null) {
                this.fBackgroundColor.dispose();
            }
            this.fBackgroundColor = color;
            color = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.SelectionForeground.SystemDefault") ? null : this.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.SelectionForeground", styledText.getDisplay());
            styledText.setSelectionForeground(color);
            if (this.fSelectionForegroundColor != null) {
                this.fSelectionForegroundColor.dispose();
            }
            this.fSelectionForegroundColor = color;
            color = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.SelectionBackground.SystemDefault") ? null : this.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.SelectionBackground", styledText.getDisplay());
            styledText.setSelectionBackground(color);
            if (this.fSelectionBackgroundColor != null) {
                this.fSelectionBackgroundColor.dispose();
            }
            this.fSelectionBackgroundColor = color;
        }
    }

    public void configure(SourceViewerConfiguration sourceViewerConfiguration) {
        StyledText styledText = this.getTextWidget();
        if (styledText != null && !styledText.isDisposed()) {
            Color color;
            Color color2 = styledText.getForeground();
            if (color2 != null && color2.isDisposed()) {
                styledText.setForeground(null);
            }
            if ((color = styledText.getBackground()) != null && color.isDisposed()) {
                styledText.setBackground(null);
            }
        }
        super.configure(sourceViewerConfiguration);
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
            this.initializeViewerColors();
        }
        this.fIsConfigured = true;
    }

    public void unconfigure() {
        if (this.fForegroundColor != null) {
            this.fForegroundColor.dispose();
            this.fForegroundColor = null;
        }
        if (this.fBackgroundColor != null) {
            this.fBackgroundColor.dispose();
            this.fBackgroundColor = null;
        }
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        super.unconfigure();
        this.fIsConfigured = false;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if ("AbstractTextEditor.Color.Foreground".equals(string) || "AbstractTextEditor.Color.Foreground.SystemDefault".equals(string) || "AbstractTextEditor.Color.Background".equals(string) || "AbstractTextEditor.Color.Background.SystemDefault".equals(string) || "AbstractTextEditor.Color.SelectionForeground".equals(string) || "AbstractTextEditor.Color.SelectionForeground.SystemDefault".equals(string) || "AbstractTextEditor.Color.SelectionBackground".equals(string) || "AbstractTextEditor.Color.SelectionBackground.SystemDefault".equals(string)) {
            this.initializeViewerColors();
        }
    }

    private Color createColor(IPreferenceStore iPreferenceStore, String string, Display display) {
        RGB rGB = null;
        if (iPreferenceStore.contains(string) && (rGB = iPreferenceStore.isDefault(string) ? PreferenceConverter.getDefaultColor((IPreferenceStore)iPreferenceStore, (String)string) : PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)string)) != null) {
            return new Color((Device)display, rGB);
        }
        return null;
    }

    public void doOperation(int n) {
        if (this.getTextWidget() == null || !this.redraws()) {
            return;
        }
        switch (n) {
            case 1: {
                this.fIgnoreTextConverters = true;
                break;
            }
            case 2: {
                this.fIgnoreTextConverters = true;
            }
        }
        super.doOperation(n);
    }

    protected void customizeDocumentCommand(DocumentCommand documentCommand) {
        super.customizeDocumentCommand(documentCommand);
        if (!this.fIgnoreTextConverters) {
            this.convertTabs(documentCommand, this.getDocument());
        }
        this.fIgnoreTextConverters = false;
    }

    void initializeTabReplace() {
        boolean bl = this.isTabReplacing = !RubyPlugin.getDefault().getPreferenceStore().getBoolean("formatUseTab");
        if (this.isTabReplacing) {
            int n = Indents.getTabWidth((Map)RubyCore.getOptions());
            this.tabExpander = new TabExpander(n);
        }
    }

    protected void convertTabs(DocumentCommand documentCommand, IDocument iDocument) {
        if (!this.isTabReplacing) {
            return;
        }
        if (documentCommand.text.equals("\t")) {
            this.tabExpander.expandTab(documentCommand, iDocument);
        }
    }

    public boolean isTabReplacing() {
        return this.isTabReplacing;
    }

    public String getIndentString() {
        return this.tabExpander.getFullIndent();
    }
}

