/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.rubypeople.rdt.internal.ui.JDTOriginally;
import org.rubypeople.rdt.internal.ui.dialogs.ISelectionValidator;
import org.rubypeople.rdt.internal.ui.dialogs.SelectionStatusDialog;
import org.rubypeople.rdt.internal.ui.dialogs.StatusInfo;
import org.rubypeople.rdt.internal.ui.viewsupport.ContainerCheckedTreeViewer;

public class CheckedTreeSelectionDialog
extends SelectionStatusDialog
implements JDTOriginally {
    private CheckboxTreeViewer fViewer;
    private ILabelProvider fLabelProvider;
    private ITreeContentProvider fContentProvider;
    private ISelectionValidator fValidator = null;
    private ViewerSorter fSorter;
    private String fEmptyListMessage = "No entries available";
    private IStatus fCurrStatus = new StatusInfo();
    private List fFilters;
    private Object fInput;
    private boolean fIsEmpty;
    private int fWidth = 60;
    private int fHeight = 18;
    private boolean fContainerMode;
    private Object[] fExpandedElements;

    public CheckedTreeSelectionDialog(Shell shell, ILabelProvider iLabelProvider, ITreeContentProvider iTreeContentProvider) {
        super(shell);
        this.fLabelProvider = iLabelProvider;
        this.fContentProvider = iTreeContentProvider;
        this.setResult(new ArrayList(0));
        this.setStatusLineAboveButtons(true);
        this.fContainerMode = false;
        this.fExpandedElements = null;
        int n = this.getShellStyle();
        this.setShellStyle(n | 0x400 | 0x10);
    }

    public void setContainerMode(boolean bl) {
        this.fContainerMode = bl;
    }

    public void setInitialSelection(Object object) {
        this.setInitialSelections(new Object[]{object});
    }

    public void setEmptyListMessage(String string) {
        this.fEmptyListMessage = string;
    }

    public void setSorter(ViewerSorter viewerSorter) {
        this.fSorter = viewerSorter;
    }

    public void addFilter(ViewerFilter viewerFilter) {
        if (this.fFilters == null) {
            this.fFilters = new ArrayList(4);
        }
        this.fFilters.add(viewerFilter);
    }

    public void setValidator(ISelectionValidator iSelectionValidator) {
        this.fValidator = iSelectionValidator;
    }

    public void setInput(Object object) {
        this.fInput = object;
    }

    public void setExpandedElements(Object[] objectArray) {
        this.fExpandedElements = objectArray;
    }

    public void setSize(int n, int n2) {
        this.fWidth = n;
        this.fHeight = n2;
    }

    protected void updateOKStatus() {
        if (!this.fIsEmpty) {
            if (this.fValidator != null) {
                this.fCurrStatus = this.fValidator.validate(this.fViewer.getCheckedElements());
                this.updateStatus(this.fCurrStatus);
            } else if (!this.fCurrStatus.isOK()) {
                this.fCurrStatus = new StatusInfo();
            }
        } else {
            this.fCurrStatus = new StatusInfo(4, this.fEmptyListMessage);
        }
        this.updateStatus(this.fCurrStatus);
    }

    public int open() {
        this.fIsEmpty = this.evaluateIfTreeEmpty(this.fInput);
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                CheckedTreeSelectionDialog.this.access$superOpen();
            }
        });
        return this.getReturnCode();
    }

    private void access$superOpen() {
        super.open();
    }

    protected void cancelPressed() {
        this.setResult(null);
        super.cancelPressed();
    }

    protected void computeResult() {
        this.setResult(Arrays.asList(this.fViewer.getCheckedElements()));
    }

    public void create() {
        super.create();
        List list = this.getInitialElementSelections();
        if (list != null) {
            this.fViewer.setCheckedElements(list.toArray());
        }
        if (this.fExpandedElements != null) {
            this.fViewer.setExpandedElements(this.fExpandedElements);
        }
        this.updateOKStatus();
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Label label = this.createMessageArea(composite2);
        Tree tree = this.createTreeViewer(composite2);
        Composite composite3 = this.createSelectionButtons(composite2);
        GridData gridData = new GridData(1808);
        gridData.widthHint = this.convertWidthInCharsToPixels(this.fWidth);
        gridData.heightHint = this.convertHeightInCharsToPixels(this.fHeight);
        tree.setLayoutData((Object)gridData);
        if (this.fIsEmpty) {
            label.setEnabled(false);
            tree.setEnabled(false);
            composite3.setEnabled(false);
        }
        return composite2;
    }

    private Tree createTreeViewer(Composite composite) {
        this.fViewer = this.fContainerMode ? new ContainerCheckedTreeViewer(composite, 2048) : new CheckboxTreeViewer(composite, 2048);
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                CheckedTreeSelectionDialog.this.updateOKStatus();
            }
        });
        this.fViewer.setSorter(this.fSorter);
        if (this.fFilters != null) {
            int n = 0;
            while (n != this.fFilters.size()) {
                this.fViewer.addFilter((ViewerFilter)this.fFilters.get(n));
                ++n;
            }
        }
        this.fViewer.setInput(this.fInput);
        return this.fViewer.getTree();
    }

    private Composite createSelectionButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 131072);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(640);
        gridData.grabExcessHorizontalSpace = true;
        composite.setData((Object)gridData);
        Button button = this.createButton(composite2, 18, "Select &All", false);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CheckedTreeSelectionDialog.this.fViewer.setCheckedElements(CheckedTreeSelectionDialog.this.fContentProvider.getElements(CheckedTreeSelectionDialog.this.fInput));
                CheckedTreeSelectionDialog.this.updateOKStatus();
            }
        };
        button.addSelectionListener((SelectionListener)selectionAdapter);
        Button button2 = this.createButton(composite2, 19, "&Deselect All", false);
        selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CheckedTreeSelectionDialog.this.fViewer.setCheckedElements(new Object[0]);
                CheckedTreeSelectionDialog.this.updateOKStatus();
            }
        };
        button2.addSelectionListener((SelectionListener)selectionAdapter);
        return composite2;
    }

    private boolean evaluateIfTreeEmpty(Object object) {
        Object[] objectArray = this.fContentProvider.getElements(object);
        if (objectArray.length > 0 && this.fFilters != null) {
            int n = 0;
            while (n < this.fFilters.size()) {
                ViewerFilter viewerFilter = (ViewerFilter)this.fFilters.get(n);
                objectArray = viewerFilter.filter((Viewer)this.fViewer, object, objectArray);
                ++n;
            }
        }
        return objectArray.length == 0;
    }
}

