/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.util;

import com.darwinsys.util.VariableMap;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import junit.framework.TestCase;

public class VariableMapTest
extends TestCase {
    VariableMap v = new VariableMap();
    private boolean changed = false;
    private PropertyChangeEvent event;

    public void testSetGet() {
        this.v = new VariableMap();
        this.v.setVar("name", "Robin Smith");
        VariableMapTest.assertEquals((String)"simple get", (String)"Robin Smith", (String)this.v.getVar("name"));
        this.v.setVar("NAME", "Jo Jenkins");
        VariableMapTest.assertEquals((String)"case-sens get", (String)"Jo Jenkins", (String)this.v.getVar("NAME"));
        VariableMapTest.assertFalse((String)"case sens differ", (boolean)this.v.getVar("name").equals(this.v.getVar("NAME")));
    }

    public void testInts() {
        this.v.setIntVar("my int prop", 42);
        VariableMapTest.assertEquals((String)"get int", (int)42, (int)this.v.getIntVar("my int prop"));
        try {
            this.v.setVar("bad int prop", "42 ");
            int i = this.v.getIntVar("bad int prop");
            VariableMapTest.fail((String)("get bad int var returned " + i + "; should throw NFE instead"));
        }
        catch (NumberFormatException e) {
            System.out.println("caught expected NFE");
        }
    }

    public void testDefaults() {
        VariableMapTest.assertNull((Object)this.v.getVar("USER", null));
        VariableMapTest.assertEquals((String)"bar", (String)this.v.getVar("foo", "bar"));
        this.v.setVar("num", "42");
        VariableMapTest.assertEquals((int)100, (int)this.v.getIntVar("NOTnum", 100));
        VariableMapTest.assertEquals((int)42, (int)this.v.getIntVar("num", 100));
    }

    public void testSubst() {
        this.v.setVar("USER", "ian");
        this.v.setVar("PASSWD", "top secret");
        String before = "login(${USER}, ${PASSWD});";
        System.out.printf("Subst input:  %s%n", before);
        String expect = "login(ian, top secret);";
        String actual = this.v.substVars(before);
        System.out.printf("Subst result: %s%n", actual);
        VariableMapTest.assertEquals((String)"subst", (String)expect, (String)actual);
    }

    public void testBadSubst() {
        String input = "What does ${noSuchVariable} do?";
        VariableMapTest.assertEquals((String)"itempotent on bad subst", (String)input, (String)this.v.substVars(input));
    }

    public void testIdemPotent() {
        this.v.setVar("foo", "bar");
        String string = "foo bar bleah";
        VariableMapTest.assertEquals((String)"idempotent", (String)"foo bar bleah", (String)this.v.substVars("foo bar bleah"));
    }

    public void testBackslashInSubstInputString() {
        this.v.setVar("abc", "123");
        String str = "anaylyse this: ${abc}\\123";
        VariableMapTest.assertEquals((String)"testBackslashInSubstInputString", (String)"anaylyse this: 123\\123", (String)this.v.substVars(str));
    }

    public void testBackslashInVarUsedInSubst() {
        String abcInput = "a\\123";
        this.v.setVar("abc", abcInput);
        String abcOutput = this.v.getVar("abc");
        VariableMapTest.assertEquals((String)abcInput, (String)abcOutput);
        VariableMapTest.assertEquals((String)"testBackslashInVarUsedInSubst", (String)"a123\\123", (String)this.v.substVars("${abc}\\123"));
    }

    public void testPropertyChangeListenerSupport() {
        PropertyChangeListener liszt = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                VariableMapTest.this.changed = true;
                VariableMapTest.this.event = evt;
            }
        };
        this.v.addPropertyChangeListener(liszt);
        this.v.put("foo", "123");
        VariableMapTest.assertEquals((int)123, (int)this.v.getIntVar("foo"));
        VariableMapTest.assertTrue((boolean)this.changed);
        VariableMapTest.assertNotNull((Object)this.event);
        VariableMapTest.assertTrue((this.v == this.event.getSource() ? 1 : 0) != 0);
        VariableMapTest.assertEquals((String)"foo", (String)this.event.getPropertyName());
        VariableMapTest.assertNull((Object)this.event.getOldValue());
        VariableMapTest.assertEquals((Object)"123", (Object)this.event.getNewValue());
        this.changed = false;
        this.v.removePropertyChangeListener(liszt);
        this.v.setIntVar("bar", 55);
        VariableMapTest.assertFalse((boolean)this.changed);
    }
}

