/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.io;

import com.darwinsys.io.Crawler;
import com.darwinsys.io.FileHandler;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import junit.framework.TestCase;

public class CrawlerTest
extends TestCase {
    boolean seenAnyFiles = false;

    public void testPubCrawl() throws Exception {
        String dir = ".";
        FilenameFilter javaFileFilter = new FilenameFilter(){

            public boolean accept(File dir, String s) {
                return s.endsWith(".java") || s.endsWith(".class") || s.endsWith(".jar");
            }
        };
        FileHandler dummyVisitorJustPrints = new FileHandler(){
            private File file;

            public void visit(File f) {
                this.file = f;
                CrawlerTest.this.seenAnyFiles = true;
                System.out.println(f.getAbsolutePath());
            }

            public void init() throws IOException {
            }

            public void destroy() throws IOException {
            }

            public File getFile() {
                return this.file;
            }
        };
        new Crawler(javaFileFilter, dummyVisitorJustPrints).crawl(new File(dir));
        CrawlerTest.assertTrue((String)"crawler found at least one file in .", (boolean)this.seenAnyFiles);
    }

    public void testErrors() throws Exception {
        try {
            new Crawler(null, null);
            CrawlerTest.fail((String)"Did not throw expected NPE");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Throwable t) {
            CrawlerTest.fail((String)("Caught UNexcpeted exception " + t));
        }
    }
}

