/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.util.test;

import ca.sqlpower.util.Cache;
import junit.framework.TestCase;

public abstract class CacheTest
extends TestCase {
    public static int maxMembers = 50;
    public Cache cache;

    public void setUp() {
        if (this.cache == null) {
            CacheTest.fail((String)"Your setUp method must create a new Cache and assign it to this.cache before calling super.setUp().");
        }
        for (int i = 0; i < 45; ++i) {
            this.cache.put(new Integer(i), String.valueOf(i));
        }
    }

    public void testMaxMembersHardLimitOnInsert() {
        for (int i = 45; i < 60; ++i) {
            this.cache.put(new Integer(i), String.valueOf(i));
        }
        CacheTest.assertTrue((this.cache.size() <= this.cache.getMaxMembers() ? 1 : 0) != 0);
    }

    public void testFlush() {
        this.cache.flush();
        CacheTest.assertEquals((int)0, (int)this.cache.size());
    }

    public void testSize() {
        CacheTest.assertEquals((int)45, (int)this.cache.size());
        this.cache.put(new Integer(45), String.valueOf(45));
        CacheTest.assertEquals((int)46, (int)this.cache.size());
    }
}

