/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.table;

import ca.sqlpower.architect.profile.ColumnProfileResult;
import ca.sqlpower.architect.profile.ProfileColumn;
import ca.sqlpower.architect.swingui.table.DateTableCellRenderer;
import ca.sqlpower.architect.swingui.table.DecimalTableCellRenderer;
import ca.sqlpower.architect.swingui.table.PercentTableCellRenderer;
import ca.sqlpower.architect.swingui.table.ProfileTableModel;
import ca.sqlpower.architect.swingui.table.SQLObjectTableCellRenderer;
import ca.sqlpower.architect.swingui.table.TableModelSearchDecorator;
import ca.sqlpower.architect.swingui.table.TableModelSortDecorator;
import ca.sqlpower.architect.swingui.table.ValueTableCellRenderer;
import ca.sqlpower.swingui.table.TableTextConverter;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ProfileJTable
extends JTable
implements TableTextConverter {
    public ProfileJTable(TableModel model) {
        super(model);
        TableColumnModel cm = this.getColumnModel();
        block7: for (int col = 0; col < cm.getColumnCount(); ++col) {
            TableColumn tc = cm.getColumn(col);
            switch (ProfileColumn.values()[col]) {
                case DATABASE: 
                case SCHEMA: 
                case CATALOG: 
                case TABLE: 
                case COLUMN: {
                    tc.setCellRenderer(new SQLObjectTableCellRenderer());
                    continue block7;
                }
                case RUNDATE: {
                    tc.setCellRenderer(new DateTableCellRenderer());
                    continue block7;
                }
                case PERCENT_UNIQUE: 
                case PERCENT_NULL: {
                    tc.setCellRenderer(new PercentTableCellRenderer());
                    continue block7;
                }
                case AVERAGE_LENGTH: {
                    tc.setCellRenderer(new DecimalTableCellRenderer());
                    continue block7;
                }
                case MIN_VALUE: 
                case MAX_VALUE: 
                case AVERAGE_VALUE: 
                case TOP_VALUE: {
                    tc.setCellRenderer(new ValueTableCellRenderer());
                    continue block7;
                }
                default: {
                    tc.setCellRenderer(null);
                }
            }
        }
    }

    public ColumnProfileResult getColumnProfileResultForRow(int row) {
        return (ColumnProfileResult)this.getModel().getValueAt(row, -1);
    }

    public TableModel getDataTableModel() {
        TableModelSortDecorator m1 = (TableModelSortDecorator)this.getModel();
        TableModelSearchDecorator m2 = (TableModelSearchDecorator)m1.getTableModel();
        ProfileTableModel m3 = (ProfileTableModel)m2.getTableModel();
        return m3;
    }

    public int modelIndex(int viewIndex) {
        TableModelSortDecorator m1 = (TableModelSortDecorator)this.getModel();
        return m1.modelIndex(viewIndex);
    }

    public String getTextForCell(int row, int col) {
        JLabel renderer = (JLabel)this.getCellRenderer(row, col).getTableCellRendererComponent(this, this.getModel().getValueAt(row, this.getColumnModel().getColumn(col).getModelIndex()), false, false, row, col);
        return renderer.getText();
    }
}

