/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public abstract class RecentMenu
extends JMenu {
    public static final int DEFAULT_MAX_RECENT_FILES = 5;
    private final int maxRecentFiles;
    private static final String PREFS_KEY = "recentFile";
    private List<String> recentFileNames = new ArrayList<String>();
    final Preferences prefs;
    private ActionListener recentOpener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            JMenuItem mi = (JMenuItem)e.getSource();
            try {
                RecentMenu.this.openFile(mi.getText());
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(RecentMenu.this, "Could not open file " + e1);
            }
        }
    };

    public RecentMenu(Object mainClassInstance, int max) {
        super("Recent Items");
        this.prefs = RecentMenu.getUserPrefsNode(mainClassInstance);
        this.maxRecentFiles = max;
        this.loadRecentMenu();
    }

    public static Preferences getUserPrefsNode(Object mainClassInstance) {
        Class<?> clazz = mainClassInstance instanceof Class ? (Class<?>)mainClassInstance : mainClassInstance.getClass();
        return Preferences.userNodeForPackage(clazz);
    }

    public RecentMenu(Object mainClassInstance) {
        this(mainClassInstance, 5);
    }

    public void openFile(String fileName) throws IOException {
        this.loadFile(fileName);
        this.putRecentFileName(fileName);
    }

    public abstract void loadFile(String var1) throws IOException;

    public void putRecentFileName(String f) {
        while (this.recentFileNames.size() > this.maxRecentFiles - 1) {
            this.recentFileNames.remove(this.recentFileNames.size() - 1);
        }
        if (this.recentFileNames.contains(f)) {
            this.recentFileNames.remove(f);
        }
        this.recentFileNames.add(0, f);
        for (int i = 0; i < this.recentFileNames.size(); ++i) {
            String t = this.recentFileNames.get(i);
            this.prefs.put(PREFS_KEY + i, t);
        }
        this.loadRecentMenu();
    }

    private void loadRecentMenu() {
        String f;
        this.setEnabled(false);
        for (int i = this.getMenuComponentCount() - 1; i >= 0; --i) {
            this.remove(0);
        }
        this.recentFileNames.clear();
        for (int i = 0; i < this.maxRecentFiles && (f = this.prefs.get(PREFS_KEY + i, null)) != null; ++i) {
            if (!new File(f).exists()) continue;
            this.recentFileNames.add(f);
            this.setEnabled(true);
            JMenuItem mi = new JMenuItem(f);
            this.add(mi);
            mi.addActionListener(this.recentOpener);
        }
        this.addSeparator();
        JMenuItem clearItem = new JMenuItem("Clear Recent Files");
        clearItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RecentMenu.this.clear();
            }
        });
        this.recentFileNames.add("Clear Recent Items");
        this.add(clearItem);
    }

    public void clear() {
        for (int i = 0; i < this.maxRecentFiles; ++i) {
            this.prefs.remove(PREFS_KEY + i);
        }
        this.loadRecentMenu();
    }
}

