/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.CoreUserSettings;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectPanel;
import ca.sqlpower.architect.swingui.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class PreferencesPanel
extends JPanel
implements ArchitectPanel {
    protected CoreUserSettings us;
    protected JTextField plIniName;
    protected JButton plIniButton;
    protected JTextField powerLoaderEngine;
    protected JButton powerLoaderEngineButton;
    protected JTextField etlLogFileName;
    protected JButton etlLogFileButton;
    protected JTextField ddlLogFileName;
    protected JButton ddlLogFileButton;
    protected JRadioButton playPenAntialiasOn;
    protected JRadioButton playPenAntialiasOff;
    protected JRadioButton exceptionReportOn;
    protected JRadioButton exceptionReportOff;
    protected JRadioButton showWelcomeOn;
    protected JRadioButton showWelcomeOff;

    public PreferencesPanel(CoreUserSettings us) {
        this.us = us;
        this.setup();
        this.revertToUserSettings();
    }

    public void setup() {
        this.setLayout(new FormLayout(5, 5));
        this.add(new JLabel("Power*Loader PL.INI File"));
        JPanel plIniPanel = new JPanel();
        plIniPanel.setLayout(new BorderLayout());
        this.plIniName = new JTextField("", 35);
        plIniPanel.add((Component)this.plIniName, "West");
        this.plIniButton = new JButton();
        plIniPanel.add((Component)this.plIniButton, "East");
        this.plIniButton.setAction(new ChooseFileAction(this.plIniName, ASUtils.INI_FILE_FILTER, "Browse..."));
        this.add(plIniPanel);
        this.add(new JLabel("Power*Loader Engine"));
        JPanel plEnginePanel = new JPanel();
        plEnginePanel.setLayout(new BorderLayout());
        this.powerLoaderEngine = new JTextField("", 35);
        plEnginePanel.add((Component)this.powerLoaderEngine, "West");
        this.powerLoaderEngineButton = new JButton();
        plEnginePanel.add((Component)this.powerLoaderEngineButton, "East");
        this.powerLoaderEngineButton.setAction(new ChooseFileAction(this.powerLoaderEngine, ASUtils.EXE_FILE_FILTER, "Browse..."));
        this.add(plEnginePanel);
        this.add(new JLabel("ETL Log File"));
        JPanel etlLogFilePanel = new JPanel();
        etlLogFilePanel.setLayout(new BorderLayout());
        this.etlLogFileName = new JTextField("", 35);
        etlLogFilePanel.add((Component)this.etlLogFileName, "West");
        this.etlLogFileButton = new JButton();
        etlLogFilePanel.add((Component)this.etlLogFileButton, "East");
        this.etlLogFileButton.setAction(new ChooseFileAction(this.etlLogFileName, ASUtils.LOG_FILE_FILTER, "Browse..."));
        this.add(etlLogFilePanel);
        this.add(new JLabel("Forward Engineering Log File"));
        JPanel ddlLogFilePanel = new JPanel();
        ddlLogFilePanel.setLayout(new BorderLayout());
        this.ddlLogFileName = new JTextField("", 35);
        ddlLogFilePanel.add((Component)this.ddlLogFileName, "West");
        this.ddlLogFileButton = new JButton();
        ddlLogFilePanel.add((Component)this.ddlLogFileButton, "East");
        this.ddlLogFileButton.setAction(new ChooseFileAction(this.ddlLogFileName, ASUtils.LOG_FILE_FILTER, "Browse..."));
        this.add(ddlLogFilePanel);
        this.add(new JLabel("Antialiased Rendering in PlayPen"));
        JPanel playPenAntialiasPanel = new JPanel();
        playPenAntialiasPanel.setLayout(new FlowLayout());
        ButtonGroup playPenAntialiasGroup = new ButtonGroup();
        this.playPenAntialiasOn = new JRadioButton("On");
        playPenAntialiasGroup.add(this.playPenAntialiasOn);
        this.playPenAntialiasOff = new JRadioButton("Off");
        playPenAntialiasGroup.add(this.playPenAntialiasOff);
        playPenAntialiasPanel.add(this.playPenAntialiasOn);
        playPenAntialiasPanel.add(this.playPenAntialiasOff);
        this.add(playPenAntialiasPanel);
        this.add(new JLabel("Error Reporting"));
        JPanel exceptionReportPanel = new JPanel();
        exceptionReportPanel.setLayout(new FlowLayout());
        ButtonGroup exceptionReportGroup = new ButtonGroup();
        this.exceptionReportOn = new JRadioButton("On");
        exceptionReportGroup.add(this.exceptionReportOn);
        this.exceptionReportOff = new JRadioButton("Off");
        exceptionReportGroup.add(this.exceptionReportOff);
        exceptionReportPanel.add(this.exceptionReportOn);
        exceptionReportPanel.add(this.exceptionReportOff);
        this.add(exceptionReportPanel);
        this.add(new JLabel("Show Welcome Screen"));
        JPanel showWelcomePanel = new JPanel();
        showWelcomePanel.setLayout(new FlowLayout());
        ButtonGroup showWelcomeGroup = new ButtonGroup();
        this.showWelcomeOn = new JRadioButton("Yes");
        showWelcomeGroup.add(this.showWelcomeOn);
        this.showWelcomeOff = new JRadioButton("No");
        showWelcomeGroup.add(this.showWelcomeOff);
        showWelcomePanel.add(this.showWelcomeOn);
        showWelcomePanel.add(this.showWelcomeOff);
        this.add(showWelcomePanel);
    }

    protected void revertToUserSettings() {
        this.plIniName.setText(this.us.getPlDotIniPath());
        this.powerLoaderEngine.setText(this.us.getETLUserSettings().getString("ETLUserSettings.PROP_PL_ENGINE_PATH", ""));
        this.etlLogFileName.setText(this.us.getETLUserSettings().getString("ETLUserSettings.PROP_ETL_LOG_PATH", ""));
        this.ddlLogFileName.setText(this.us.getDDLUserSettings().getString("DDLUserSettings.PROP_DDL_LOG_PATH", ""));
        if (this.us.getSwingSettings().getBoolean("SwingUserSettings.PLAYPEN_RENDER_ANTIALIASED", false)) {
            this.playPenAntialiasOn.setSelected(true);
        } else {
            this.playPenAntialiasOff.setSelected(true);
        }
        if (this.us.getSwingSettings().getBoolean("SwingUserSettings.SHOW_WELCOMESCREEN", true)) {
            this.showWelcomeOn.setSelected(true);
        } else {
            this.showWelcomeOff.setSelected(true);
        }
        if (this.us.getQfaUserSettings().getBoolean("QFAUserSettings.EXCEPTION_REPORTING", true)) {
            this.exceptionReportOn.setSelected(true);
        } else {
            this.exceptionReportOff.setSelected(true);
        }
    }

    public boolean applyChanges() {
        this.us.setPlDotIniPath(this.plIniName.getText());
        this.us.getETLUserSettings().setString("ETLUserSettings.PROP_PL_ENGINE_PATH", this.powerLoaderEngine.getText());
        this.us.getETLUserSettings().setString("ETLUserSettings.PROP_ETL_LOG_PATH", this.etlLogFileName.getText());
        this.us.getDDLUserSettings().setString("DDLUserSettings.PROP_DDL_LOG_PATH", this.ddlLogFileName.getText());
        this.us.getSwingSettings().setBoolean("SwingUserSettings.PLAYPEN_RENDER_ANTIALIASED", this.playPenAntialiasOn.isSelected());
        this.us.getSwingSettings().setBoolean("SwingUserSettings.SHOW_WELCOMESCREEN", this.showWelcomeOn.isSelected());
        this.us.getQfaUserSettings().setBoolean("QFAUserSettings.EXCEPTION_REPORTING", this.exceptionReportOn.isSelected());
        ArchitectFrame.getMainInstance().getProject().getPlayPen().setRenderingAntialiased(this.playPenAntialiasOn.isSelected());
        return true;
    }

    public void discardChanges() {
        this.revertToUserSettings();
    }

    public JPanel getPanel() {
        return this;
    }

    protected class ChooseFileAction
    extends AbstractAction {
        JTextField fileName;
        FileFilter filter;

        public ChooseFileAction(JTextField fileName, FileFilter filter, String buttonText) {
            super(buttonText);
            this.fileName = fileName;
            this.filter = filter;
        }

        public void actionPerformed(ActionEvent e) {
            File initialLocation;
            JFileChooser fc = new JFileChooser();
            if (this.fileName.getText() != null && this.fileName.getText().length() > 0 && (initialLocation = new File(this.fileName.getText())).exists()) {
                fc.setCurrentDirectory(initialLocation);
            }
            fc.addChoosableFileFilter(this.filter);
            int returnVal = fc.showOpenDialog(PreferencesPanel.this);
            if (returnVal == 0) {
                this.fileName.setText(fc.getSelectedFile().getAbsolutePath());
            }
        }
    }
}

