/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.swingui.Lister;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListerProgressBarUpdater
implements ActionListener {
    private static final Logger logger = Logger.getLogger(ListerProgressBarUpdater.class);
    private JProgressBar bar;
    private Lister lister;
    private List<JComponent> enableDisableList;
    private List<JComponent> disableEnableList;
    private List<JComponent> visableInvisableList;
    private List<JComponent> invisableVisableList;

    public ListerProgressBarUpdater(JProgressBar bar, Lister lister) {
        this.bar = bar;
        this.lister = lister;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        try {
            Integer max = this.lister.getJobSize();
            this.bar.setVisible(true);
            if (this.enableDisableList != null) {
                for (JComponent jc : this.enableDisableList) {
                    jc.setEnabled(true);
                }
            }
            if (this.visableInvisableList != null) {
                for (JComponent jc : this.visableInvisableList) {
                    jc.setVisible(true);
                }
            }
            if (this.disableEnableList != null) {
                for (JComponent jc : this.disableEnableList) {
                    jc.setEnabled(false);
                }
            }
            if (this.invisableVisableList != null) {
                for (JComponent jc : this.invisableVisableList) {
                    jc.setVisible(false);
                }
            }
            if (max != null) {
                this.bar.setMaximum(max);
                this.bar.setValue(this.lister.getProgress());
                this.bar.setIndeterminate(false);
            } else {
                this.bar.setIndeterminate(true);
            }
            if (this.lister.isFinished()) {
                this.bar.setVisible(false);
                if (this.enableDisableList != null) {
                    for (JComponent jc : this.enableDisableList) {
                        jc.setEnabled(false);
                    }
                }
                if (this.visableInvisableList != null) {
                    for (JComponent jc : this.visableInvisableList) {
                        jc.setVisible(false);
                    }
                }
                if (this.disableEnableList != null) {
                    for (JComponent jc : this.disableEnableList) {
                        jc.setEnabled(true);
                    }
                }
                if (this.invisableVisableList != null) {
                    for (JComponent jc : this.invisableVisableList) {
                        jc.setVisible(true);
                    }
                }
                ((Timer)evt.getSource()).stop();
            }
        }
        catch (ArchitectException e) {
            logger.error((Object)"getProgress failt", (Throwable)e);
        }
    }

    public void setEnableDisableList(List<JComponent> enableDisableList) {
        this.enableDisableList = enableDisableList;
    }

    public void setVisableInvisableList(List<JComponent> visableInvisableList) {
        this.visableInvisableList = visableInvisableList;
    }

    public void setDisableEnableList(List<JComponent> disableEnableList) {
        this.disableEnableList = disableEnableList;
    }

    public void setInvisableVisableList(List<JComponent> invisableVisableList) {
        this.invisableVisableList = invisableVisableList;
    }
}

