/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FormLayout
implements LayoutManager {
    int hgap;
    int vgap;

    public FormLayout() {
        this(2, 2);
    }

    public FormLayout(int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    private LeftRightHeight calcSizes(Container parent) {
        int maxLHWidth = 0;
        int maxRHWidth = 0;
        int lHeight = 0;
        int height = 0;
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Dimension d = parent.getComponent(i).getPreferredSize();
            if (i % 2 == 0) {
                maxLHWidth = Math.max(maxLHWidth, d.width);
                lHeight = d.height;
                continue;
            }
            maxRHWidth = Math.max(maxRHWidth, d.width);
            height += Math.max(lHeight, d.height);
        }
        LeftRightHeight lrh = new LeftRightHeight();
        lrh.left = maxLHWidth;
        lrh.right = maxRHWidth;
        lrh.height = height;
        return lrh;
    }

    public Dimension preferredLayoutSize(Container parent) {
        Dimension minimum = this.minimumLayoutSize(parent);
        return minimum;
    }

    public Dimension minimumLayoutSize(Container parent) {
        LeftRightHeight lrh = this.calcSizes(parent);
        Insets i = parent.getInsets();
        int rows = parent.getComponentCount() / 2;
        return new Dimension(lrh.left + lrh.right + i.left + i.right + this.hgap, lrh.height + i.top + i.bottom + this.vgap * rows);
    }

    public void layoutContainer(Container parent) {
        LeftRightHeight lrh = this.calcSizes(parent);
        Dimension size = parent.getSize();
        Insets ins = parent.getInsets();
        int lColWidth = Math.min(size.width, lrh.left);
        int rColWidth = size.width - ins.left - lColWidth - this.hgap - ins.right;
        int lHeight = 0;
        int y = ins.top;
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Component c = parent.getComponent(i);
            Dimension d = c.getPreferredSize();
            if (i % 2 == 0) {
                c.setBounds(ins.left, y, lColWidth, d.height);
                lHeight = d.height;
                continue;
            }
            int width = c.getPreferredSize().width;
            if (c instanceof JTextField || c instanceof JPanel) {
                width = rColWidth;
            }
            c.setBounds(lColWidth + ins.left + this.hgap, y, width, d.height);
            y += Math.max(d.height, lHeight) + this.vgap;
        }
    }

    private class LeftRightHeight {
        int left;
        int right;
        int height;

        private LeftRightHeight() {
        }
    }
}

