/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.etl;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.etl.UnknownDatabaseTypeException;
import java.io.File;
import java.util.Date;
import org.apache.log4j.Logger;

public class PLUtils {
    private static final Logger logger = Logger.getLogger(PLUtils.class);
    public static final String CONNECTION_TYPE_ORACLE = "ORACLE";
    public static final String CONNECTION_TYPE_SQLSERVER = "SQL SERVER";
    public static final String CONNECTION_TYPE_POSTGRES = "POSTGRES";
    public static final String CONNECTION_TYPE_ACCESS = "ACCESS";
    public static final String CONNECTION_TYPE_DB2 = "DB2";
    public static final int MAX_PLID_LENGTH = 80;
    private static Date plLastReadTimestamp = new Date(0L);

    private PLUtils() {
    }

    public static String toPLIdentifier(String text) {
        if (text.length() > 80) {
            text = text.substring(0, 80);
        }
        StringBuffer plid = new StringBuffer(text.toUpperCase());
        int n = plid.length();
        for (int i = 0; i < n; ++i) {
            if (!Character.isWhitespace(plid.charAt(i))) continue;
            plid.setCharAt(i, '_');
        }
        return plid.toString();
    }

    public static boolean plDotIniHasChanged(String plDotIniPath) {
        File inputFile = new File(plDotIniPath);
        boolean retVal = false;
        if (inputFile.lastModified() > plLastReadTimestamp.getTime()) {
            retVal = true;
        }
        inputFile = null;
        return retVal;
    }

    public static String getEngineExecutableName(ArchitectDataSource dataSource) throws UnknownDatabaseTypeException {
        String type = dataSource.get("Type");
        if (type == null) {
            throw new UnknownDatabaseTypeException("<unspecified>");
        }
        if (type.equalsIgnoreCase(CONNECTION_TYPE_SQLSERVER) || type.equalsIgnoreCase(CONNECTION_TYPE_ACCESS) || type.equalsIgnoreCase(CONNECTION_TYPE_DB2) || type.equalsIgnoreCase(CONNECTION_TYPE_POSTGRES)) {
            return "PowerLoader_odbc.exe";
        }
        if (type.equalsIgnoreCase(CONNECTION_TYPE_ORACLE)) {
            return "PowerLoader_oracle.exe";
        }
        throw new UnknownDatabaseTypeException(type);
    }

    public static String getEngineConnectString(ArchitectDataSource dataSource) throws UnknownDatabaseTypeException {
        logger.debug((Object)("get engine connect String PWD: " + dataSource.get("PWD")));
        String type = dataSource.get("Type");
        if (type == null) {
            throw new UnknownDatabaseTypeException("<unspecified>");
        }
        if (type.equalsIgnoreCase(CONNECTION_TYPE_SQLSERVER) || type.equalsIgnoreCase(CONNECTION_TYPE_ACCESS) || type.equalsIgnoreCase(CONNECTION_TYPE_DB2) || type.equalsIgnoreCase(CONNECTION_TYPE_POSTGRES)) {
            return dataSource.get("UID") + "/" + dataSource.get("PWD") + "@" + dataSource.get("Logical");
        }
        if (type.equalsIgnoreCase(CONNECTION_TYPE_ORACLE)) {
            return dataSource.get("UID") + "/" + dataSource.get("PWD") + "@" + dataSource.get("TNS Name");
        }
        throw new UnknownDatabaseTypeException(type);
    }
}

