/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl;

import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.ddl.DDLUtils;

public class DDLStatement {
    private String targetCatalog;
    private String targetSchema;
    private SQLObject object;
    private StatementType type;
    private String sqlText;
    private String sqlTerminator;

    public DDLStatement(SQLObject object, StatementType type, String sqlText, String sqlTerminator, String targetCatalog, String targetSchema) {
        this.object = object;
        this.type = type;
        this.sqlText = sqlText;
        this.sqlTerminator = sqlTerminator;
        this.targetCatalog = targetCatalog;
        this.targetSchema = targetSchema;
    }

    public SQLObject getObject() {
        return this.object;
    }

    public void setObject(SQLObject argObject) {
        this.object = argObject;
    }

    public StatementType getType() {
        return this.type;
    }

    public void setType(StatementType argType) {
        this.type = argType;
    }

    public String getSQLText() {
        return this.sqlText;
    }

    public void setSQLText(String v) {
        this.sqlText = v;
    }

    public void setSqlTerminator(String sqlTerminator) {
        this.sqlTerminator = sqlTerminator;
    }

    public String getSqlTerminator() {
        return this.sqlTerminator;
    }

    public String getTargetCatalog() {
        return this.targetCatalog;
    }

    public void setTargetCatalog(String targetCatalog) {
        this.targetCatalog = targetCatalog;
    }

    public String getTargetSchema() {
        return this.targetSchema;
    }

    public void setTargetSchema(String targetSchema) {
        this.targetSchema = targetSchema;
    }

    public String toString() {
        return this.getType() + " " + DDLUtils.toQualifiedName(this.getTargetCatalog(), this.getTargetSchema(), this.object.getName());
    }

    public static class StatementType {
        public static final StatementType CREATE = new StatementType("CREATE");
        public static final StatementType DROP = new StatementType("DROP");
        public static final StatementType ALTER = new StatementType("ALTER");
        public static final StatementType ADD_PK = new StatementType("ADD_PK");
        public static final StatementType ADD_FK = new StatementType("ADD_FK");
        public static final StatementType MODIFY = new StatementType("MODIFY");
        public static final StatementType SELECT = new StatementType("SELECT");
        private String type;

        private StatementType(String type) {
            this.type = type;
        }

        public boolean equals(Object other) {
            return this.type.equals(((StatementType)other).type);
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public String toString() {
            return this.type;
        }
    }
}

