/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego.physics;

import br.arca.morcego.Config;
import br.arca.morcego.Morcego;
import br.arca.morcego.physics.Camera;
import br.arca.morcego.physics.Matrix3x3;
import br.arca.morcego.physics.PositionedObject;
import java.awt.Point;

public class Vector3D
implements PositionedObject {
    public float x;
    public float y;
    public float z;
    public Point projection = new Point(0, 0);
    private float scale;
    public static float FOV = Config.getInteger("morcego.fieldOfView");
    private float maxModule = 0.0f;

    public Vector3D(float x, float y, float z) {
        this.x = x;
        this.z = z;
        this.y = y;
    }

    public void moveBy(Vector3D v) {
        this.moveBy(v.x, v.y, v.z);
    }

    public void moveBy(float dx, float dy, float dz) {
        this.x += dx;
        this.y += dy;
        this.z += dz;
        this.proj();
    }

    public void moveTo(Vector3D v) {
        this.moveTo(v.x, v.y, v.z);
    }

    public void moveTo(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.proj();
    }

    public Vector3D() {
    }

    public void proj() {
        Camera camera = Morcego.getCamera();
        this.scale = camera.getDistanceTo(new Vector3D(0.0f, 0.0f, this.z));
        if (this.scale > 0.0f) {
            this.scale = FOV / this.scale;
            int depth = (int)camera.getDistanceTo(this);
            if (Math.abs(depth) < 1) {
                depth = 1;
            }
            float u = (float)Morcego.getOrigin().x + FOV * this.x / (float)depth;
            float v = (float)Morcego.getOrigin().y + FOV * this.y / (float)depth;
            this.projection.x = new Float(u).intValue();
            this.projection.y = new Float(v).intValue();
        } else {
            this.scale = 0.0f;
        }
    }

    public Vector3D unproj(float dx, float dy) {
        int depth = (int)Morcego.getCamera().getDistanceTo(this);
        float xi = (dx - (float)Morcego.getOrigin().x) * (float)depth / FOV;
        float yi = (dy - (float)Morcego.getOrigin().y) * (float)depth / FOV;
        float zi = this.z;
        return new Vector3D(xi, yi, zi);
    }

    public float getScale() {
        return this.scale;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public void rotate(float xTheta, float yTheta) {
        Matrix3x3 matrix = Matrix3x3.getXRotation(xTheta).multiplyByMatrix(Matrix3x3.getYRotation(yTheta));
        Vector3D v = matrix.multiplyByVector(this);
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.proj();
    }

    public float getDistanceTo(Vector3D one) {
        Vector3D diff = new Vector3D(this.x - one.getX(), this.y - one.getY(), this.z - one.getZ());
        return diff.module();
    }

    public float getDistanceFromOrigin() {
        return this.getDistanceTo(new Vector3D(0.0f, 0.0f, 0.0f));
    }

    public Vector3D getVectorFrom(Vector3D v) {
        return new Vector3D(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    public void add(Vector3D s) {
        this.x += s.x;
        this.y += s.y;
        this.z += s.z;
    }

    public void clear() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
    }

    public Vector3D multiplyByScalar(float module) {
        return new Vector3D(this.x * module, this.y * module, this.z * module);
    }

    public void resize(float module) {
        Vector3D v = this.multiplyByScalar(module);
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public Vector3D opposite() {
        return new Vector3D(-this.x, -this.y, -this.z);
    }

    public float module() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Vector3D fromVertex(Vector3D v) {
        return new Vector3D(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    public float scalarProduct(Vector3D s) {
        return this.x * s.x + this.y * s.y + this.z * s.z;
    }

    public Vector3D getUnit() {
        Vector3D unit = new Vector3D(this.x, this.y, this.z);
        return unit.multiplyByScalar(1.0f / unit.module());
    }
}

