/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego.component;

import br.arca.morcego.Config;
import br.arca.morcego.Morcego;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.event.MouseInputListener;

public class LocalImage
extends Component
implements MouseInputListener {
    Image image;
    int logoWidth;
    int logoHeight;
    private int x;
    private int y;
    private Rectangle boundRectangle;
    private boolean mouseOver;

    public LocalImage(String name, int x, int y) {
        this.x = x;
        this.y = y;
        String imgLocation = Config.getString(Config._imageLocation);
        URL location = this.getClass().getClassLoader().getResource(String.valueOf(imgLocation) + name);
        this.image = Toolkit.getDefaultToolkit().getImage(location);
    }

    private void invert() {
        if (this.x < 0) {
            this.x += Config.getInteger("morcego.viewWidth") - this.image.getWidth(Morcego.getApplication());
        }
        if (this.y < 0) {
            this.y += Config.getInteger("morcego.viewHeight") - this.image.getHeight(Morcego.getApplication());
        }
    }

    public void paint(Graphics g) {
        g.drawImage(this.image, this.x, this.y, this);
        Morcego o = Morcego.getApplication();
        this.boundRectangle = new Rectangle(this.x, this.y, this.image.getWidth(o), this.image.getHeight(o));
    }

    public void mouseClicked(MouseEvent e) {
        if (this.boundRectangle.contains(e.getX(), e.getY())) {
            System.out.println(e.toString());
        }
    }

    public void mouseEntered(MouseEvent e) {
        if (this.boundRectangle != null && this.boundRectangle.contains(e.getX(), e.getY())) {
            Morcego.setHandCursor();
        }
    }

    public void mouseExited(MouseEvent arg0) {
        Morcego.setDefaultCursor();
    }

    public void mousePressed(MouseEvent e) {
        if (this.boundRectangle.contains(e.getX(), e.getY())) {
            System.out.println(e.toString());
        }
    }

    public void mouseReleased(MouseEvent arg0) {
    }

    public void mouseDragged(MouseEvent arg0) {
    }

    public void mouseMoved(MouseEvent e) {
        if (this.mouseOver) {
            if (!this.boundRectangle.contains(e.getX(), e.getY())) {
                this.mouseExited(e);
                this.mouseOver = false;
            }
        } else if (this.boundRectangle.contains(e.getX(), e.getY())) {
            this.mouseEntered(e);
            this.mouseOver = true;
        }
    }
}

