/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad.actions;

import java.awt.FileDialog;
import java.awt.event.ActionEvent;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import org.jgraph.GPGraphpad;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultPort;
import org.jgraph.pad.GPGraph;
import org.jgraph.pad.GPUserObject;
import org.jgraph.pad.actions.AbstractActionDefault;
import org.jgraph.pad.resources.Translator;

public class FileImportSimple
extends AbstractActionDefault {
    public FileImportSimple(GPGraphpad gPGraphpad) {
        super(gPGraphpad);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        FileDialog fileDialog = new FileDialog(this.graphpad.getFrame(), Translator.getString("CustomFile"), 0);
        fileDialog.show();
        if (fileDialog.getFile() == null) {
            return;
        }
        try {
            String string = fileDialog.getDirectory() + fileDialog.getFile();
            String string2 = JOptionPane.showInputDialog(Translator.getString("DelimeterDialog"));
            String string3 = JOptionPane.showInputDialog(Translator.getString("EdgeLabelDialog"));
            GPGraph gPGraph = this.getCurrentGraph();
            FileImportSimple.parseSimpleFileInto(string, string2, gPGraph, string3);
        }
        catch (Exception exception) {
            this.graphpad.error(exception.toString());
        }
    }

    public static void parseSimpleFileInto(String string, String string2, GPGraph gPGraph, String string3) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            Object[] objectArray = gPGraph.getVertices(gPGraph.getAll());
            if (objectArray != null) {
                int n = 0;
                while (n < objectArray.length) {
                    if (objectArray[n] != null && objectArray[n].toString() != null) {
                        hashtable.put(objectArray[n].toString(), objectArray[n]);
                    }
                    ++n;
                }
            }
            Hashtable hashtable2 = new Hashtable();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ConnectionSet connectionSet = new ConnectionSet();
            while (dataInputStream.available() != 0) {
                String string4;
                HashSet<String> hashSet;
                String string5 = dataInputStream.readLine();
                StringTokenizer stringTokenizer = new StringTokenizer(string5, string2);
                if (!stringTokenizer.hasMoreTokens()) continue;
                String string6 = stringTokenizer.nextToken().trim();
                Object object = FileImportSimple.getVertexForKey(hashtable, string6);
                if (!gPGraph.getModel().contains(object) && !arrayList.contains(object)) {
                    arrayList.add(object);
                }
                if (!stringTokenizer.hasMoreTokens()) continue;
                String string7 = stringTokenizer.nextToken().trim();
                Object object2 = FileImportSimple.getVertexForKey(hashtable, string7);
                if (!gPGraph.getModel().contains(object2) && !arrayList.contains(object2)) {
                    arrayList.add(object2);
                }
                if ((hashSet = (HashSet<String>)hashtable2.get(string6)) == null) {
                    hashSet = new HashSet<String>();
                    hashtable2.put(string6, hashSet);
                }
                String string8 = string4 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken().trim() : string3;
                if (hashSet.contains(string7)) continue;
                DefaultEdge defaultEdge = new DefaultEdge(string4);
                Object object3 = gPGraph.getModel().getChild(object, 0);
                Object object4 = gPGraph.getModel().getChild(object2, 0);
                if (object3 == null || object4 == null) continue;
                connectionSet.connect((Object)defaultEdge, object3, object4);
                arrayList.add(defaultEdge);
                hashSet.add(string7);
            }
            dataInputStream.close();
            gPGraph.getModel().insert(arrayList.toArray(), null, connectionSet, null, null);
        }
        catch (Exception exception) {
            System.err.println("File input error: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public static Object getVertexForKey(Hashtable hashtable, String string) {
        Object object = hashtable.get(string);
        if (object == null) {
            DefaultGraphCell defaultGraphCell = new DefaultGraphCell(new GPUserObject(string));
            defaultGraphCell.add(new DefaultPort());
            object = defaultGraphCell;
            hashtable.put(string, object);
        }
        return object;
    }
}

