/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import org.jgraph.pad.resources.Translator;
import org.jgraph.utils.BrowserLauncher;

class InternalPopupMenu
extends JPopupMenu {
    JMenuItem jMenuItemClearWindow = new JMenuItem(Translator.getString("ClearOutput"));
    JMenuItem jMenuItemSaveToFile = new JMenuItem(Translator.getString("SaveToFile"));
    JMenuItem jMenuItemSendEmail = new JMenuItem(Translator.getString("Error.EmailTechSupport"));
    private JTextArea currentWindow = null;

    public InternalPopupMenu() {
        this.add(this.jMenuItemClearWindow);
        this.addSeparator();
        this.add(this.jMenuItemSaveToFile);
        this.add(this.jMenuItemSendEmail);
        this.jMenuItemClearWindow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InternalPopupMenu.this.clearWindow();
            }
        });
        this.jMenuItemSaveToFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InternalPopupMenu.this.saveWindowToFile();
            }
        });
        this.jMenuItemSendEmail.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = Translator.getString("Error.EmailTechSupportAddress");
                String string2 = "?subject=runtime error message&body=";
                String string3 = null;
                try {
                    string3 = URLEncoder.encode(InternalPopupMenu.this.currentWindow.getText(), "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    System.out.println(unsupportedEncodingException);
                }
                try {
                    BrowserLauncher.openURL("mailto:" + string + string2 + string3);
                }
                catch (IOException iOException) {
                    System.out.println(iOException);
                }
            }
        });
    }

    public void setTextArea(JTextArea jTextArea) {
        this.currentWindow = jTextArea;
    }

    private void clearWindow() {
        this.currentWindow.setText("");
    }

    private void saveWindowToFile() {
        JFileChooser jFileChooser = new JFileChooser();
        if (0 != jFileChooser.showSaveDialog(null)) {
            System.out.println("No file selected");
            return;
        }
        File file = jFileChooser.getSelectedFile();
        if (!file.canWrite()) {
            System.err.println("Can't write to file " + file.getAbsolutePath());
        }
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(file));
            printStream.println(this.currentWindow.getText());
            printStream.close();
            this.clearWindow();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Can't write to file " + file.getAbsolutePath());
        }
    }
}

