
# Generated from the Telepathy spec
""" Copyright (C) 2005, 2006 Collabora Limited 
 Copyright (C) 2005, 2006 Nokia Corporation 
 Copyright (C) 2006 INdT 

    This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
  
"""

import dbus.service


class ChannelInterfaceMediaSignalling(dbus.service.Interface):
    """\
      An interface for signalling a channel containing synchronised media
    sessions which can contain an arbitrary number of streams. The negotiation
    interface is based closely around the API of the Farsight library
    (http://farsight.sourceforge.net/). This in turn is based upon the IETF
    MMusic ICE drafts where connections are established by signalling potential
    connection candidates to the peer until a usable connection is found, and
    codecs are negotiated with an SDP-style offer and answer. However, the
    principles should be applicable to other media streaming methods and the
    API re-used without difficulty.
    """

    def __init__(self):
        self._interfaces.add('org.freedesktop.Telepathy.Channel.Interface.MediaSignalling')

    @dbus.service.method('org.freedesktop.Telepathy.Channel.Interface.MediaSignalling', in_signature='', out_signature='a(os)')
    def GetSessionHandlers(self):
        """
        Returns all currently active session handlers on this channel
        as a list of (session_handler_path, type).
      
        """
        raise NotImplementedError
  
    @dbus.service.signal('org.freedesktop.Telepathy.Channel.Interface.MediaSignalling', signature='os')
    def NewSessionHandler(self, Session_Handler, Session_Type):
        """
        Signal that a session handler object has been created. The client
        should create a session object and create streams for the streams
        within.
      
        """
        pass
  