#!/bin/sh
#
# This file is part of sudognu.
#
# Copyright (C) 2007 Jens Baaran, Germany.
#
# THERE IS NO WARRANTY FOR THIS PROGRAM, TO THE EXTENT PERMITTED
# BY APPLICABLE LAW.
#
# See the GPL Version 2 (http://www.gnu.org/licenses/gpl.html)
# or the file COPYING for details
# ******************************************************************************
set -f
TMPDIR=./tmp
CGISUDOKU=/usr/local/bin/sudognu

cat <<- END
	Content-type: text/html
	
	<html>
	<head>
	  <title>Printing sudokus ...</title>
	  <style type="text/css">
		body      { background-color:white; color:black; }
		td        { text-align:left; padding:2px 1ex 2px 1ex; }
		table     { text-align:center; }
		.ctr      { text-align:center; }
		.lft      { text-align:left; }
	  </style>
	</head>
	<body>
	<table>
END

PARAM_STRING=`echo $QUERY_STRING | egrep -o 'sudokus=[[:digit:]]+'`
SUDOKUS=`echo $PARAM_STRING | egrep -o '=[[:digit:]]+' | cut -b 2-`

echo "<tr><td>"
rm -f `find $TMPDIR -mmin +60 -name *.pdf`
rm -f `find $TMPDIR -mmin +60 -name *.svg`
fn=$TMPDIR/`date +%M-%S`.pdf
echo "</td></tr>"

echo "<tr><td>Sudokus are being solved and rated, before the pdf-file is created ...</td></tr>"
echo "</table>"
echo $SUDOKUS | $CGISUDOKU -p -o $fn

echo "<br><br><a href="$fn">pdf</a>"

echo "</body>"
echo "</html>"

