require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&URTW_CONFIG_NO)) {
    sub URTW_CONFIG_NO () {	1;}
}
unless(defined(&URTW_IFACE_INDEX)) {
    sub URTW_IFACE_INDEX () {	0;}
}
unless(defined(&URTW_MAC0)) {
    sub URTW_MAC0 () {	0x;}
}
unless(defined(&URTW_MAC1)) {
    sub URTW_MAC1 () {	0x1;}
}
unless(defined(&URTW_MAC2)) {
    sub URTW_MAC2 () {	0x2;}
}
unless(defined(&URTW_MAC3)) {
    sub URTW_MAC3 () {	0x3;}
}
unless(defined(&URTW_MAC4)) {
    sub URTW_MAC4 () {	0x4;}
}
unless(defined(&URTW_MAC5)) {
    sub URTW_MAC5 () {	0x5;}
}
unless(defined(&URTW_BRSR)) {
    sub URTW_BRSR () {	0x2c;}
}
unless(defined(&URTW_BRSR_MBR_8185)) {
    sub URTW_BRSR_MBR_8185 () {	(0xfff);}
}
unless(defined(&URTW_BSSID)) {
    sub URTW_BSSID () {	0x2e;}
}
unless(defined(&URTW_RESP_RATE)) {
    sub URTW_RESP_RATE () {	0x34;}
}
unless(defined(&URTW_RESP_MAX_RATE_SHIFT)) {
    sub URTW_RESP_MAX_RATE_SHIFT () {	(4);}
}
unless(defined(&URTW_RESP_MIN_RATE_SHIFT)) {
    sub URTW_RESP_MIN_RATE_SHIFT () {	(0);}
}
unless(defined(&URTW_EIFS)) {
    sub URTW_EIFS () {	0x35;}
}
unless(defined(&URTW_INTR_MASK)) {
    sub URTW_INTR_MASK () {	0x3c;}
}
unless(defined(&URTW_CMD)) {
    sub URTW_CMD () {	0x37;}
}
unless(defined(&URTW_CMD_TX_ENABLE)) {
    sub URTW_CMD_TX_ENABLE () {	(0x4);}
}
unless(defined(&URTW_CMD_RX_ENABLE)) {
    sub URTW_CMD_RX_ENABLE () {	(0x8);}
}
unless(defined(&URTW_CMD_RST)) {
    sub URTW_CMD_RST () {	(0x10);}
}
unless(defined(&URTW_TX_CONF)) {
    sub URTW_TX_CONF () {	0x40;}
}
unless(defined(&URTW_TX_LOOPBACK_SHIFT)) {
    sub URTW_TX_LOOPBACK_SHIFT () {	(17);}
}
unless(defined(&URTW_TX_LOOPBACK_NONE)) {
    sub URTW_TX_LOOPBACK_NONE () {	(0<<  &URTW_TX_LOOPBACK_SHIFT);}
}
unless(defined(&URTW_TX_LOOPBACK_MAC)) {
    sub URTW_TX_LOOPBACK_MAC () {	(1<<  &URTW_TX_LOOPBACK_SHIFT);}
}
unless(defined(&URTW_TX_LOOPBACK_BASEBAND)) {
    sub URTW_TX_LOOPBACK_BASEBAND () {	(2<<  &URTW_TX_LOOPBACK_SHIFT);}
}
unless(defined(&URTW_TX_LOOPBACK_CONTINUE)) {
    sub URTW_TX_LOOPBACK_CONTINUE () {	(3<<  &URTW_TX_LOOPBACK_SHIFT);}
}
unless(defined(&URTW_TX_LOOPBACK_MASK)) {
    sub URTW_TX_LOOPBACK_MASK () {	(0x60000);}
}
unless(defined(&URTW_TX_DPRETRY_MASK)) {
    sub URTW_TX_DPRETRY_MASK () {	(0xff00);}
}
unless(defined(&URTW_TX_RTSRETRY_MASK)) {
    sub URTW_TX_RTSRETRY_MASK () {	(0xff);}
}
unless(defined(&URTW_TX_DPRETRY_SHIFT)) {
    sub URTW_TX_DPRETRY_SHIFT () {	(0);}
}
unless(defined(&URTW_TX_RTSRETRY_SHIFT)) {
    sub URTW_TX_RTSRETRY_SHIFT () {	(8);}
}
unless(defined(&URTW_TX_NOCRC)) {
    sub URTW_TX_NOCRC () {	(0x10000);}
}
unless(defined(&URTW_TX_MXDMA_MASK)) {
    sub URTW_TX_MXDMA_MASK () {	(0xe00000);}
}
unless(defined(&URTW_TX_MXDMA_1024)) {
    sub URTW_TX_MXDMA_1024 () {	(6<<  &URTW_TX_MXDMA_SHIFT);}
}
unless(defined(&URTW_TX_MXDMA_2048)) {
    sub URTW_TX_MXDMA_2048 () {	(7<<  &URTW_TX_MXDMA_SHIFT);}
}
unless(defined(&URTW_TX_MXDMA_SHIFT)) {
    sub URTW_TX_MXDMA_SHIFT () {	(21);}
}
unless(defined(&URTW_TX_CWMIN)) {
    sub URTW_TX_CWMIN () {	(1<< 31);}
}
unless(defined(&URTW_TX_DISCW)) {
    sub URTW_TX_DISCW () {	(1<< 20);}
}
unless(defined(&URTW_TX_SWPLCPLEN)) {
    sub URTW_TX_SWPLCPLEN () {	(1<< 24);}
}
unless(defined(&URTW_TX_NOICV)) {
    sub URTW_TX_NOICV () {	(0x80000);}
}
unless(defined(&URTW_RX)) {
    sub URTW_RX () {	0x44;}
}
unless(defined(&URTW_RX_9356SEL)) {
    sub URTW_RX_9356SEL () {	(1<< 6);}
}
unless(defined(&URTW_RX_FILTER_MASK)) {
    sub URTW_RX_FILTER_MASK () {	( &URTW_RX_FILTER_ALLMAC |  &URTW_RX_FILTER_NICMAC |  &URTW_RX_FILTER_MCAST |  &URTW_RX_FILTER_BCAST |  &URTW_RX_FILTER_CRCERR |  &URTW_RX_FILTER_ICVERR |  &URTW_RX_FILTER_DATA |  &URTW_RX_FILTER_CTL |  &URTW_RX_FILTER_MNG | (1<< 21) |  &URTW_RX_FILTER_PWR |  &URTW_RX_CHECK_BSSID);}
}
unless(defined(&URTW_RX_FILTER_ALLMAC)) {
    sub URTW_RX_FILTER_ALLMAC () {	(0x1);}
}
unless(defined(&URTW_RX_FILTER_NICMAC)) {
    sub URTW_RX_FILTER_NICMAC () {	(0x2);}
}
unless(defined(&URTW_RX_FILTER_MCAST)) {
    sub URTW_RX_FILTER_MCAST () {	(0x4);}
}
unless(defined(&URTW_RX_FILTER_BCAST)) {
    sub URTW_RX_FILTER_BCAST () {	(0x8);}
}
unless(defined(&URTW_RX_FILTER_CRCERR)) {
    sub URTW_RX_FILTER_CRCERR () {	(0x20);}
}
unless(defined(&URTW_RX_FILTER_ICVERR)) {
    sub URTW_RX_FILTER_ICVERR () {	(0x1000);}
}
unless(defined(&URTW_RX_FILTER_DATA)) {
    sub URTW_RX_FILTER_DATA () {	(0x40000);}
}
unless(defined(&URTW_RX_FILTER_CTL)) {
    sub URTW_RX_FILTER_CTL () {	(0x80000);}
}
unless(defined(&URTW_RX_FILTER_MNG)) {
    sub URTW_RX_FILTER_MNG () {	(0x100000);}
}
unless(defined(&URTW_RX_FILTER_PWR)) {
    sub URTW_RX_FILTER_PWR () {	(0x400000);}
}
unless(defined(&URTW_RX_CHECK_BSSID)) {
    sub URTW_RX_CHECK_BSSID () {	(0x800000);}
}
unless(defined(&URTW_RX_FIFO_THRESHOLD_MASK)) {
    sub URTW_RX_FIFO_THRESHOLD_MASK () {	((1<< 13) | (1<< 14) | (1<< 15));}
}
unless(defined(&URTW_RX_FIFO_THRESHOLD_SHIFT)) {
    sub URTW_RX_FIFO_THRESHOLD_SHIFT () {	(13);}
}
unless(defined(&URTW_RX_FIFO_THRESHOLD_128)) {
    sub URTW_RX_FIFO_THRESHOLD_128 () {	(3);}
}
unless(defined(&URTW_RX_FIFO_THRESHOLD_256)) {
    sub URTW_RX_FIFO_THRESHOLD_256 () {	(4);}
}
unless(defined(&URTW_RX_FIFO_THRESHOLD_512)) {
    sub URTW_RX_FIFO_THRESHOLD_512 () {	(5);}
}
unless(defined(&URTW_RX_FIFO_THRESHOLD_1024)) {
    sub URTW_RX_FIFO_THRESHOLD_1024 () {	(6);}
}
unless(defined(&URTW_RX_FIFO_THRESHOLD_NONE)) {
    sub URTW_RX_FIFO_THRESHOLD_NONE () {	(7<<  &URTW_RX_FIFO_THRESHOLD_SHIFT);}
}
unless(defined(&URTW_RX_AUTORESETPHY)) {
    sub URTW_RX_AUTORESETPHY () {	(1<<  &URTW_RX_AUTORESETPHY_SHIFT);}
}
unless(defined(&URTW_RX_AUTORESETPHY_SHIFT)) {
    sub URTW_RX_AUTORESETPHY_SHIFT () {	(28);}
}
unless(defined(&URTW_MAX_RX_DMA_MASK)) {
    sub URTW_MAX_RX_DMA_MASK () {	((1<<8) | (1<<9) | (1<<10));}
}
unless(defined(&URTW_MAX_RX_DMA_2048)) {
    sub URTW_MAX_RX_DMA_2048 () {	(7<<  &URTW_MAX_RX_DMA_SHIFT);}
}
unless(defined(&URTW_MAX_RX_DMA_1024)) {
    sub URTW_MAX_RX_DMA_1024 () {	(6);}
}
unless(defined(&URTW_MAX_RX_DMA_SHIFT)) {
    sub URTW_MAX_RX_DMA_SHIFT () {	(10);}
}
unless(defined(&URTW_RCR_ONLYERLPKT)) {
    sub URTW_RCR_ONLYERLPKT () {	(1<< 31);}
}
unless(defined(&URTW_INT_TIMEOUT)) {
    sub URTW_INT_TIMEOUT () {	0x48;}
}
unless(defined(&URTW_EPROM_CMD)) {
    sub URTW_EPROM_CMD () {	0x50;}
}
unless(defined(&URTW_EPROM_CMD_NORMAL)) {
    sub URTW_EPROM_CMD_NORMAL () {	(0x);}
}
unless(defined(&URTW_EPROM_CMD_NORMAL_MODE)) {
    sub URTW_EPROM_CMD_NORMAL_MODE () {	( &URTW_EPROM_CMD_NORMAL <<  &URTW_EPROM_CMD_SHIFT);}
}
unless(defined(&URTW_EPROM_CMD_LOAD)) {
    sub URTW_EPROM_CMD_LOAD () {	(0x1);}
}
unless(defined(&URTW_EPROM_CMD_PROGRAM)) {
    sub URTW_EPROM_CMD_PROGRAM () {	(0x2);}
}
unless(defined(&URTW_EPROM_CMD_PROGRAM_MODE)) {
    sub URTW_EPROM_CMD_PROGRAM_MODE () {	( &URTW_EPROM_CMD_PROGRAM <<  &URTW_EPROM_CMD_SHIFT);}
}
unless(defined(&URTW_EPROM_CMD_CONFIG)) {
    sub URTW_EPROM_CMD_CONFIG () {	(0x3);}
}
unless(defined(&URTW_EPROM_CMD_SHIFT)) {
    sub URTW_EPROM_CMD_SHIFT () {	(6);}
}
unless(defined(&URTW_EPROM_CMD_MASK)) {
    sub URTW_EPROM_CMD_MASK () {	((1<< 7) | (1<< 6));}
}
unless(defined(&URTW_EPROM_READBIT)) {
    sub URTW_EPROM_READBIT () {	(0x1);}
}
unless(defined(&URTW_EPROM_WRITEBIT)) {
    sub URTW_EPROM_WRITEBIT () {	(0x2);}
}
unless(defined(&URTW_EPROM_CK)) {
    sub URTW_EPROM_CK () {	(0x4);}
}
unless(defined(&URTW_EPROM_CS)) {
    sub URTW_EPROM_CS () {	(0x8);}
}
unless(defined(&URTW_CONFIG2)) {
    sub URTW_CONFIG2 () {	0x53;}
}
unless(defined(&URTW_ANAPARAM)) {
    sub URTW_ANAPARAM () {	0x54;}
}
unless(defined(&URTW_8225_ANAPARAM_ON)) {
    sub URTW_8225_ANAPARAM_ON () {	(0xa0000a59);}
}
unless(defined(&URTW_MSR)) {
    sub URTW_MSR () {	0x58;}
}
unless(defined(&URTW_MSR_LINK_MASK)) {
    sub URTW_MSR_LINK_MASK () {	((1<< 2) | (1<< 3));}
}
unless(defined(&URTW_MSR_LINK_SHIFT)) {
    sub URTW_MSR_LINK_SHIFT () {	(2);}
}
unless(defined(&URTW_MSR_LINK_NONE)) {
    sub URTW_MSR_LINK_NONE () {	(0<<  &URTW_MSR_LINK_SHIFT);}
}
unless(defined(&URTW_MSR_LINK_ADHOC)) {
    sub URTW_MSR_LINK_ADHOC () {	(1<<  &URTW_MSR_LINK_SHIFT);}
}
unless(defined(&URTW_MSR_LINK_STA)) {
    sub URTW_MSR_LINK_STA () {	(2<<  &URTW_MSR_LINK_SHIFT);}
}
unless(defined(&URTW_MSR_LINK_HOSTAP)) {
    sub URTW_MSR_LINK_HOSTAP () {	(3<<  &URTW_MSR_LINK_SHIFT);}
}
unless(defined(&URTW_CONFIG3)) {
    sub URTW_CONFIG3 () {	0x59;}
}
unless(defined(&URTW_CONFIG3_ANAPARAM_WRITE)) {
    sub URTW_CONFIG3_ANAPARAM_WRITE () {	(0x40);}
}
unless(defined(&URTW_CONFIG3_ANAPARAM_W_SHIFT)) {
    sub URTW_CONFIG3_ANAPARAM_W_SHIFT () {	(6);}
}
unless(defined(&URTW_PSR)) {
    sub URTW_PSR () {	0x5e;}
}
unless(defined(&URTW_ANAPARAM2)) {
    sub URTW_ANAPARAM2 () {	0x60;}
}
unless(defined(&URTW_8225_ANAPARAM2_ON)) {
    sub URTW_8225_ANAPARAM2_ON () {	(0x860c7312);}
}
unless(defined(&URTW_BEACON_INTERVAL)) {
    sub URTW_BEACON_INTERVAL () {	0x70;}
}
unless(defined(&URTW_ATIM_WND)) {
    sub URTW_ATIM_WND () {	0x72;}
}
unless(defined(&URTW_BEACON_INTERVAL_TIME)) {
    sub URTW_BEACON_INTERVAL_TIME () {	0x74;}
}
unless(defined(&URTW_ATIM_TR_ITV)) {
    sub URTW_ATIM_TR_ITV () {	0x76;}
}
unless(defined(&URTW_RF_PINS_OUTPUT)) {
    sub URTW_RF_PINS_OUTPUT () {	0x80;}
}
unless(defined(&URTW_BB_HOST_BANG_CLK)) {
    sub URTW_BB_HOST_BANG_CLK () {	(1<< 1);}
}
unless(defined(&URTW_BB_HOST_BANG_EN)) {
    sub URTW_BB_HOST_BANG_EN () {	(1<< 2);}
}
unless(defined(&URTW_BB_HOST_BANG_RW)) {
    sub URTW_BB_HOST_BANG_RW () {	(1<< 3);}
}
unless(defined(&URTW_RF_PINS_ENABLE)) {
    sub URTW_RF_PINS_ENABLE () {	0x82;}
}
unless(defined(&URTW_RF_PINS_SELECT)) {
    sub URTW_RF_PINS_SELECT () {	0x84;}
}
unless(defined(&URTW_RF_PINS_INPUT)) {
    sub URTW_RF_PINS_INPUT () {	0x86;}
}
unless(defined(&URTW_RF_PARA)) {
    sub URTW_RF_PARA () {	0x88;}
}
unless(defined(&URTW_RF_TIMING)) {
    sub URTW_RF_TIMING () {	0x8c;}
}
unless(defined(&URTW_GP_ENABLE)) {
    sub URTW_GP_ENABLE () {	0x90;}
}
unless(defined(&URTW_GPIO)) {
    sub URTW_GPIO () {	0x91;}
}
unless(defined(&URTW_TX_AGC_CTL)) {
    sub URTW_TX_AGC_CTL () {	0x9c;}
}
unless(defined(&URTW_TX_AGC_CTL_PERPACKET_GAIN)) {
    sub URTW_TX_AGC_CTL_PERPACKET_GAIN () {	(0x1);}
}
unless(defined(&URTW_TX_AGC_CTL_PERPACKET_ANTSEL)) {
    sub URTW_TX_AGC_CTL_PERPACKET_ANTSEL () {	(0x2);}
}
unless(defined(&URTW_TX_AGC_CTL_FEEDBACK_ANT)) {
    sub URTW_TX_AGC_CTL_FEEDBACK_ANT () {	(0x4);}
}
unless(defined(&URTW_TX_GAIN_CCK)) {
    sub URTW_TX_GAIN_CCK () {	0x9d;}
}
unless(defined(&URTW_TX_GAIN_OFDM)) {
    sub URTW_TX_GAIN_OFDM () {	0x9e;}
}
unless(defined(&URTW_TX_ANTENNA)) {
    sub URTW_TX_ANTENNA () {	0x9f;}
}
unless(defined(&URTW_WPA_CONFIG)) {
    sub URTW_WPA_CONFIG () {	0xb0;}
}
unless(defined(&URTW_SIFS)) {
    sub URTW_SIFS () {	0xb4;}
}
unless(defined(&URTW_DIFS)) {
    sub URTW_DIFS () {	0xb5;}
}
unless(defined(&URTW_SLOT)) {
    sub URTW_SLOT () {	0xb6;}
}
unless(defined(&URTW_CW_CONF)) {
    sub URTW_CW_CONF () {	0xbc;}
}
unless(defined(&URTW_CW_CONF_PERPACKET_RETRY)) {
    sub URTW_CW_CONF_PERPACKET_RETRY () {	(0x2);}
}
unless(defined(&URTW_CW_CONF_PERPACKET_CW)) {
    sub URTW_CW_CONF_PERPACKET_CW () {	(0x1);}
}
unless(defined(&URTW_CW_VAL)) {
    sub URTW_CW_VAL () {	0xbd;}
}
unless(defined(&URTW_RATE_FALLBACK)) {
    sub URTW_RATE_FALLBACK () {	0xbe;}
}
unless(defined(&URTW_TALLY_SEL)) {
    sub URTW_TALLY_SEL () {	0xfc;}
}
unless(defined(&URTW_EPROM_TXPW_BASE)) {
    sub URTW_EPROM_TXPW_BASE () {	0x5;}
}
unless(defined(&URTW_EPROM_RFCHIPID)) {
    sub URTW_EPROM_RFCHIPID () {	0x6;}
}
unless(defined(&URTW_EPROM_RFCHIPID_RTL8225U)) {
    sub URTW_EPROM_RFCHIPID_RTL8225U () {	(5);}
}
unless(defined(&URTW_EPROM_MACADDR)) {
    sub URTW_EPROM_MACADDR () {	0x7;}
}
unless(defined(&URTW_EPROM_TXPW0)) {
    sub URTW_EPROM_TXPW0 () {	0x16;}
}
unless(defined(&URTW_EPROM_TXPW2)) {
    sub URTW_EPROM_TXPW2 () {	0x1b;}
}
unless(defined(&URTW_EPROM_TXPW1)) {
    sub URTW_EPROM_TXPW1 () {	0x3d;}
}
unless(defined(&URTW_EPROM_SWREV)) {
    sub URTW_EPROM_SWREV () {	0x3f;}
}
unless(defined(&URTW_EPROM_CID_MASK)) {
    sub URTW_EPROM_CID_MASK () {	(0xff);}
}
unless(defined(&URTW_EPROM_CID_RSVD0)) {
    sub URTW_EPROM_CID_RSVD0 () {	(0x);}
}
unless(defined(&URTW_EPROM_CID_RSVD1)) {
    sub URTW_EPROM_CID_RSVD1 () {	(0xff);}
}
unless(defined(&URTW_EPROM_CID_ALPHA0)) {
    sub URTW_EPROM_CID_ALPHA0 () {	(0x1);}
}
unless(defined(&URTW_EPROM_CID_SERCOMM_PS)) {
    sub URTW_EPROM_CID_SERCOMM_PS () {	(0x2);}
}
unless(defined(&URTW_EPROM_CID_HW_LED)) {
    sub URTW_EPROM_CID_HW_LED () {	(0x3);}
}
unless(defined(&URTW_CID_DEFAULT)) {
    sub URTW_CID_DEFAULT () {	0;}
}
unless(defined(&URTW_CID_8187_ALPHA0)) {
    sub URTW_CID_8187_ALPHA0 () {	1;}
}
unless(defined(&URTW_CID_8187_SERCOMM_PS)) {
    sub URTW_CID_8187_SERCOMM_PS () {	2;}
}
unless(defined(&URTW_CID_8187_HW_LED)) {
    sub URTW_CID_8187_HW_LED () {	3;}
}
unless(defined(&URTW_SW_LED_MODE0)) {
    sub URTW_SW_LED_MODE0 () {	0;}
}
unless(defined(&URTW_SW_LED_MODE1)) {
    sub URTW_SW_LED_MODE1 () {	1;}
}
unless(defined(&URTW_SW_LED_MODE2)) {
    sub URTW_SW_LED_MODE2 () {	2;}
}
unless(defined(&URTW_SW_LED_MODE3)) {
    sub URTW_SW_LED_MODE3 () {	3;}
}
unless(defined(&URTW_HW_LED)) {
    sub URTW_HW_LED () {	4;}
}
unless(defined(&URTW_LED_CTL_POWER_ON)) {
    sub URTW_LED_CTL_POWER_ON () {	0;}
}
unless(defined(&URTW_LED_CTL_LINK)) {
    sub URTW_LED_CTL_LINK () {	2;}
}
unless(defined(&URTW_LED_CTL_TX)) {
    sub URTW_LED_CTL_TX () {	4;}
}
unless(defined(&URTW_LED_PIN_GPIO0)) {
    sub URTW_LED_PIN_GPIO0 () {	0;}
}
unless(defined(&URTW_LED_PIN_LED0)) {
    sub URTW_LED_PIN_LED0 () {	1;}
}
unless(defined(&URTW_LED_PIN_LED1)) {
    sub URTW_LED_PIN_LED1 () {	2;}
}
unless(defined(&URTW_LED_UNKNOWN)) {
    sub URTW_LED_UNKNOWN () {	0;}
}
unless(defined(&URTW_LED_ON)) {
    sub URTW_LED_ON () {	1;}
}
unless(defined(&URTW_LED_OFF)) {
    sub URTW_LED_OFF () {	2;}
}
unless(defined(&URTW_LED_BLINK_NORMAL)) {
    sub URTW_LED_BLINK_NORMAL () {	3;}
}
unless(defined(&URTW_LED_BLINK_SLOWLY)) {
    sub URTW_LED_BLINK_SLOWLY () {	4;}
}
unless(defined(&URTW_LED_POWER_ON_BLINK)) {
    sub URTW_LED_POWER_ON_BLINK () {	5;}
}
unless(defined(&URTW_LED_SCAN_BLINK)) {
    sub URTW_LED_SCAN_BLINK () {	6;}
}
unless(defined(&URTW_LED_NO_LINK_BLINK)) {
    sub URTW_LED_NO_LINK_BLINK () {	7;}
}
unless(defined(&URTW_LED_BLINK_CM3)) {
    sub URTW_LED_BLINK_CM3 () {	8;}
}
unless(defined(&URTW_EPROM_DISABLE)) {
    sub URTW_EPROM_DISABLE () {	0;}
}
unless(defined(&URTW_EPROM_ENABLE)) {
    sub URTW_EPROM_ENABLE () {	1;}
}
unless(defined(&URTW_EPROM_DELAY)) {
    sub URTW_EPROM_DELAY () {	10;}
}
unless(defined(&URTW_8187_GETREGS_REQ)) {
    sub URTW_8187_GETREGS_REQ () {	5;}
}
unless(defined(&URTW_8187_SETREGS_REQ)) {
    sub URTW_8187_SETREGS_REQ () {	5;}
}
unless(defined(&URTW_8225_RF_MAX_SENS)) {
    sub URTW_8225_RF_MAX_SENS () {	6;}
}
unless(defined(&URTW_8225_RF_DEF_SENS)) {
    sub URTW_8225_RF_DEF_SENS () {	4;}
}
unless(defined(&URTW_DEFAULT_RTS_RETRY)) {
    sub URTW_DEFAULT_RTS_RETRY () {	7;}
}
unless(defined(&URTW_DEFAULT_TX_RETRY)) {
    sub URTW_DEFAULT_TX_RETRY () {	7;}
}
unless(defined(&URTW_DEFAULT_RTS_THRESHOLD)) {
    sub URTW_DEFAULT_RTS_THRESHOLD () {	2342;}
}
unless(defined(&URTW_MAX_CHANNELS)) {
    sub URTW_MAX_CHANNELS () {	15;}
}
unless(defined(&URTW_MIN_RXBUFSZ)) {
    sub URTW_MIN_RXBUFSZ () {	($sizeof{'struct ieee80211_frame_min'});}
}
unless(defined(&URTW_RX_DATA_LIST_COUNT)) {
    sub URTW_RX_DATA_LIST_COUNT () {	1;}
}
unless(defined(&URTW_TX_DATA_LIST_COUNT)) {
    sub URTW_TX_DATA_LIST_COUNT () {	16;}
}
unless(defined(&URTW_RX_MAXSIZE)) {
    sub URTW_RX_MAXSIZE () {	0x9c4;}
}
unless(defined(&URTW_TX_MAXSIZE)) {
    sub URTW_TX_MAXSIZE () {	0x9c4;}
}
unless(defined(&URTW_RX_RADIOTAP_PRESENT)) {
    sub URTW_RX_RADIOTAP_PRESENT () {	((1<<  &IEEE80211_RADIOTAP_FLAGS) | (1<<  &IEEE80211_RADIOTAP_CHANNEL) | (1<<  &IEEE80211_RADIOTAP_DBM_ANTSIGNAL));}
}
unless(defined(&URTW_TX_RADIOTAP_PRESENT)) {
    sub URTW_TX_RADIOTAP_PRESENT () {	((1<<  &IEEE80211_RADIOTAP_FLAGS) | (1<<  &IEEE80211_RADIOTAP_CHANNEL));}
}
unless(defined(&URTW_INIT_ONCE)) {
    sub URTW_INIT_ONCE () {	(1<< 1);}
}
unless(defined(&URTW_SET_CHANNEL)) {
    sub URTW_SET_CHANNEL () {	1;}
}
unless(defined(&URTW_EEPROM_93C46)) {
    sub URTW_EEPROM_93C46 () {	0;}
}
unless(defined(&URTW_EEPROM_93C56)) {
    sub URTW_EEPROM_93C56 () {	1;}
}
unless(defined(&URTW_LED_GPIO)) {
    sub URTW_LED_GPIO () {	1;}
}
unless(defined(&URTW_PRIORITY_LOW)) {
    sub URTW_PRIORITY_LOW () {	0;}
}
unless(defined(&URTW_PRIORITY_NORMAL)) {
    sub URTW_PRIORITY_NORMAL () {	1;}
}
unless(defined(&URTW_DATA_TIMEOUT)) {
    sub URTW_DATA_TIMEOUT () {	10000;}
}
if((defined(&NBPFILTER) ? &NBPFILTER : undef) > 0) {
    eval 'sub sc_rxtap () { ($sc_rxtapu->{th});}' unless defined(&sc_rxtap);
    eval 'sub sc_txtap () { ($sc_txtapu->{th});}' unless defined(&sc_txtap);
}
1;
