require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__R128_DRV_H__)) {
    eval 'sub __R128_DRV_H__ () {1;}' unless defined(&__R128_DRV_H__);
    eval 'sub DRIVER_AUTHOR () {"Gareth Hughes, VA Linux Systems Inc.";}' unless defined(&DRIVER_AUTHOR);
    eval 'sub DRIVER_NAME () {"r128";}' unless defined(&DRIVER_NAME);
    eval 'sub DRIVER_DESC () {"ATI Rage 128";}' unless defined(&DRIVER_DESC);
    eval 'sub DRIVER_DATE () {"20030725";}' unless defined(&DRIVER_DATE);
    eval 'sub DRIVER_MAJOR () {2;}' unless defined(&DRIVER_MAJOR);
    eval 'sub DRIVER_MINOR () {5;}' unless defined(&DRIVER_MINOR);
    eval 'sub DRIVER_PATCHLEVEL () {0;}' unless defined(&DRIVER_PATCHLEVEL);
    eval 'sub GET_RING_HEAD {
        my($dev_priv) = @_;
	    eval q( &R128_READ(  &R128_PM4_BUFFER_DL_RPTR ));
    }' unless defined(&GET_RING_HEAD);
    eval 'sub R128_AUX_SC_CNTL () {0x1660;}' unless defined(&R128_AUX_SC_CNTL);
    eval 'sub R128_AUX1_SC_EN () {(1<< 0);}' unless defined(&R128_AUX1_SC_EN);
    eval 'sub R128_AUX1_SC_MODE_OR () {(0<< 1);}' unless defined(&R128_AUX1_SC_MODE_OR);
    eval 'sub R128_AUX1_SC_MODE_NAND () {(1<< 1);}' unless defined(&R128_AUX1_SC_MODE_NAND);
    eval 'sub R128_AUX2_SC_EN () {(1<< 2);}' unless defined(&R128_AUX2_SC_EN);
    eval 'sub R128_AUX2_SC_MODE_OR () {(0<< 3);}' unless defined(&R128_AUX2_SC_MODE_OR);
    eval 'sub R128_AUX2_SC_MODE_NAND () {(1<< 3);}' unless defined(&R128_AUX2_SC_MODE_NAND);
    eval 'sub R128_AUX3_SC_EN () {(1<< 4);}' unless defined(&R128_AUX3_SC_EN);
    eval 'sub R128_AUX3_SC_MODE_OR () {(0<< 5);}' unless defined(&R128_AUX3_SC_MODE_OR);
    eval 'sub R128_AUX3_SC_MODE_NAND () {(1<< 5);}' unless defined(&R128_AUX3_SC_MODE_NAND);
    eval 'sub R128_AUX1_SC_LEFT () {0x1664;}' unless defined(&R128_AUX1_SC_LEFT);
    eval 'sub R128_AUX1_SC_RIGHT () {0x1668;}' unless defined(&R128_AUX1_SC_RIGHT);
    eval 'sub R128_AUX1_SC_TOP () {0x166c;}' unless defined(&R128_AUX1_SC_TOP);
    eval 'sub R128_AUX1_SC_BOTTOM () {0x1670;}' unless defined(&R128_AUX1_SC_BOTTOM);
    eval 'sub R128_AUX2_SC_LEFT () {0x1674;}' unless defined(&R128_AUX2_SC_LEFT);
    eval 'sub R128_AUX2_SC_RIGHT () {0x1678;}' unless defined(&R128_AUX2_SC_RIGHT);
    eval 'sub R128_AUX2_SC_TOP () {0x167c;}' unless defined(&R128_AUX2_SC_TOP);
    eval 'sub R128_AUX2_SC_BOTTOM () {0x1680;}' unless defined(&R128_AUX2_SC_BOTTOM);
    eval 'sub R128_AUX3_SC_LEFT () {0x1684;}' unless defined(&R128_AUX3_SC_LEFT);
    eval 'sub R128_AUX3_SC_RIGHT () {0x1688;}' unless defined(&R128_AUX3_SC_RIGHT);
    eval 'sub R128_AUX3_SC_TOP () {0x168c;}' unless defined(&R128_AUX3_SC_TOP);
    eval 'sub R128_AUX3_SC_BOTTOM () {0x1690;}' unless defined(&R128_AUX3_SC_BOTTOM);
    eval 'sub R128_BRUSH_DATA0 () {0x1480;}' unless defined(&R128_BRUSH_DATA0);
    eval 'sub R128_BUS_CNTL () {0x30;}' unless defined(&R128_BUS_CNTL);
    eval 'sub R128_BUS_MASTER_DIS () {(1<< 6);}' unless defined(&R128_BUS_MASTER_DIS);
    eval 'sub R128_CLOCK_CNTL_INDEX () {0x8;}' unless defined(&R128_CLOCK_CNTL_INDEX);
    eval 'sub R128_CLOCK_CNTL_DATA () {0xc;}' unless defined(&R128_CLOCK_CNTL_DATA);
    eval 'sub R128_PLL_WR_EN () {(1<< 7);}' unless defined(&R128_PLL_WR_EN);
    eval 'sub R128_CONSTANT_COLOR_C () {0x1d34;}' unless defined(&R128_CONSTANT_COLOR_C);
    eval 'sub R128_CRTC_OFFSET () {0x224;}' unless defined(&R128_CRTC_OFFSET);
    eval 'sub R128_CRTC_OFFSET_CNTL () {0x228;}' unless defined(&R128_CRTC_OFFSET_CNTL);
    eval 'sub R128_CRTC_OFFSET_FLIP_CNTL () {(1<< 16);}' unless defined(&R128_CRTC_OFFSET_FLIP_CNTL);
    eval 'sub R128_DP_GUI_MASTER_CNTL () {0x146c;}' unless defined(&R128_DP_GUI_MASTER_CNTL);
    eval 'sub R128_GMC_SRC_PITCH_OFFSET_CNTL () {(1<< 0);}' unless defined(&R128_GMC_SRC_PITCH_OFFSET_CNTL);
    eval 'sub R128_GMC_DST_PITCH_OFFSET_CNTL () {(1<< 1);}' unless defined(&R128_GMC_DST_PITCH_OFFSET_CNTL);
    eval 'sub R128_GMC_BRUSH_SOLID_COLOR () {(13<< 4);}' unless defined(&R128_GMC_BRUSH_SOLID_COLOR);
    eval 'sub R128_GMC_BRUSH_NONE () {(15<< 4);}' unless defined(&R128_GMC_BRUSH_NONE);
    eval 'sub R128_GMC_DST_16BPP () {(4<< 8);}' unless defined(&R128_GMC_DST_16BPP);
    eval 'sub R128_GMC_DST_24BPP () {(5<< 8);}' unless defined(&R128_GMC_DST_24BPP);
    eval 'sub R128_GMC_DST_32BPP () {(6<< 8);}' unless defined(&R128_GMC_DST_32BPP);
    eval 'sub R128_GMC_DST_DATATYPE_SHIFT () {8;}' unless defined(&R128_GMC_DST_DATATYPE_SHIFT);
    eval 'sub R128_GMC_SRC_DATATYPE_COLOR () {(3<< 12);}' unless defined(&R128_GMC_SRC_DATATYPE_COLOR);
    eval 'sub R128_DP_SRC_SOURCE_MEMORY () {(2<< 24);}' unless defined(&R128_DP_SRC_SOURCE_MEMORY);
    eval 'sub R128_DP_SRC_SOURCE_HOST_DATA () {(3<< 24);}' unless defined(&R128_DP_SRC_SOURCE_HOST_DATA);
    eval 'sub R128_GMC_CLR_CMP_CNTL_DIS () {(1<< 28);}' unless defined(&R128_GMC_CLR_CMP_CNTL_DIS);
    eval 'sub R128_GMC_AUX_CLIP_DIS () {(1<< 29);}' unless defined(&R128_GMC_AUX_CLIP_DIS);
    eval 'sub R128_GMC_WR_MSK_DIS () {(1<< 30);}' unless defined(&R128_GMC_WR_MSK_DIS);
    eval 'sub R128_ROP3_S () {0xcc0000;}' unless defined(&R128_ROP3_S);
    eval 'sub R128_ROP3_P () {0xf00000;}' unless defined(&R128_ROP3_P);
    eval 'sub R128_DP_WRITE_MASK () {0x16cc;}' unless defined(&R128_DP_WRITE_MASK);
    eval 'sub R128_DST_PITCH_OFFSET_C () {0x1c80;}' unless defined(&R128_DST_PITCH_OFFSET_C);
    eval 'sub R128_DST_TILE () {(1<< 31);}' unless defined(&R128_DST_TILE);
    eval 'sub R128_GEN_INT_CNTL () {0x40;}' unless defined(&R128_GEN_INT_CNTL);
    eval 'sub R128_CRTC_VBLANK_INT_EN () {(1<< 0);}' unless defined(&R128_CRTC_VBLANK_INT_EN);
    eval 'sub R128_GEN_INT_STATUS () {0x44;}' unless defined(&R128_GEN_INT_STATUS);
    eval 'sub R128_CRTC_VBLANK_INT () {(1<< 0);}' unless defined(&R128_CRTC_VBLANK_INT);
    eval 'sub R128_CRTC_VBLANK_INT_AK () {(1<< 0);}' unless defined(&R128_CRTC_VBLANK_INT_AK);
    eval 'sub R128_GEN_RESET_CNTL () {0xf0;}' unless defined(&R128_GEN_RESET_CNTL);
    eval 'sub R128_SOFT_RESET_GUI () {(1<< 0);}' unless defined(&R128_SOFT_RESET_GUI);
    eval 'sub R128_GUI_SCRATCH_REG0 () {0x15e0;}' unless defined(&R128_GUI_SCRATCH_REG0);
    eval 'sub R128_GUI_SCRATCH_REG1 () {0x15e4;}' unless defined(&R128_GUI_SCRATCH_REG1);
    eval 'sub R128_GUI_SCRATCH_REG2 () {0x15e8;}' unless defined(&R128_GUI_SCRATCH_REG2);
    eval 'sub R128_GUI_SCRATCH_REG3 () {0x15ec;}' unless defined(&R128_GUI_SCRATCH_REG3);
    eval 'sub R128_GUI_SCRATCH_REG4 () {0x15f0;}' unless defined(&R128_GUI_SCRATCH_REG4);
    eval 'sub R128_GUI_SCRATCH_REG5 () {0x15f4;}' unless defined(&R128_GUI_SCRATCH_REG5);
    eval 'sub R128_GUI_STAT () {0x1740;}' unless defined(&R128_GUI_STAT);
    eval 'sub R128_GUI_FIFOCNT_MASK () {0xfff;}' unless defined(&R128_GUI_FIFOCNT_MASK);
    eval 'sub R128_GUI_ACTIVE () {(1<< 31);}' unless defined(&R128_GUI_ACTIVE);
    eval 'sub R128_MCLK_CNTL () {0xf;}' unless defined(&R128_MCLK_CNTL);
    eval 'sub R128_FORCE_GCP () {(1<< 16);}' unless defined(&R128_FORCE_GCP);
    eval 'sub R128_FORCE_PIPE3D_CP () {(1<< 17);}' unless defined(&R128_FORCE_PIPE3D_CP);
    eval 'sub R128_FORCE_RCP () {(1<< 18);}' unless defined(&R128_FORCE_RCP);
    eval 'sub R128_PC_GUI_CTLSTAT () {0x1748;}' unless defined(&R128_PC_GUI_CTLSTAT);
    eval 'sub R128_PC_NGUI_CTLSTAT () {0x184;}' unless defined(&R128_PC_NGUI_CTLSTAT);
    eval 'sub R128_PC_FLUSH_GUI () {(3<< 0);}' unless defined(&R128_PC_FLUSH_GUI);
    eval 'sub R128_PC_RI_GUI () {(1<< 2);}' unless defined(&R128_PC_RI_GUI);
    eval 'sub R128_PC_FLUSH_ALL () {0xff;}' unless defined(&R128_PC_FLUSH_ALL);
    eval 'sub R128_PC_BUSY () {(1<< 31);}' unless defined(&R128_PC_BUSY);
    eval 'sub R128_PCI_GART_PAGE () {0x17c;}' unless defined(&R128_PCI_GART_PAGE);
    eval 'sub R128_PRIM_TEX_CNTL_C () {0x1cb0;}' unless defined(&R128_PRIM_TEX_CNTL_C);
    eval 'sub R128_SCALE_3D_CNTL () {0x1a00;}' unless defined(&R128_SCALE_3D_CNTL);
    eval 'sub R128_SEC_TEX_CNTL_C () {0x1d00;}' unless defined(&R128_SEC_TEX_CNTL_C);
    eval 'sub R128_SEC_TEXTURE_BORDER_COLOR_C () {0x1d3c;}' unless defined(&R128_SEC_TEXTURE_BORDER_COLOR_C);
    eval 'sub R128_SETUP_CNTL () {0x1bc4;}' unless defined(&R128_SETUP_CNTL);
    eval 'sub R128_STEN_REF_MASK_C () {0x1d40;}' unless defined(&R128_STEN_REF_MASK_C);
    eval 'sub R128_TEX_CNTL_C () {0x1c9c;}' unless defined(&R128_TEX_CNTL_C);
    eval 'sub R128_TEX_CACHE_FLUSH () {(1<< 23);}' unless defined(&R128_TEX_CACHE_FLUSH);
    eval 'sub R128_WAIT_UNTIL () {0x1720;}' unless defined(&R128_WAIT_UNTIL);
    eval 'sub R128_EVENT_CRTC_OFFSET () {(1<< 0);}' unless defined(&R128_EVENT_CRTC_OFFSET);
    eval 'sub R128_WINDOW_XY_OFFSET () {0x1bcc;}' unless defined(&R128_WINDOW_XY_OFFSET);
    eval 'sub R128_PM4_BUFFER_OFFSET () {0x700;}' unless defined(&R128_PM4_BUFFER_OFFSET);
    eval 'sub R128_PM4_BUFFER_CNTL () {0x704;}' unless defined(&R128_PM4_BUFFER_CNTL);
    eval 'sub R128_PM4_MASK () {(15<< 28);}' unless defined(&R128_PM4_MASK);
    eval 'sub R128_PM4_NONPM4 () {(0<< 28);}' unless defined(&R128_PM4_NONPM4);
    eval 'sub R128_PM4_192PIO () {(1<< 28);}' unless defined(&R128_PM4_192PIO);
    eval 'sub R128_PM4_192BM () {(2<< 28);}' unless defined(&R128_PM4_192BM);
    eval 'sub R128_PM4_128PIO_64INDBM () {(3<< 28);}' unless defined(&R128_PM4_128PIO_64INDBM);
    eval 'sub R128_PM4_128BM_64INDBM () {(4<< 28);}' unless defined(&R128_PM4_128BM_64INDBM);
    eval 'sub R128_PM4_64PIO_128INDBM () {(5<< 28);}' unless defined(&R128_PM4_64PIO_128INDBM);
    eval 'sub R128_PM4_64BM_128INDBM () {(6<< 28);}' unless defined(&R128_PM4_64BM_128INDBM);
    eval 'sub R128_PM4_64PIO_64VCBM_64INDBM () {(7<< 28);}' unless defined(&R128_PM4_64PIO_64VCBM_64INDBM);
    eval 'sub R128_PM4_64BM_64VCBM_64INDBM () {(8<< 28);}' unless defined(&R128_PM4_64BM_64VCBM_64INDBM);
    eval 'sub R128_PM4_64PIO_64VCPIO_64INDPIO () {(15<< 28);}' unless defined(&R128_PM4_64PIO_64VCPIO_64INDPIO);
    eval 'sub R128_PM4_BUFFER_CNTL_NOUPDATE () {(1<< 27);}' unless defined(&R128_PM4_BUFFER_CNTL_NOUPDATE);
    eval 'sub R128_PM4_BUFFER_WM_CNTL () {0x708;}' unless defined(&R128_PM4_BUFFER_WM_CNTL);
    eval 'sub R128_WMA_SHIFT () {0;}' unless defined(&R128_WMA_SHIFT);
    eval 'sub R128_WMB_SHIFT () {8;}' unless defined(&R128_WMB_SHIFT);
    eval 'sub R128_WMC_SHIFT () {16;}' unless defined(&R128_WMC_SHIFT);
    eval 'sub R128_WB_WM_SHIFT () {24;}' unless defined(&R128_WB_WM_SHIFT);
    eval 'sub R128_PM4_BUFFER_DL_RPTR_ADDR () {0x70c;}' unless defined(&R128_PM4_BUFFER_DL_RPTR_ADDR);
    eval 'sub R128_PM4_BUFFER_DL_RPTR () {0x710;}' unless defined(&R128_PM4_BUFFER_DL_RPTR);
    eval 'sub R128_PM4_BUFFER_DL_WPTR () {0x714;}' unless defined(&R128_PM4_BUFFER_DL_WPTR);
    eval 'sub R128_PM4_BUFFER_DL_DONE () {(1<< 31);}' unless defined(&R128_PM4_BUFFER_DL_DONE);
    eval 'sub R128_PM4_VC_FPU_SETUP () {0x71c;}' unless defined(&R128_PM4_VC_FPU_SETUP);
    eval 'sub R128_PM4_IW_INDOFF () {0x738;}' unless defined(&R128_PM4_IW_INDOFF);
    eval 'sub R128_PM4_IW_INDSIZE () {0x73c;}' unless defined(&R128_PM4_IW_INDSIZE);
    eval 'sub R128_PM4_STAT () {0x7b8;}' unless defined(&R128_PM4_STAT);
    eval 'sub R128_PM4_FIFOCNT_MASK () {0xfff;}' unless defined(&R128_PM4_FIFOCNT_MASK);
    eval 'sub R128_PM4_BUSY () {(1<< 16);}' unless defined(&R128_PM4_BUSY);
    eval 'sub R128_PM4_GUI_ACTIVE () {(1<< 31);}' unless defined(&R128_PM4_GUI_ACTIVE);
    eval 'sub R128_PM4_MICROCODE_ADDR () {0x7d4;}' unless defined(&R128_PM4_MICROCODE_ADDR);
    eval 'sub R128_PM4_MICROCODE_RADDR () {0x7d8;}' unless defined(&R128_PM4_MICROCODE_RADDR);
    eval 'sub R128_PM4_MICROCODE_DATAH () {0x7dc;}' unless defined(&R128_PM4_MICROCODE_DATAH);
    eval 'sub R128_PM4_MICROCODE_DATAL () {0x7e0;}' unless defined(&R128_PM4_MICROCODE_DATAL);
    eval 'sub R128_PM4_BUFFER_ADDR () {0x7f0;}' unless defined(&R128_PM4_BUFFER_ADDR);
    eval 'sub R128_PM4_MICRO_CNTL () {0x7fc;}' unless defined(&R128_PM4_MICRO_CNTL);
    eval 'sub R128_PM4_MICRO_FREERUN () {(1<< 30);}' unless defined(&R128_PM4_MICRO_FREERUN);
    eval 'sub R128_PM4_FIFO_DATA_EVEN () {0x1000;}' unless defined(&R128_PM4_FIFO_DATA_EVEN);
    eval 'sub R128_PM4_FIFO_DATA_ODD () {0x1004;}' unless defined(&R128_PM4_FIFO_DATA_ODD);
    eval 'sub R128_CCE_PACKET0 () {0x;}' unless defined(&R128_CCE_PACKET0);
    eval 'sub R128_CCE_PACKET1 () {0x40000000;}' unless defined(&R128_CCE_PACKET1);
    eval 'sub R128_CCE_PACKET2 () {0x80000000;}' unless defined(&R128_CCE_PACKET2);
    eval 'sub R128_CCE_PACKET3 () {0xc0000000;}' unless defined(&R128_CCE_PACKET3);
    eval 'sub R128_CNTL_HOSTDATA_BLT () {0x9400;}' unless defined(&R128_CNTL_HOSTDATA_BLT);
    eval 'sub R128_CNTL_PAINT_MULTI () {0x9a00;}' unless defined(&R128_CNTL_PAINT_MULTI);
    eval 'sub R128_CNTL_BITBLT_MULTI () {0x9b00;}' unless defined(&R128_CNTL_BITBLT_MULTI);
    eval 'sub R128_3D_RNDR_GEN_INDX_PRIM () {0x2300;}' unless defined(&R128_3D_RNDR_GEN_INDX_PRIM);
    eval 'sub R128_CCE_PACKET_MASK () {0xc0000000;}' unless defined(&R128_CCE_PACKET_MASK);
    eval 'sub R128_CCE_PACKET_COUNT_MASK () {0x3fff0000;}' unless defined(&R128_CCE_PACKET_COUNT_MASK);
    eval 'sub R128_CCE_PACKET0_REG_MASK () {0x7ff;}' unless defined(&R128_CCE_PACKET0_REG_MASK);
    eval 'sub R128_CCE_PACKET1_REG0_MASK () {0x7ff;}' unless defined(&R128_CCE_PACKET1_REG0_MASK);
    eval 'sub R128_CCE_PACKET1_REG1_MASK () {0x3ff800;}' unless defined(&R128_CCE_PACKET1_REG1_MASK);
    eval 'sub R128_CCE_VC_CNTL_PRIM_TYPE_NONE () {0x;}' unless defined(&R128_CCE_VC_CNTL_PRIM_TYPE_NONE);
    eval 'sub R128_CCE_VC_CNTL_PRIM_TYPE_POINT () {0x1;}' unless defined(&R128_CCE_VC_CNTL_PRIM_TYPE_POINT);
    eval 'sub R128_CCE_VC_CNTL_PRIM_TYPE_LINE () {0x2;}' unless defined(&R128_CCE_VC_CNTL_PRIM_TYPE_LINE);
    eval 'sub R128_CCE_VC_CNTL_PRIM_TYPE_POLY_LINE () {0x3;}' unless defined(&R128_CCE_VC_CNTL_PRIM_TYPE_POLY_LINE);
    eval 'sub R128_CCE_VC_CNTL_PRIM_TYPE_TRI_LIST () {0x4;}' unless defined(&R128_CCE_VC_CNTL_PRIM_TYPE_TRI_LIST);
    eval 'sub R128_CCE_VC_CNTL_PRIM_TYPE_TRI_FAN () {0x5;}' unless defined(&R128_CCE_VC_CNTL_PRIM_TYPE_TRI_FAN);
    eval 'sub R128_CCE_VC_CNTL_PRIM_TYPE_TRI_STRIP () {0x6;}' unless defined(&R128_CCE_VC_CNTL_PRIM_TYPE_TRI_STRIP);
    eval 'sub R128_CCE_VC_CNTL_PRIM_TYPE_TRI_TYPE2 () {0x7;}' unless defined(&R128_CCE_VC_CNTL_PRIM_TYPE_TRI_TYPE2);
    eval 'sub R128_CCE_VC_CNTL_PRIM_WALK_IND () {0x10;}' unless defined(&R128_CCE_VC_CNTL_PRIM_WALK_IND);
    eval 'sub R128_CCE_VC_CNTL_PRIM_WALK_LIST () {0x20;}' unless defined(&R128_CCE_VC_CNTL_PRIM_WALK_LIST);
    eval 'sub R128_CCE_VC_CNTL_PRIM_WALK_RING () {0x30;}' unless defined(&R128_CCE_VC_CNTL_PRIM_WALK_RING);
    eval 'sub R128_CCE_VC_CNTL_NUM_SHIFT () {16;}' unless defined(&R128_CCE_VC_CNTL_NUM_SHIFT);
    eval 'sub R128_DATATYPE_VQ () {0;}' unless defined(&R128_DATATYPE_VQ);
    eval 'sub R128_DATATYPE_CI4 () {1;}' unless defined(&R128_DATATYPE_CI4);
    eval 'sub R128_DATATYPE_CI8 () {2;}' unless defined(&R128_DATATYPE_CI8);
    eval 'sub R128_DATATYPE_ARGB1555 () {3;}' unless defined(&R128_DATATYPE_ARGB1555);
    eval 'sub R128_DATATYPE_RGB565 () {4;}' unless defined(&R128_DATATYPE_RGB565);
    eval 'sub R128_DATATYPE_RGB888 () {5;}' unless defined(&R128_DATATYPE_RGB888);
    eval 'sub R128_DATATYPE_ARGB8888 () {6;}' unless defined(&R128_DATATYPE_ARGB8888);
    eval 'sub R128_DATATYPE_RGB332 () {7;}' unless defined(&R128_DATATYPE_RGB332);
    eval 'sub R128_DATATYPE_Y8 () {8;}' unless defined(&R128_DATATYPE_Y8);
    eval 'sub R128_DATATYPE_RGB8 () {9;}' unless defined(&R128_DATATYPE_RGB8);
    eval 'sub R128_DATATYPE_CI16 () {10;}' unless defined(&R128_DATATYPE_CI16);
    eval 'sub R128_DATATYPE_YVYU422 () {11;}' unless defined(&R128_DATATYPE_YVYU422);
    eval 'sub R128_DATATYPE_VYUY422 () {12;}' unless defined(&R128_DATATYPE_VYUY422);
    eval 'sub R128_DATATYPE_AYUV444 () {14;}' unless defined(&R128_DATATYPE_AYUV444);
    eval 'sub R128_DATATYPE_ARGB4444 () {15;}' unless defined(&R128_DATATYPE_ARGB4444);
    eval 'sub R128_AGP_OFFSET () {0x2000000;}' unless defined(&R128_AGP_OFFSET);
    eval 'sub R128_WATERMARK_L () {16;}' unless defined(&R128_WATERMARK_L);
    eval 'sub R128_WATERMARK_M () {8;}' unless defined(&R128_WATERMARK_M);
    eval 'sub R128_WATERMARK_N () {8;}' unless defined(&R128_WATERMARK_N);
    eval 'sub R128_WATERMARK_K () {128;}' unless defined(&R128_WATERMARK_K);
    eval 'sub R128_MAX_USEC_TIMEOUT () {100000;}' unless defined(&R128_MAX_USEC_TIMEOUT);
    eval 'sub R128_LAST_FRAME_REG () { &R128_GUI_SCRATCH_REG0;}' unless defined(&R128_LAST_FRAME_REG);
    eval 'sub R128_LAST_DISPATCH_REG () { &R128_GUI_SCRATCH_REG1;}' unless defined(&R128_LAST_DISPATCH_REG);
    eval 'sub R128_MAX_VB_AGE () {0x7fffffff;}' unless defined(&R128_MAX_VB_AGE);
    eval 'sub R128_MAX_VB_VERTS () {(0xffff);}' unless defined(&R128_MAX_VB_VERTS);
    eval 'sub R128_RING_HIGH_MARK () {128;}' unless defined(&R128_RING_HIGH_MARK);
    eval 'sub R128_PERFORMANCE_BOXES () {0;}' unless defined(&R128_PERFORMANCE_BOXES);
    eval 'sub R128_PCIGART_TABLE_SIZE () {32768;}' unless defined(&R128_PCIGART_TABLE_SIZE);
    eval 'sub R128_READ {
        my($reg) = @_;
	    eval q( &bus_space_read_4( ($dev_priv->{regs}->{bst}),  ($dev_priv->{regs}->{bsh}), ($reg)));
    }' unless defined(&R128_READ);
    eval 'sub R128_WRITE {
        my($reg,$val) = @_;
	    eval q( &bus_space_write_4( ($dev_priv->{regs}->{bst}),  ($dev_priv->{regs}->{bsh}), ($reg), ($val)));
    }' unless defined(&R128_WRITE);
    eval 'sub R128_READ8 {
        my($reg) = @_;
	    eval q( &bus_space_read_1( ($dev_priv->{regs}->{bst}),  ($dev_priv->{regs}->{bsh}), ($reg)));
    }' unless defined(&R128_READ8);
    eval 'sub R128_WRITE8 {
        my($reg,$val) = @_;
	    eval q( &bus_space_write_1( ($dev_priv->{regs}->{bst}),  ($dev_priv->{regs}->{bsh}), ($reg), ($val)));
    }' unless defined(&R128_WRITE8);
    eval 'sub R128_WRITE_PLL {
        my($addr,$val) = @_;
	    eval q( &do {  &R128_WRITE8( &R128_CLOCK_CNTL_INDEX, (($addr) & 0x1f) |  &R128_PLL_WR_EN);  &R128_WRITE( &R128_CLOCK_CNTL_DATA, ($val)); }  &while (0));
    }' unless defined(&R128_WRITE_PLL);
    eval 'sub CCE_PACKET0 {
        my( $reg, $n ) = @_;
	    eval q(( &R128_CCE_PACKET0 | (( &n) << 16) | (($reg) >> 2)));
    }' unless defined(&CCE_PACKET0);
    eval 'sub CCE_PACKET1 {
        my( $reg0, $reg1 ) = @_;
	    eval q(( &R128_CCE_PACKET1 | ((($reg1) >> 2) << 11) | (($reg0) >> 2)));
    }' unless defined(&CCE_PACKET1);
    eval 'sub CCE_PACKET2 () {
        eval q(( &R128_CCE_PACKET2));
    }' unless defined(&CCE_PACKET2);
    eval 'sub CCE_PACKET3 {
        my( $pkt, $n ) = @_;
	    eval q(( &R128_CCE_PACKET3 | ($pkt) | (( &n) << 16)));
    }' unless defined(&CCE_PACKET3);
    eval 'sub RING_SPACE_TEST_WITH_RETURN {
        my( $dev_priv ) = @_;
	    eval q( &do {  &drm_r128_ring_buffer_t * &ring =  ($dev_priv->{ring}); \'int\'  &i;  &if (  ($ring->{space}) <  ($ring->{high_mark}) ) {  &for (  &i = 0;  &i <  ($dev_priv->{usec_timeout}) ;  &i++ ) {  &r128_update_ring_snapshot( $dev_priv );  &if (  ($ring->{space}) >=  ($ring->{high_mark}) )  &goto  &__ring_space_done;  &DRM_UDELAY(1); }  &DRM_ERROR( \\"ring space check failed!\\\\n\\" );  &return  &EBUSY; }  &__ring_space_done: ; }  &while (0));
    }' unless defined(&RING_SPACE_TEST_WITH_RETURN);
    eval 'sub VB_AGE_TEST_WITH_RETURN {
        my( $dev_priv ) = @_;
	    eval q( &do {  &drm_r128_sarea_t * &sarea_priv =  ($dev_priv->{sarea_priv});  &if (  ($sarea_priv->{last_dispatch}) >=  &R128_MAX_VB_AGE ) { \'int\'  &__ret =  &r128_do_cce_idle( $dev_priv );  &if (  &__ret )  &return  &__ret;  ($sarea_priv->{last_dispatch}) = 0;  &r128_freelist_reset(  &dev ); } }  &while (0));
    }' unless defined(&VB_AGE_TEST_WITH_RETURN);
    eval 'sub R128_WAIT_UNTIL_PAGE_FLIPPED () {
        eval q( &do {  &OUT_RING(  &CCE_PACKET0(  &R128_WAIT_UNTIL, 0) );  &OUT_RING(  &R128_EVENT_CRTC_OFFSET ); }  &while (0));
    }' unless defined(&R128_WAIT_UNTIL_PAGE_FLIPPED);
    eval 'sub R128_VERBOSE () {0;}' unless defined(&R128_VERBOSE);
    eval 'sub RING_LOCALS () {\'int\'  &write,  &_nr; \'unsigned int tail_mask\';  &volatile  &u32 * &ring;;}' unless defined(&RING_LOCALS);
    eval 'sub BEGIN_RING {
        my( $n ) = @_;
	    eval q( &do {  &if (  &R128_VERBOSE ) {  &DRM_INFO( \\"BEGIN_RING( %d )\\\\n\\", ( &n)); }  &if (  ($dev_priv->{ring}->{space}) <= ( &n) * $sizeof{ &u32} ) {  &COMMIT_RING();  &r128_wait_ring(  &dev_priv, ( &n) * $sizeof{ &u32} ); }  &_nr =  &n;  ($dev_priv->{ring}->{space}) -= ( &n) * $sizeof{ &u32};  &ring =  ($dev_priv->{ring}->{start});  &write =  ($dev_priv->{ring}->{tail});  &tail_mask =  ($dev_priv->{ring}->{tail_mask}); }  &while (0));
    }' unless defined(&BEGIN_RING);
    eval 'sub R128_BROKEN_CCE () {1;}' unless defined(&R128_BROKEN_CCE);
    eval 'sub ADVANCE_RING () {
        eval q( &do {  &if (  &R128_VERBOSE ) {  &DRM_INFO( \\"ADVANCE_RING() wr=0x%06x tail=0x%06x\\\\n\\",  &write,  ($dev_priv->{ring}->{tail}) ); }  &if (  &R128_BROKEN_CCE  &&  &write < 32) {  &memcpy(  ($dev_priv->{ring}->{end}),  ($dev_priv->{ring}->{start}),  &write * $sizeof{ &u32} ); }  &if ((( ($dev_priv->{ring}->{tail}) +  &_nr) &  &tail_mask) !=  &write) {  &DRM_ERROR( \\"ADVANCE_RING(): mismatch: nr: %x write: %x line: %d\\\\n\\", (( ($dev_priv->{ring}->{tail}) +  &_nr) &  &tail_mask),  &write,  &__LINE__); }  &else  ($dev_priv->{ring}->{tail}) =  &write; }  &while (0));
    }' unless defined(&ADVANCE_RING);
    eval 'sub COMMIT_RING () {
        eval q( &do {  &if (  &R128_VERBOSE ) {  &DRM_INFO( \\"COMMIT_RING() tail=0x%06x\\\\n\\",  ($dev_priv->{ring}->{tail}) ); }  &DRM_MEMORYBARRIER();  &R128_WRITE(  &R128_PM4_BUFFER_DL_WPTR,  ($dev_priv->{ring}->{tail}) );  &R128_READ(  &R128_PM4_BUFFER_DL_WPTR ); }  &while (0));
    }' unless defined(&COMMIT_RING);
    eval 'sub OUT_RING {
        my( $x ) = @_;
	    eval q( &do {  &if {  &DRM_INFO( \\"   OUT_RING( 0x%08x ) at 0x%x\\\\n\\", ( &x),  &write ); }  $ring[ &write++] =  &cpu_to_le32(  &x );  &write &=  &tail_mask; }  &while (0));
    }' unless defined(&OUT_RING);
}
1;
