require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_DRM_P_H_)) {
    eval 'sub _DRM_P_H_ () {1;}' unless defined(&_DRM_P_H_);
    if(defined( &_KERNEL) || defined( &__KERNEL__)) {
	require 'sys/param.ph';
	require 'sys/queue.ph';
	require 'sys/malloc.ph';
	require 'sys/kernel.ph';
	require 'sys/systm.ph';
	require 'sys/conf.ph';
	require 'sys/stat.ph';
	require 'sys/proc.ph';
	require 'sys/resource.ph';
	require 'sys/resourcevar.ph';
	require 'sys/mutex.ph';
	require 'sys/fcntl.ph';
	require 'sys/filio.ph';
	require 'sys/signalvar.ph';
	require 'sys/poll.ph';
	require 'sys/tree.ph';
	require 'sys/endian.ph';
	require 'sys/mman.ph';
	require 'sys/stdint.ph';
	require 'sys/agpio.ph';
	require 'sys/memrange.ph';
	require 'sys/extent.ph';
	require 'sys/vnode.ph';
	require 'uvm/uvm.ph';
	require 'dev/pci/pcidevs.ph';
	require 'dev/pci/pcivar.ph';
	require 'dev/pci/agpvar.ph';
	require 'dev/pci/vga_pcivar.ph';
	require 'machine/param.ph';
	require 'machine/bus.ph';
	require 'drm.ph';
	require 'drm_linux_list.ph';
	require 'drm_atomic.ph';
	eval 'sub DRM_KERNEL_CONTEXT () {0;}' unless defined(&DRM_KERNEL_CONTEXT);
	eval 'sub DRM_RESERVED_CONTEXTS () {1;}' unless defined(&DRM_RESERVED_CONTEXTS);
	eval 'sub DRM_MEM_DMA () {0;}' unless defined(&DRM_MEM_DMA);
	eval 'sub DRM_MEM_SAREA () {1;}' unless defined(&DRM_MEM_SAREA);
	eval 'sub DRM_MEM_DRIVER () {2;}' unless defined(&DRM_MEM_DRIVER);
	eval 'sub DRM_MEM_MAGIC () {3;}' unless defined(&DRM_MEM_MAGIC);
	eval 'sub DRM_MEM_IOCTLS () {4;}' unless defined(&DRM_MEM_IOCTLS);
	eval 'sub DRM_MEM_MAPS () {5;}' unless defined(&DRM_MEM_MAPS);
	eval 'sub DRM_MEM_BUFS () {6;}' unless defined(&DRM_MEM_BUFS);
	eval 'sub DRM_MEM_SEGS () {7;}' unless defined(&DRM_MEM_SEGS);
	eval 'sub DRM_MEM_PAGES () {8;}' unless defined(&DRM_MEM_PAGES);
	eval 'sub DRM_MEM_FILES () {9;}' unless defined(&DRM_MEM_FILES);
	eval 'sub DRM_MEM_QUEUES () {10;}' unless defined(&DRM_MEM_QUEUES);
	eval 'sub DRM_MEM_CMDS () {11;}' unless defined(&DRM_MEM_CMDS);
	eval 'sub DRM_MEM_MAPPINGS () {12;}' unless defined(&DRM_MEM_MAPPINGS);
	eval 'sub DRM_MEM_BUFLISTS () {13;}' unless defined(&DRM_MEM_BUFLISTS);
	eval 'sub DRM_MEM_AGPLISTS () {14;}' unless defined(&DRM_MEM_AGPLISTS);
	eval 'sub DRM_MEM_TOTALAGP () {15;}' unless defined(&DRM_MEM_TOTALAGP);
	eval 'sub DRM_MEM_BOUNDAGP () {16;}' unless defined(&DRM_MEM_BOUNDAGP);
	eval 'sub DRM_MEM_CTXBITMAP () {17;}' unless defined(&DRM_MEM_CTXBITMAP);
	eval 'sub DRM_MEM_CTXLIST () {18;}' unless defined(&DRM_MEM_CTXLIST);
	eval 'sub DRM_MEM_STUB () {19;}' unless defined(&DRM_MEM_STUB);
	eval 'sub DRM_MEM_SGLISTS () {20;}' unless defined(&DRM_MEM_SGLISTS);
	eval 'sub DRM_MEM_DRAWABLE () {21;}' unless defined(&DRM_MEM_DRAWABLE);
	eval 'sub DRM_MEM_MM () {22;}' unless defined(&DRM_MEM_MM);
	eval 'sub DRM_MAX_CTXBITMAP () {( &PAGE_SIZE * 8);}' unless defined(&DRM_MAX_CTXBITMAP);
	eval 'sub DRM_ARRAY_SIZE {
	    my($x) = @_;
    	    eval q(($sizeof{$x}/$sizeof{$x->[0]}));
	}' unless defined(&DRM_ARRAY_SIZE);
	eval 'sub DRM_MIN {
	    my($a,$b) = @_;
    	    eval q((($a)<($b)?($a):($b)));
	}' unless defined(&DRM_MIN);
	eval 'sub DRM_MAX {
	    my($a,$b) = @_;
    	    eval q((($a)>($b)?($a):($b)));
	}' unless defined(&DRM_MAX);
	eval 'sub DRM_IF_VERSION {
	    my($maj, $min) = @_;
    	    eval q(($maj << 16| $min));
	}' unless defined(&DRM_IF_VERSION);
	eval 'sub __OS_HAS_AGP () {1;}' unless defined(&__OS_HAS_AGP);
	eval 'sub DRM_WAKEUP {
	    my($w) = @_;
    	    eval q( &wakeup(( &void *)$w));
	}' unless defined(&DRM_WAKEUP);
	eval 'sub DRM_CURPROC () { &curproc;}' unless defined(&DRM_CURPROC);
	eval 'sub DRM_CURRENTPID () { ($curproc->{p_pid});}' unless defined(&DRM_CURRENTPID);
	eval 'sub DRM_NOOP () { &do {}  &while(0);}' unless defined(&DRM_NOOP);
	eval 'sub DRM_SPINTYPE () {\'struct mutex\';}' unless defined(&DRM_SPINTYPE);
	eval 'sub DRM_SPININIT {
	    my($l,$name) = @_;
    	    eval q( &mtx_init($l, &IPL_NONE));
	}' unless defined(&DRM_SPININIT);
	eval 'sub DRM_SPINUNINIT {
	    my($l) = @_;
    	    eval q( &DRM_NOOP);
	}' unless defined(&DRM_SPINUNINIT);
	eval 'sub DRM_SPINLOCK {
	    my($l) = @_;
    	    eval q( &mtx_enter($l));
	}' unless defined(&DRM_SPINLOCK);
	eval 'sub DRM_SPINUNLOCK {
	    my($l) = @_;
    	    eval q( &mtx_leave($l));
	}' unless defined(&DRM_SPINUNLOCK);
	eval 'sub DRM_SPINLOCK_IRQSAVE {
	    my($l, $irqflags) = @_;
    	    eval q( &do {  &DRM_SPINLOCK($l); ( &void)$irqflags; }  &while (0));
	}' unless defined(&DRM_SPINLOCK_IRQSAVE);
	eval 'sub DRM_SPINUNLOCK_IRQRESTORE {
	    my($u, $irqflags) = @_;
    	    eval q( &DRM_SPINUNLOCK($u));
	}' unless defined(&DRM_SPINUNLOCK_IRQRESTORE);
	eval 'sub DRM_SPINLOCK_ASSERT {
	    my($l) = @_;
    	    eval q( &DRM_NOOP);
	}' unless defined(&DRM_SPINLOCK_ASSERT);
	eval 'sub DRM_LOCK () {
	    eval q( &rw_enter_write( ($dev->{dev_lock})));
	}' unless defined(&DRM_LOCK);
	eval 'sub DRM_UNLOCK () {
	    eval q( &rw_exit_write( ($dev->{dev_lock})));
	}' unless defined(&DRM_UNLOCK);
	eval 'sub DRM_MAXUNITS () {8;}' unless defined(&DRM_MAXUNITS);
	eval 'sub printk () { &printf;}' unless defined(&printk);
	eval 'sub __unused () {1;}' unless defined(&__unused);
	eval 'sub DRM_IRQ_ARGS () { &void * &arg;}' unless defined(&DRM_IRQ_ARGS);
	eval 'sub IRQ_HANDLED () {1;}' unless defined(&IRQ_HANDLED);
	eval 'sub IRQ_NONE () {0;}' unless defined(&IRQ_NONE);
	eval("sub DRM_IS_NOT_AGP () { 0; }") unless defined(&DRM_IS_NOT_AGP);
	eval("sub DRM_IS_AGP () { 1; }") unless defined(&DRM_IS_AGP);
	eval("sub DRM_MIGHT_BE_AGP () { 2; }") unless defined(&DRM_MIGHT_BE_AGP);
	eval 'sub DRM_AGP_MEM () {\'struct agp_memory_info\';}' unless defined(&DRM_AGP_MEM);
	eval 'sub drm_get_device_from_kdev {
	    my($_kdev) = @_;
    	    eval q(( ($drm_cd->{cd_ndevs}) > 0?  ($drm_cd->{cd_devs[0]}) :  &NULL));
	}' unless defined(&drm_get_device_from_kdev);
	if(0) {
	    eval 'sub drm_get_device_from_kdev {
	        my($_kdev) = @_;
    		eval q(( &minor($_kdev) <  ($drm_cd->{cd_ndevs})) ?  ($drm_cd->{cd_devs[minor($_kdev)]}) :  &NULL);
	    }' unless defined(&drm_get_device_from_kdev);
	}
	eval 'sub DRM_SUSER {
	    my($p) = @_;
    	    eval q(( &suser($p,  ($p->{p_acflag})) == 0));
	}' unless defined(&DRM_SUSER);
	eval 'sub jiffies () { &ticks;}' unless defined(&jiffies);
	eval 'sub DRM_MTRR_WC () { &MDF_WRITECOMBINE;}' unless defined(&DRM_MTRR_WC);
	eval 'sub PAGE_ALIGN {
	    my($addr) = @_;
    	    eval q(((($addr) +  &PAGE_SIZE - 1) &  &PAGE_MASK));
	}' unless defined(&PAGE_ALIGN);
	if(defined( &__i386__)) {
	    eval 'sub DRM_READMEMORYBARRIER () {
	        eval q( &__asm  &__volatile( \\"lock; addl $0,0(%%esp)\\" : : : \\"memory\\"););
	    }' unless defined(&DRM_READMEMORYBARRIER);
	    eval 'sub DRM_WRITEMEMORYBARRIER () {
	        eval q( &__asm  &__volatile(\\"\\" : : : \\"memory\\"););
	    }' unless defined(&DRM_WRITEMEMORYBARRIER);
	    eval 'sub DRM_MEMORYBARRIER () {
	        eval q( &__asm  &__volatile( \\"lock; addl $0,0(%%esp)\\" : : : \\"memory\\"););
	    }' unless defined(&DRM_MEMORYBARRIER);
	}
 elsif(defined( &__alpha__)) {
	    eval 'sub DRM_READMEMORYBARRIER () {
	        eval q( &alpha_mb(););
	    }' unless defined(&DRM_READMEMORYBARRIER);
	    eval 'sub DRM_WRITEMEMORYBARRIER () {
	        eval q( &alpha_wmb(););
	    }' unless defined(&DRM_WRITEMEMORYBARRIER);
	    eval 'sub DRM_MEMORYBARRIER () {
	        eval q( &alpha_mb(););
	    }' unless defined(&DRM_MEMORYBARRIER);
	}
 elsif(defined( &__amd64__)) {
	    eval 'sub DRM_READMEMORYBARRIER () {
	        eval q( &__asm  &__volatile( \\"lock; addl $0,0(%%rsp)\\" : : : \\"memory\\"););
	    }' unless defined(&DRM_READMEMORYBARRIER);
	    eval 'sub DRM_WRITEMEMORYBARRIER () {
	        eval q( &__asm  &__volatile(\\"\\" : : : \\"memory\\"););
	    }' unless defined(&DRM_WRITEMEMORYBARRIER);
	    eval 'sub DRM_MEMORYBARRIER () {
	        eval q( &__asm  &__volatile( \\"lock; addl $0,0(%%rsp)\\" : : : \\"memory\\"););
	    }' unless defined(&DRM_MEMORYBARRIER);
	}
	eval 'sub DRM_READ8 {
	    my($map, $offset) = @_;
    	    eval q( &drm_read8($map, $offset));
	}' unless defined(&DRM_READ8);
	eval 'sub DRM_READ16 {
	    my($map, $offset) = @_;
    	    eval q( &drm_read16($map, $offset));
	}' unless defined(&DRM_READ16);
	eval 'sub DRM_READ32 {
	    my($map, $offset) = @_;
    	    eval q( &drm_read32($map, $offset));
	}' unless defined(&DRM_READ32);
	eval 'sub DRM_WRITE8 {
	    my($map, $offset, $val) = @_;
    	    eval q( &drm_write8($map, $offset, $val));
	}' unless defined(&DRM_WRITE8);
	eval 'sub DRM_WRITE16 {
	    my($map, $offset, $val) = @_;
    	    eval q( &drm_write16($map, $offset, $val));
	}' unless defined(&DRM_WRITE16);
	eval 'sub DRM_WRITE32 {
	    my($map, $offset, $val) = @_;
    	    eval q( &drm_write32($map, $offset, $val));
	}' unless defined(&DRM_WRITE32);
	eval 'sub DRM_VERIFYAREA_READ {
	    my( $uaddr, $size ) = @_;
    	    eval q((! &uvm_map_checkprot(( ($curproc->{p_vmspace}->{vm_map})), ( &vaddr_t)$uaddr, ( &vaddr_t)$uaddr+$size,  &UVM_PROT_READ)));
	}' unless defined(&DRM_VERIFYAREA_READ);
	eval 'sub DRM_COPY_TO_USER {
	    my($user, $kern, $size) = @_;
    	    eval q( &copyout($kern, $user, $size));
	}' unless defined(&DRM_COPY_TO_USER);
	eval 'sub DRM_COPY_FROM_USER {
	    my($kern, $user, $size) = @_;
    	    eval q( &copyin($user, $kern, $size));
	}' unless defined(&DRM_COPY_FROM_USER);
	eval 'sub DRM_COPY_FROM_USER_UNCHECKED {
	    my($arg1, $arg2, $arg3) = @_;
    	    eval q( &copyin($arg2, $arg1, $arg3));
	}' unless defined(&DRM_COPY_FROM_USER_UNCHECKED);
	eval 'sub DRM_COPY_TO_USER_UNCHECKED {
	    my($arg1, $arg2, $arg3) = @_;
    	    eval q( &copyout($arg2, $arg1, $arg3));
	}' unless defined(&DRM_COPY_TO_USER_UNCHECKED);
	eval 'sub DRM_GET_USER_UNCHECKED {
	    my($val, $uaddr) = @_;
    	    eval q((($val) =  &fuword($uaddr), 0));
	}' unless defined(&DRM_GET_USER_UNCHECKED);
	eval 'sub le32_to_cpu {
	    my($x) = @_;
    	    eval q( &letoh32($x));
	}' unless defined(&le32_to_cpu);
	eval 'sub cpu_to_le32 {
	    my($x) = @_;
    	    eval q( &htole32($x));
	}' unless defined(&cpu_to_le32);
	eval 'sub DRM_HZ () { &hz;}' unless defined(&DRM_HZ);
	eval 'sub DRM_UDELAY {
	    my($udelay) = @_;
    	    eval q( &DELAY($udelay));
	}' unless defined(&DRM_UDELAY);
	eval 'sub LOCK_TEST_WITH_RETURN {
	    my($dev, $file_priv) = @_;
    	    eval q( &do {  &if (! &_DRM_LOCK_IS_HELD( ($dev->{lock}->{hw_lock}->{lock})) ||  ($dev->{lock}->{file_priv}) != $file_priv) {  &DRM_ERROR(\\"%s called without lock held\\\\n\\",  &__FUNCTION__);  &return  &EINVAL; } }  &while (0));
	}' unless defined(&LOCK_TEST_WITH_RETURN);
	eval 'sub DRM_WAIT_ON {
	    my( $ret, $queue, $timeout, $condition ) = @_;
    	    eval q( &DRM_SPINLOCK( ($dev->{irq_lock}));  &while ( $ret == 0) {  &if ($condition)  &break; $ret =  &msleep(($queue),  ($dev->{irq_lock}),  &PZERO |  &PCATCH, \\"drmwtq\\", ($timeout)); }  &DRM_SPINUNLOCK( ($dev->{irq_lock})));
	}' unless defined(&DRM_WAIT_ON);
	eval 'sub DRM_ERROR () {( &fmt,  &arg...)  &printf("error: ["  &DRM_NAME ":pid%d:%s] *ERROR* "  &fmt,  &DRM_CURRENTPID,  &__func__ ,   &arg);}' unless defined(&DRM_ERROR);
	eval 'sub DRM_INFO () {( &fmt,  &arg...)  &printf("%s: "  &fmt,  ($dev_priv->{dev}->{dv_xname}),   &arg);}' unless defined(&DRM_INFO);
	if(defined(&DRMDEBUG)) {
	    undef(&DRM_DEBUG) if defined(&DRM_DEBUG);
	    eval 'sub DRM_DEBUG () {( &fmt,  &arg...)  &do {  &if ( &drm_debug_flag)  &printf("["  &DRM_NAME ":pid%d:%s] "  &fmt,  &DRM_CURRENTPID,  &__func__ ,   &arg); }  &while (0);}' unless defined(&DRM_DEBUG);
	} else {
	    eval 'sub DRM_DEBUG () {( &fmt,  &arg...)  &do { }  &while( 0);}' unless defined(&DRM_DEBUG);
	}
	eval("sub _DRM_DMA_USE_AGP () { 0x01; }") unless defined(&_DRM_DMA_USE_AGP);
	eval("sub _DRM_DMA_USE_SG () { 0x02; }") unless defined(&_DRM_DMA_USE_SG);
	eval 'sub DRM_ATI_GART_MAIN () {1;}' unless defined(&DRM_ATI_GART_MAIN);
	eval 'sub DRM_ATI_GART_FB () {2;}' unless defined(&DRM_ATI_GART_FB);
	eval 'sub DRM_ATI_GART_PCI () {1;}' unless defined(&DRM_ATI_GART_PCI);
	eval 'sub DRM_ATI_GART_PCIE () {2;}' unless defined(&DRM_ATI_GART_PCIE);
	eval 'sub DRM_ATI_GART_IGP () {3;}' unless defined(&DRM_ATI_GART_IGP);
	eval 'sub DMA_BIT_MASK {
	    my($n) = @_;
    	    eval q(((($n) == 64) ? ~0 : (1<<($n)) -1));
	}' unless defined(&DMA_BIT_MASK);
	eval 'sub upper_32_bits {
	    my($_val) = @_;
    	    eval q((( &u_int32_t)((($_val) >> 16) >> 16)));
	}' unless defined(&upper_32_bits);
	eval 'sub DRIVER_AGP () {0x1;}' unless defined(&DRIVER_AGP);
	eval 'sub DRIVER_AGP_REQUIRE () {0x2;}' unless defined(&DRIVER_AGP_REQUIRE);
	eval 'sub DRIVER_MTRR () {0x4;}' unless defined(&DRIVER_MTRR);
	eval 'sub DRIVER_DMA () {0x8;}' unless defined(&DRIVER_DMA);
	eval 'sub DRIVER_PCI_DMA () {0x10;}' unless defined(&DRIVER_PCI_DMA);
	eval 'sub DRIVER_SG () {0x20;}' unless defined(&DRIVER_SG);
	eval 'sub DRIVER_IRQ () {0x40;}' unless defined(&DRIVER_IRQ);
	eval 'sub drm_alloc {
	    my($size, $area) = @_;
    	    eval q( &_drm_alloc($size));
	}' unless defined(&drm_alloc);
	eval 'sub drm_calloc {
	    my($nmemb, $size, $area) = @_;
    	    eval q( &_drm_calloc($nmemb, $size));
	}' unless defined(&drm_calloc);
	eval 'sub drm_realloc {
	    my($old, $oldsz, $size, $area) = @_;
    	    eval q( &_drm_realloc($old, $oldsz, $size));
	}' unless defined(&drm_realloc);
	eval 'sub drm_free {
	    my($ptr, $size, $area) = @_;
    	    eval q( &do {  &_drm_free($ptr); ( &void)($size); }  &while( 0));
	}' unless defined(&drm_free);
	eval 'sub drm_core_reclaim_buffers () { &drm_reclaim_buffers;}' unless defined(&drm_core_reclaim_buffers);
	eval 'sub drm_core_ioremap_wc () { &drm_core_ioremap;}' unless defined(&drm_core_ioremap_wc);
    }
}
1;
