/* valaccodefunction.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __CCODE_VALACCODEFUNCTION_H__
#define __CCODE_VALACCODEFUNCTION_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodewriter.h>
#include <ccode/valaccodeblock.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_FUNCTION (vala_ccode_function_get_type ())
#define VALA_CCODE_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_FUNCTION, ValaCCodeFunction))
#define VALA_CCODE_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_FUNCTION, ValaCCodeFunctionClass))
#define VALA_IS_CCODE_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_FUNCTION))
#define VALA_IS_CCODE_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_FUNCTION))
#define VALA_CCODE_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_FUNCTION, ValaCCodeFunctionClass))

typedef struct _ValaCCodeFunction ValaCCodeFunction;
typedef struct _ValaCCodeFunctionClass ValaCCodeFunctionClass;
typedef struct _ValaCCodeFunctionPrivate ValaCCodeFunctionPrivate;

/**
 * Represents a function declaration in the C code.
 */
struct _ValaCCodeFunction {
	ValaCCodeNode parent_instance;
	ValaCCodeFunctionPrivate * priv;
};

struct _ValaCCodeFunctionClass {
	ValaCCodeNodeClass parent_class;
};


ValaCCodeFunction* vala_ccode_function_new (const char* name, const char* return_type);
void vala_ccode_function_add_parameter (ValaCCodeFunction* self, ValaCCodeFormalParameter* param);
ValaCCodeFunction* vala_ccode_function_copy (ValaCCodeFunction* self);
const char* vala_ccode_function_get_name (ValaCCodeFunction* self);
void vala_ccode_function_set_name (ValaCCodeFunction* self, const char* value);
ValaCCodeModifiers vala_ccode_function_get_modifiers (ValaCCodeFunction* self);
void vala_ccode_function_set_modifiers (ValaCCodeFunction* self, ValaCCodeModifiers value);
const char* vala_ccode_function_get_return_type (ValaCCodeFunction* self);
void vala_ccode_function_set_return_type (ValaCCodeFunction* self, const char* value);
ValaCCodeBlock* vala_ccode_function_get_block (ValaCCodeFunction* self);
void vala_ccode_function_set_block (ValaCCodeFunction* self, ValaCCodeBlock* value);
GType vala_ccode_function_get_type (void);


G_END_DECLS

#endif
