/*
 *  Copyright (C) 2005  Andreas Volz
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *  
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *  
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 *  File: BodySettings.h
 *  Andreas Volz <linux@brachttal.net>
 *   
 */

#ifndef BODYSETTINGS_H
#define BODYSETTINGS_H 1

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

#include <iostream>
#include <fstream>
#include <map>
#include "FileReader.h"
#include "FileWriter.h"

namespace Animorph {

/*!
The format of BodySettings file:
\verbatim
<string>,<float>
...
\endverbatim
*/
class BodySettings : public std::map <std::string, float>
{
private:
  void createStream (std::ostringstream &out_stream);
  void fromStream (std::ifstream &in_stream);

public:
  /// load a BodySetting
  /*!
   * \param filename the file with BodySettings data to load
   * \return true if file is found
   * \return false if file isn't found
   */
  bool load (const std::string& filename);

  /// save a BodySetting
  /*!
   * \param filename the file to save
   * \return true if file is saved
   * \return false if file couldn't be saved
   */
  bool save (const std::string& filename);
};

}

#endif	// BODYSETTINGS_H
