/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class XMLFormatter
extends Formatter {
    private static final String lineSep = SimpleFormatter.lineSep;
    private final SimpleDateFormat iso8601;

    private static final void appendTag(StringBuffer stringBuffer, int n, String string, String string2) {
        if (string2 == null) {
            return;
        }
        int n2 = 0;
        while (n2 < n * 2) {
            stringBuffer.append(' ');
            ++n2;
        }
        stringBuffer.append("<");
        stringBuffer.append(string);
        stringBuffer.append('>');
        n2 = 0;
        while (n2 < string2.length()) {
            char c = string2.charAt(n2);
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                default: {
                    if (c >= ' ' && c <= '~' || c == '\n' || c == '\r') {
                        stringBuffer.append(c);
                        break;
                    }
                    stringBuffer.append("&#");
                    stringBuffer.append((int)c);
                    stringBuffer.append(';');
                }
            }
            ++n2;
        }
        stringBuffer.append("</");
        stringBuffer.append(string);
        stringBuffer.append(">");
        stringBuffer.append(lineSep);
    }

    private static final void appendTag(StringBuffer stringBuffer, int n, String string, long l) {
        XMLFormatter.appendTag(stringBuffer, n, string, Long.toString(l));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String format(LogRecord logRecord) {
        String string;
        StringBuffer stringBuffer = new StringBuffer(400);
        Level level = logRecord.getLevel();
        long l = logRecord.getMillis();
        Object[] objectArray = logRecord.getParameters();
        ResourceBundle resourceBundle = logRecord.getResourceBundle();
        stringBuffer.append("<record>");
        stringBuffer.append(lineSep);
        XMLFormatter.appendTag(stringBuffer, 1, "date", this.iso8601.format(new Date(l)));
        XMLFormatter.appendTag(stringBuffer, 1, "millis", l);
        XMLFormatter.appendTag(stringBuffer, 1, "sequence", logRecord.getSequenceNumber());
        XMLFormatter.appendTag(stringBuffer, 1, "logger", logRecord.getLoggerName());
        if (level.isStandardLevel()) {
            XMLFormatter.appendTag(stringBuffer, 1, "level", level.toString());
        } else {
            XMLFormatter.appendTag(stringBuffer, 1, "level", level.intValue());
        }
        XMLFormatter.appendTag(stringBuffer, 1, "class", logRecord.getSourceClassName());
        XMLFormatter.appendTag(stringBuffer, 1, "method", logRecord.getSourceMethodName());
        XMLFormatter.appendTag(stringBuffer, 1, "thread", logRecord.getThreadID());
        try {
            logRecord.setResourceBundle(null);
            string = this.formatMessage(logRecord);
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            logRecord.setResourceBundle(resourceBundle);
            throw throwable;
        }
        {
            Object var10_10 = null;
            logRecord.setResourceBundle(resourceBundle);
        }
        XMLFormatter.appendTag(stringBuffer, 1, "message", string);
        Throwable throwable = logRecord.getThrown();
        if (throwable != null) {
            stringBuffer.append("  <exception>");
            stringBuffer.append(lineSep);
            XMLFormatter.appendTag(stringBuffer, 2, "message", throwable.toString());
            stringBuffer.append("  </exception>");
            stringBuffer.append(lineSep);
        }
        stringBuffer.append("</record>");
        stringBuffer.append(lineSep);
        return stringBuffer.toString();
    }

    public String getHead(Handler handler) {
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"");
        String string = handler.getEncoding();
        if (string == null) {
            string = System.getProperty("file.encoding");
        }
        if (string == null) {
            string = "UTF-8";
        }
        if (string.length() > 2 && string.startsWith("Cp")) {
            string = "windows-" + string.substring(2);
        }
        stringBuffer.append(string);
        stringBuffer.append("\" standalone=\"no\"?>");
        stringBuffer.append(lineSep);
        stringBuffer.append("<!DOCTYPE log SYSTEM \"logger.dtd\">");
        stringBuffer.append(lineSep);
        stringBuffer.append("<log>");
        stringBuffer.append(lineSep);
        return stringBuffer.toString();
    }

    public String getTail(Handler handler) {
        return "</log>" + lineSep;
    }

    private final /* synthetic */ void this() {
        this.iso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    }

    public XMLFormatter() {
        this.this();
    }
}

