/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.Serializable;
import java.util.ResourceBundle;

public class Level
implements Serializable {
    public static final Level OFF = new Level("OFF", Integer.MAX_VALUE);
    public static final Level SEVERE = new Level("SEVERE", 1000);
    public static final Level WARNING = new Level("WARNING", 900);
    public static final Level INFO = new Level("INFO", 800);
    public static final Level CONFIG = new Level("CONFIG", 700);
    public static final Level FINE = new Level("FINE", 500);
    public static final Level FINER = new Level("FINER", 400);
    public static final Level FINEST = new Level("FINEST", 300);
    public static final Level ALL = new Level("ALL", Integer.MIN_VALUE);
    private static final Level[] knownLevels = new Level[]{ALL, FINEST, FINER, FINE, CONFIG, INFO, WARNING, SEVERE, OFF};
    static final long serialVersionUID = -8176160795706313070L;
    private String name;
    private int value;
    private String resourceBundleName;

    private final Object readResolve() {
        int n = 0;
        while (n < knownLevels.length) {
            if (this.value == knownLevels[n].intValue()) {
                return knownLevels[n];
            }
            ++n;
        }
        return this;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public String getName() {
        return this.name;
    }

    public String getLocalizedName() {
        String string = null;
        if (this.resourceBundleName != null) {
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(this.resourceBundleName);
                string = resourceBundle.getString(this.name);
            }
            catch (Exception exception) {}
        }
        if (string != null) {
            return string;
        }
        return this.name;
    }

    public final String toString() {
        return this.getName();
    }

    public final int intValue() {
        return this.value;
    }

    public static Level parse(String string) throws IllegalArgumentException {
        string = string.intern();
        int n = 0;
        while (n < knownLevels.length) {
            if (string == Level.knownLevels[n].name) {
                return knownLevels[n];
            }
            ++n;
        }
        try {
            n = Integer.parseInt(string);
            int n2 = 0;
            while (n2 < knownLevels.length) {
                if (n == Level.knownLevels[n2].value) {
                    return knownLevels[n2];
                }
                ++n2;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        String string2 = "Not the name of a standard logging level: \"" + string + '\"';
        throw new IllegalArgumentException(string2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Level)) {
            return false;
        }
        boolean bl = false;
        if (this.value == ((Level)object).value) {
            bl = true;
        }
        return bl;
    }

    public int hashCode() {
        return this.value;
    }

    final boolean isStandardLevel() {
        int n = 0;
        while (n < knownLevels.length) {
            if (knownLevels[n] == this) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected Level(String string, int n) {
        this(string, n, null);
    }

    protected Level(String string, int n, String string2) {
        this.name = string;
        this.value = n;
        this.resourceBundleName = string2;
    }
}

