% -*-LaTeX-*-
% Copyright 2003-2006 Han The Thanh <hanthethanh@gmx.net>.
% This file is part of vntex.  License: LPPL, version 1.3 or newer,
% according to http://www.latex-project.org/lppl.txt

\ifx\documentclass\undefined\endinput\fi

\newif\ifbookmarks

\ProvidesClass{vnsample}[2005/08/27]
\NeedsTeXFormat{LaTeX2e}

\LoadClass[a4paper]{article}

\RequirePackage{ifpdf}

\ifpdf\IfFileExists{cmap.sty}{\RequirePackage{cmap}}{
\ClassWarningNoLine{vnsample}{I can't find the file `cmap.sty'.\MessageBreak
The search tool in your PDF browser will miss many\MessageBreak
words containing Vietnamese characters}}\fi

\RequirePackage[viscii]{vietnam}
\RequirePackage{multicol}
\RequirePackage{geometry}
\RequirePackage{array}
\RequirePackage{fancyhdr}

\DeclareOption{sample}{
  \geometry{a4paper,nofoot,left=1cm,right=1cm,top=2cm,bottom=1cm}
  \pagestyle{fancy}
  \rhead{\thepage}
  \lhead{\textrm{\rightmark}}\cfoot{}\lfoot{}\rfoot{}
  \raggedright
  \parindent0pt
  \lineskiplimit -100pt
  \bookmarkstrue
}

\DeclareOption{test}{
  \geometry{a4paper,landscape,top=1cm,bottom=1cm,left=1cm,right=1cm,%
    nofoot,nohead}
  \pagestyle{empty}
  \bookmarksfalse
  \advance\oddsidemargin -7mm \evensidemargin=\oddsidemargin
  \hbadness=10000\relax\hfuzz=\maxdimen
  \AtBeginDocument{\extrarowheight=5pt}
}

\ProcessOptions

\newdimen\dimenA
\newbox\boxA
\newbox\boxB

\def\vnchars{%
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
% \break
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\dochar 
\par
}

\def\dochar #1 {%
    #1\kern.1em\penalty0%
}

\def\SL{-Slant}
\def\EMPH#1{\textbf{\textit{#1}}}

\long\def\vntext{%
\centerline{\textbf{Ch Pho}}
\vskip -.5\baselineskip
\rightline{\textsc{--- Nam Cao}}
Hn va i va chi. Bao gi cng th, c ru xong l hn chi. Bt u
chi tri. C h g? Tri c ca ring nh no? Ri hn chi i. Th
cng chng sao: i l tt c nhng chng l ai. Tc mnh hn chi ngay tt
c lng V i. Nhng c lng V i ai cng nh, \textit{``Chc n tr
mnh ra!''} Khng ai ln ting c. Tc tht! ! Th ny th tc tht! Tc
cht i c mt!  th, hn phi chi cha a no khng chi nhau vi
hn. Nhng cng khng ai ra iu. M kip! Th th c ph ru khng? Th
th c kh hn khng? Khng bit a cht m no  ra thn hn cho hn kh
n nng ni ny? A ha! Phi y, hn c th m chi, hn chi a cht m
no  ra thn hn,  ra ci thng \EMPH{Ch Pho}! Hn nghin rng vo
m chi ci a   ra Ch Pho. Nhng m bit a no   ra
Ch Pho? C tri m bit! Hn khng bit, c lng V i cng khng ai
bit.

Mt anh i th ng l߽n, mt bui sng tinh s߽ng  thy hn
trn trung v xm ngt trong mt vy p  bn mt l gch b
khng, anh ta r߾c ly v em v cho mt ng߶i n b ga m.
Ng߶i n b ga m ny bn hn cho mt bc ph ci khng con, v
khi bc ph ci ny cht th hn b v, ht i  cho nh ny li i
 cho nh n. Nm hai m߽i tui, hn lm canh in cho ng l Kin,
by gi c b Kin, n tin ch lng. Hnh nh c my ln b ba nh
ng l, cn tr lm m li hay m lng, bt hn bp chn, hay xoa
bng, m lng g y. Ng߶i ta bo ng l ra nh th hch dch,
c lng phi s, m v nh th li s ci b ba cn tr ny. Ng߶i
b y php php, m b y hy hy, m ng l th hay au lng lm;
nhng ng߶i c bnh au lng hay s v m cha i l kho ghen.
C ng߶i bo ng l ghen vi anh canh in kho mnh m s b ba
khng dm ni. C ng߶i th bo anh canh in y c b ba quyn
thu quyn b trong nh tin cn nn ly trm tin trm thc nhiu.
Mi ng߶i ni mt cch. Chng bit u m ln. Ch bit mt hm
Ch b ng߶i ta gii huyn ri bit tm n by, tm nm ri mt
hm, hn li l l  u ln v. Hn v lp ny trng khc
hn, mi u chng ai bit hn l ai. Trng c nh thng sng
c! Ci u th trc lc, ci rng co trng hn, ci mt th en
m rt cng cng, hai mt g߶m g߶m trng gm cht! Hn mc qun
o ni en vi o Ty vng. Ci ngc phanh, y nhng nt chm tr
rng, phng vi mt ng thy t߾ng cm chu, c hai cnh tay cng
th. Trng gm cht!
}

\def\mksample#1{%
    \leftline{\normalsize\bf\fbox{line spacing #1}\hrulefill}
    \vskip 5pt
    \ifnum\pdftexversion<130\relax
      \dimenA=\pdffontsize\font pt\relax
    \else
      \dimenA=\pdffontsize\font
    \fi
    \setbox\boxA=\vbox{%
        \baselineskip=#1\dimenA
        \parskip=.5\baselineskip
        \noindent\vntext\par}%
    \setbox\boxB=\vsplit\boxA to 3in
    \nobreak
    \box\boxB
    \vskip 10pt
}

\def\showfontsize#1#2#3{{%
    \leftline{\large\bf\fbox{#2}\hrulefill}
    \nobreak
    \font\f=#1 at #2\f
    \baselineskip=#3
    \noindent
    \vnchars\par
    \vskip .5\baselineskip
}}

\def\mkfontname#1#2#3{\hbox{%
    \hbox to .25\textwidth{NFSS:\kern1em \texttt{#1}\hss}%
    \hbox to .25\textwidth{TFM:\kern1em \texttt{#2}\hss}%
    PostScript:\kern1em \texttt{#3}}}


\def\getdesignsize#1{\def\designsize{}%
  \expandafter\@tfor\expandafter\x\expandafter:\expandafter=#1
  \do{\ifcat\x0\edef\designsize{\designsize\x}\fi%
    \if\x-\def\designsize{}\fi}}


\def\showletters#1#2#3#4#5#6{\getdesignsize{#5}%
    \ifx\HasDesignsize\undefined
      \subsection{#2-#3-#4}{#5}%
    \else
      \subsection{#2-#3-#4 (\designsize pt)}{#5}%
    \fi
    \markright{\mkfontname{#1/#2/#3/#4}{#5}{#6}}
    \showfontsize{#5}{18pt}{27pt}
    \showfontsize{#5}{36pt}{54pt}
    \showfontsize{#5}{72pt}{108pt}
    \clearpage
}

\def\showCMfont#1#2#3#4#5#6{
    \showletters{#1}{#2}{#3}{#4}{#5}{#6}
    \clearpage
    \markright{#5}
    \subsection{Text}{#5-text}%
    \showtextsize{%
        \font\f=#5\f 
        \let\EMPH=\relax 
        \let\textit=\relax
        \let\textsc=\relax}
}

\def\showtextsize#1{
    \columnsep=20pt
    \columnseprule=.4pt
    \begin{multicols}{2}
    #1
    \mksample{1}
    \mksample{1.2}
    \mksample{1.4}
    \mksample{1.1}
    \mksample{1.3}
    \mksample{1.5}
    \end{multicols}
    \clearpage
}

\def\showtext#1#2#3#4#5#6{\subsection{Text}{#5-text}%
    \markright{#6 at 8pt}\showtextsize{\fontsize{8pt}{8pt}\usefont{#1}{#2}{#3}{#4}}
    \markright{#6 at 10pt}\showtextsize{\fontsize{10pt}{10pt}\usefont{#1}{#2}{#3}{#4}}
    \markright{#6 at 12pt}\showtextsize{\fontsize{12pt}{12pt}\usefont{#1}{#2}{#3}{#4}}
    \clearpage
}

\def\samplesentence{%
     Hn nghin rng vo m chi ci a   ra Ch Pho lng V i}

\newenvironment{shortsample}
    {\normalfont\fontencoding{OT1}\ttfamily \selectfont
     \begin{tabular*}{\textwidth}{llll<{\samplesentence}}
     NFSS&TFM&PostScript&\multicolumn{1}{l}{Sample}\\ \hline
    }
    {\end{tabular*}}

\def\shorttext#1#2#3#4#5#6{%
    #1/#2/#3/#4 & #5 & #6 & \normalsize\usefont{#1}{#2}{#3}{#4}\\}

%%%\endinput

\ifbookmarks\RequirePackage{hyperref}
  \def\section#1{\gdef\currsec{#1}\hypertarget{#1}{}\pdfbookmark[0]{#1}{#1}}
%\subsection{<Text>}{<label>}
  \def\subsection#1#2{\def\target{\currsec-#2}%
    \hypertarget{\target}{}\pdfbookmark[1]{#1}{\target}}
\fi


\def\mapfile#1{\ifpdf\IfFileExists{./useinternalmap}{\pdfmapfile{=#1.map}}{}\fi}
\IfFileExists{./nocompress}{\pdfcompresslevel0 }{\pdfcompresslevel9 }

% Local Variables:
% coding: viscii
% End:
