/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Hashtable;
import org.mozilla.javascript.Invoker;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ClassCache {
    private static final Object AKEY = new Object();
    private volatile boolean cachingIsEnabled = true;
    Hashtable classTable = new Hashtable();
    boolean invokerOptimization = true;
    Invoker invokerMaster;
    Hashtable javaAdapterGeneratedClasses = new Hashtable();
    Hashtable javaAdapterIFGlueMasters = new Hashtable();
    private int generatedClassSerial;

    public static ClassCache get(Scriptable scriptable) {
        Scriptable scriptable2 = scriptable = ScriptableObject.getTopLevelScope(scriptable);
        do {
            ScriptableObject scriptableObject;
            ClassCache classCache;
            if (!(scriptable2 instanceof ScriptableObject) || (classCache = (ClassCache)(scriptableObject = (ScriptableObject)scriptable2).getAssociatedValue(AKEY)) == null) continue;
            return classCache;
        } while ((scriptable2 = scriptable2.getPrototype()) != null);
        return new ClassCache();
    }

    public boolean associate(ScriptableObject scriptableObject) {
        if (scriptableObject.getParentScope() != null) {
            throw new IllegalArgumentException();
        }
        return this != scriptableObject.associateValue(AKEY, this);
    }

    public synchronized void clearCaches() {
        this.classTable = new Hashtable();
        this.javaAdapterGeneratedClasses = new Hashtable();
        this.javaAdapterIFGlueMasters = new Hashtable();
        Invoker invoker = this.invokerMaster;
        if (invoker != null) {
            invoker.clearMasterCaches();
        }
    }

    public final boolean isCachingEnabled() {
        return this.cachingIsEnabled;
    }

    public synchronized void setCachingEnabled(boolean bl) {
        if (bl == this.cachingIsEnabled) {
            return;
        }
        if (!bl) {
            this.clearCaches();
        }
        this.cachingIsEnabled = bl;
    }

    public synchronized void setInvokerOptimizationEnabled(boolean bl) {
        if (this.invokerOptimization == bl) {
            return;
        }
        if (!bl) {
            this.invokerMaster = null;
        }
        this.invokerOptimization = bl;
    }

    public final synchronized int newClassSerialNumber() {
        return ++this.generatedClassSerial;
    }
}

