/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dir {
    public static final boolean DOSISH;
    public static final boolean CASEFOLD_FILESYSTEM;
    public static final int FNM_NOESCAPE = 1;
    public static final int FNM_PATHNAME = 2;
    public static final int FNM_DOTMATCH = 4;
    public static final int FNM_CASEFOLD = 8;
    public static final int FNM_SYSCASE;
    public static final int FNM_NOMATCH = 1;
    public static final int FNM_ERROR = 2;
    public static final byte[] EMPTY;
    public static final byte[] SLASH;
    public static final byte[] STAR;
    public static final byte[] DOUBLE_STAR;
    public static final GlobFunc push_pattern;
    public static final GlobFunc glob_caller;

    private static boolean isdirsep(byte c) {
        return DOSISH ? c == 92 || c == 47 : c == 47;
    }

    private static int rb_path_next(byte[] _s, int s, int send) {
        while (s < send && !Dir.isdirsep(_s[s])) {
            ++s;
        }
        return s;
    }

    private static int fnmatch_helper(byte[] bytes, int pstart, int pend, byte[] string, int sstart, int send, int flags) {
        boolean nocase;
        int s = sstart;
        int pat = pstart;
        boolean escape = (flags & 1) == 0;
        boolean pathname = (flags & 2) != 0;
        boolean period = (flags & 4) == 0;
        boolean bl = nocase = (flags & 8) != 0;
        block6: while (pat < pend) {
            char c = bytes[pat++];
            switch (c) {
                case '?': {
                    if (s >= send || pathname && Dir.isdirsep(string[s]) || period && string[s] == 46 && (s == 0 || pathname && Dir.isdirsep(string[s - 1]))) {
                        return 1;
                    }
                    ++s;
                    continue block6;
                }
                case '*': {
                    while (pat < pend && (c = bytes[pat++]) == '*') {
                    }
                    if (s < send && period && string[s] == 46 && (s == 0 || pathname && Dir.isdirsep(string[s - 1]))) {
                        return 1;
                    }
                    if (pat > pend || pat == pend && c == '*') {
                        if (pathname && Dir.rb_path_next(string, s, send) < send) {
                            return 1;
                        }
                        return 0;
                    }
                    if (pathname && Dir.isdirsep((byte)c)) {
                        if ((s = Dir.rb_path_next(string, s, send)) < send) {
                            ++s;
                            continue block6;
                        }
                        return 1;
                    }
                    char test = (char)((escape && c == '\\' && pat < pend ? bytes[pat] : c) & 0xFF);
                    test = Character.toLowerCase(test);
                    --pat;
                    while (s < send) {
                        if ((c == '?' || c == '[' || Character.toLowerCase((char)string[s]) == test) && Dir.fnmatch(bytes, pat, pend, string, s, send, flags | 4) == 0) {
                            return 0;
                        }
                        if (pathname && Dir.isdirsep(string[s])) break;
                        ++s;
                    }
                    return 1;
                }
                case '[': {
                    if (s >= send || pathname && Dir.isdirsep(string[s]) || period && string[s] == 46 && (s == 0 || pathname && Dir.isdirsep(string[s - 1]))) {
                        return 1;
                    }
                    if ((pat = Dir.range(bytes, pat, pend, (char)(string[s] & 0xFF), flags)) == -1) {
                        return 1;
                    }
                    ++s;
                    continue block6;
                }
                case '\\': {
                    if (!escape || DOSISH && (pat >= pend || "*?[]\\".indexOf((char)bytes[pat]) == -1)) break;
                    c = pat >= pend ? (char)'\\' : bytes[pat++];
                }
            }
            if (s >= send) {
                return 1;
            }
            if (!(DOSISH && pathname && Dir.isdirsep((byte)c) && Dir.isdirsep(string[s]) || !(nocase ? Character.toLowerCase(c) != Character.toLowerCase((char)string[s]) : c != (char)string[s]))) {
                return 1;
            }
            ++s;
        }
        return s >= send ? 0 : 1;
    }

    public static int fnmatch(byte[] bytes, int pstart, int pend, byte[] string, int sstart, int send, int flags) {
        boolean period = (flags & 4) == 0;
        boolean pathname = (flags & 2) != 0;
        int pat_pos = pstart;
        int str_pos = sstart;
        int ptmp = -1;
        int stmp = -1;
        if (pathname) {
            while (true) {
                int strSlashIdx;
                int patSlashIdx;
                if (Dir.isDoubleStarAndSlash(bytes, pat_pos)) {
                    while (Dir.isDoubleStarAndSlash(bytes, pat_pos += 3)) {
                    }
                    ptmp = pat_pos;
                    stmp = str_pos;
                }
                if (Dir.fnmatch_helper(bytes, pat_pos, patSlashIdx = Dir.nextSlashIndex(bytes, pat_pos, pend), string, str_pos, strSlashIdx = Dir.nextSlashIndex(string, str_pos, send), flags) == 0) {
                    if (patSlashIdx < pend && strSlashIdx < send) {
                        pat_pos = ++patSlashIdx;
                        str_pos = ++strSlashIdx;
                        continue;
                    }
                    if (patSlashIdx == pend && strSlashIdx == send) {
                        return 0;
                    }
                }
                if (ptmp == -1 || stmp == -1 || period && string[stmp] == 46 || (stmp = Dir.nextSlashIndex(string, stmp, send)) >= send) break;
                pat_pos = ptmp;
                str_pos = ++stmp;
            }
            return 1;
        }
        return Dir.fnmatch_helper(bytes, pstart, pend, string, sstart, send, flags);
    }

    private static boolean isDoubleStarAndSlash(byte[] bytes, int pos) {
        if (bytes.length - pos <= 2) {
            return false;
        }
        return bytes[pos] == 42 && bytes[pos + 1] == 42 && bytes[pos + 2] == 47;
    }

    private static int nextSlashIndex(byte[] bytes, int start, int end) {
        int idx;
        for (idx = start; idx < end && idx < bytes.length && bytes[idx] != 47; ++idx) {
        }
        return idx;
    }

    public static int range(byte[] _pat, int pat, int pend, char test, int flags) {
        boolean not;
        boolean ok = false;
        boolean nocase = (flags & 8) != 0;
        boolean escape = (flags & 1) == 0;
        boolean bl = not = _pat[pat] == 33 || _pat[pat] == 94;
        if (not) {
            ++pat;
        }
        if (nocase) {
            test = Character.toLowerCase(test);
        }
        while (_pat[pat] != 93) {
            char cend;
            if (escape && _pat[pat] == 92) {
                ++pat;
            }
            if (pat >= pend) {
                return -1;
            }
            char cstart = cend = (char)(_pat[pat++] & 0xFF);
            if (_pat[pat] == 45 && _pat[pat + 1] != 93) {
                if (escape && _pat[++pat] == 92) {
                    ++pat;
                }
                if (pat >= pend) {
                    return -1;
                }
                cend = (char)(_pat[pat++] & 0xFF);
            }
            if (nocase) {
                if (Character.toLowerCase(cstart) > test || test > Character.toLowerCase(cend)) continue;
                ok = true;
                continue;
            }
            if (cstart > test || test > cend) continue;
            ok = true;
        }
        return ok == not ? -1 : pat + 1;
    }

    public static List<ByteList> push_glob(String cwd, ByteList globByteList, int flags) {
        ArrayList<ByteList> result = new ArrayList<ByteList>();
        if (globByteList.length() > 0) {
            Dir.push_braces(cwd, result, new GlobPattern(globByteList, flags));
        }
        return result;
    }

    private static int push_braces(String cwd, List<ByteList> result, GlobPattern pattern) {
        pattern.reset();
        int lbrace = pattern.indexOf((byte)123);
        int rbrace = pattern.findClosingIndexOf(lbrace);
        if (lbrace == -1 || rbrace == -1) {
            return Dir.push_globs(cwd, result, pattern);
        }
        ByteList buf = new ByteList(20);
        int i = lbrace;
        while (pattern.bytes[i] != 125) {
            int middleRegionIndex;
            for (i = middleRegionIndex = i + 1; i < pattern.end && pattern.bytes[i] != 125 && pattern.bytes[i] != 44; ++i) {
                if (pattern.bytes[i] != 123) continue;
                pattern.findClosingIndexOf(i);
            }
            buf.length(0);
            buf.append(pattern.bytes, pattern.begin, lbrace - pattern.begin);
            buf.append(pattern.bytes, middleRegionIndex, i - middleRegionIndex);
            buf.append(pattern.bytes, rbrace + 1, pattern.end - (rbrace + 1));
            int status = Dir.push_braces(cwd, result, new GlobPattern(buf.bytes, buf.begin, buf.realSize, pattern.flags));
            if (status == 0) continue;
            return status;
        }
        return 0;
    }

    private static int push_globs(String cwd, List<ByteList> ary, GlobPattern pattern) {
        pattern.flags |= FNM_SYSCASE;
        return Dir.glob_helper(cwd, pattern.bytes, pattern.begin, pattern.end, -1, pattern.flags, glob_caller, new GlobArgs(push_pattern, ary));
    }

    private static boolean has_magic(byte[] bytes, int begin, int end, int flags) {
        boolean escape = (flags & 1) == 0;
        boolean nocase = (flags & 8) != 0;
        int open = 0;
        block6: for (int i = begin; i < end; ++i) {
            switch (bytes[i]) {
                case 42: 
                case 63: {
                    return true;
                }
                case 91: {
                    ++open;
                    continue block6;
                }
                case 93: {
                    if (open <= 0) continue block6;
                    return true;
                }
                case 92: {
                    if (!escape || i != end) continue block6;
                    return false;
                }
                default: {
                    if (FNM_SYSCASE != 0 || !nocase || !Character.isLetter((char)(bytes[i] & 0xFF))) continue block6;
                    return true;
                }
            }
        }
        return false;
    }

    private static int remove_backslashes(byte[] bytes, int index, int len) {
        int t = index;
        while (index < len && (bytes[index] != 92 || ++index != len)) {
            bytes[t] = bytes[index];
            ++index;
            ++t;
        }
        return t;
    }

    private static int strchr(byte[] bytes, int begin, int end, byte ch) {
        for (int i = begin; i < end; ++i) {
            if (bytes[i] != ch) continue;
            return i;
        }
        return -1;
    }

    private static byte[] extract_path(byte[] bytes, int begin, int end) {
        int len = end - begin;
        if (!(len <= 1 || bytes[end - 1] != 47 || DOSISH && len >= 2 && bytes[end - 2] == 58)) {
            --len;
        }
        byte[] alloc = new byte[len];
        System.arraycopy(bytes, begin, alloc, 0, len);
        return alloc;
    }

    private static byte[] extract_elem(byte[] bytes, int begin, int end) {
        int elementEnd = Dir.strchr(bytes, begin, end, (byte)47);
        if (elementEnd == -1) {
            elementEnd = end;
        }
        return Dir.extract_path(bytes, begin, elementEnd);
    }

    private static boolean BASE(byte[] base) {
        return DOSISH ? !(base.length <= 0 || Dir.isdirsep(base[0]) && base.length < 2 || base.length > 2 && base[1] == 58 && Dir.isdirsep(base[2]) && base.length < 4) : base.length > 0 && (!Dir.isdirsep(base[0]) || base.length >= 2);
    }

    private static boolean isJarFilePath(byte[] bytes, int begin, int end) {
        return end > 6 && bytes[begin] == 102 && bytes[begin + 1] == 105 && bytes[begin + 2] == 108 && bytes[begin + 3] == 101 && bytes[begin + 4] == 58;
    }

    private static String[] files(File directory) {
        String[] files = directory.list();
        String[] filesPlusDotFiles = new String[files.length + 2];
        System.arraycopy(files, 0, filesPlusDotFiles, 2, files.length);
        filesPlusDotFiles[0] = ".";
        filesPlusDotFiles[1] = "..";
        return filesPlusDotFiles;
    }

    private static int glob_helper(String cwd, byte[] bytes, int begin, int end, int sub, int flags, GlobFunc func, GlobArgs arg) {
        int p;
        int status = 0;
        byte[] newpath = null;
        int n = p = sub != -1 ? sub : begin;
        if (!Dir.has_magic(bytes, p, end, flags)) {
            if (DOSISH || (flags & 1) == 0) {
                newpath = new byte[end];
                System.arraycopy(bytes, 0, newpath, 0, end);
                if (sub != -1) {
                    p = sub - begin;
                    end = Dir.remove_backslashes(newpath, p, end);
                    sub = p;
                } else {
                    end = Dir.remove_backslashes(newpath, 0, end);
                    bytes = newpath;
                }
            }
            if (bytes[begin] == 47 || DOSISH && begin + 2 < end && bytes[begin + 1] == 58 && Dir.isdirsep(bytes[begin + 2])) {
                if (new File(Dir.newStringFromUTF8(bytes, begin, end - begin)).exists()) {
                    status = func.call(bytes, begin, end, arg);
                }
            } else if (Dir.isJarFilePath(bytes, begin, end)) {
                int ix = -1;
                for (int i = 0; i < end; ++i) {
                    if (bytes[begin + i] != 33) continue;
                    ix = i;
                    break;
                }
                File st = new File(Dir.newStringFromUTF8(bytes, begin + 5, ix - 5));
                String jar = Dir.newStringFromUTF8(bytes, begin + ix + 1, end - (ix + 1));
                try {
                    JarFile jf = new JarFile(st);
                    if (jar.startsWith("/")) {
                        jar = jar.substring(1);
                    }
                    if (jf.getEntry(jar + "/") != null) {
                        jar = jar + "/";
                    }
                    if (jf.getEntry(jar) != null) {
                        status = func.call(bytes, begin, end, arg);
                    }
                }
                catch (Exception e) {}
            } else if (end - begin > 0 && new File(cwd, Dir.newStringFromUTF8(bytes, begin, end - begin)).exists()) {
                status = func.call(bytes, begin, end - begin, arg);
            }
            return status;
        }
        ByteList buf = new ByteList(20);
        ArrayList<ByteList> link = new ArrayList<ByteList>();
        while (p != -1 && status == 0) {
            int m;
            block48: {
                File st;
                block47: {
                    JarFile jf;
                    String jar;
                    boolean recursive;
                    byte[] magic;
                    byte[] base;
                    block49: {
                        byte[] byArray;
                        if (bytes[p] == 47) {
                            ++p;
                        }
                        if (!Dir.has_magic(bytes, p, (m = Dir.strchr(bytes, p, end, (byte)47)) == -1 ? end : m, flags)) break block48;
                        base = Dir.extract_path(bytes, begin, p);
                        if (begin == p) {
                            byte[] byArray2 = new byte[1];
                            byArray = byArray2;
                            byArray2[0] = 46;
                        } else {
                            byArray = base;
                        }
                        byte[] dir = byArray;
                        magic = Dir.extract_elem(bytes, p, end);
                        recursive = false;
                        jar = null;
                        jf = null;
                        if (dir[0] == 47 || DOSISH && 2 < dir.length && dir[1] == 58 && Dir.isdirsep(dir[2])) {
                            st = new File(Dir.newStringFromUTF8(dir));
                        } else if (Dir.isJarFilePath(dir, 0, dir.length)) {
                            int ix = -1;
                            for (int i = 0; i < dir.length; ++i) {
                                if (dir[i] != 33) continue;
                                ix = i;
                                break;
                            }
                            st = new File(Dir.newStringFromUTF8(dir, 5, ix - 5));
                            jar = Dir.newStringFromUTF8(dir, ix + 1, dir.length - (ix + 1));
                            try {
                                jf = new JarFile(st);
                                if (jar.startsWith("/")) {
                                    jar = jar.substring(1);
                                }
                                if (jf.getEntry(jar + "/") != null) {
                                    jar = jar + "/";
                                }
                            }
                            catch (Exception e) {
                                jar = null;
                                jf = null;
                            }
                        } else {
                            st = new File(cwd, Dir.newStringFromUTF8(dir));
                        }
                        if ((jf == null || !"".equals(jar) && (jf.getJarEntry(jar) == null || !jf.getJarEntry(jar).isDirectory())) && !st.isDirectory()) break;
                        if (m == -1 || !Arrays.equals(magic, DOUBLE_STAR)) break block49;
                        int n2 = base.length;
                        recursive = true;
                        buf.length(0);
                        buf.append(base);
                        buf.append(bytes, base.length > 0 ? m : m + 1, end - (base.length > 0 ? m : m + 1));
                        status = Dir.glob_helper(cwd, buf.bytes, buf.begin, buf.realSize, n2, flags, func, arg);
                        if (status != 0) break block47;
                    }
                    if (jar == null) {
                        String[] dirp = Dir.files(st);
                        for (int i = 0; i < dirp.length; ++i) {
                            byte[] bs;
                            if (recursive) {
                                bs = Dir.getBytesInUTF8(dirp[i]);
                                if (Dir.fnmatch(STAR, 0, 1, bs, 0, bs.length, flags) != 0) continue;
                                buf.length(0);
                                buf.append(base);
                                buf.append(Dir.BASE(base) ? SLASH : EMPTY);
                                buf.append(Dir.getBytesInUTF8(dirp[i]));
                                st = buf.bytes[0] == 47 || DOSISH && 2 < buf.realSize && buf.bytes[1] == 58 && Dir.isdirsep(buf.bytes[2]) ? new File(Dir.newStringFromUTF8(buf.bytes, buf.begin, buf.realSize)) : new File(cwd, Dir.newStringFromUTF8(buf.bytes, buf.begin, buf.realSize));
                                if (!st.isDirectory() || ".".equals(dirp[i]) || "..".equals(dirp[i])) continue;
                                int t = buf.realSize;
                                buf.append(SLASH);
                                buf.append(DOUBLE_STAR);
                                buf.append(bytes, m, end - m);
                                status = Dir.glob_helper(cwd, buf.bytes, buf.begin, buf.realSize, t, flags, func, arg);
                                if (status == 0) continue;
                                break;
                            }
                            bs = Dir.getBytesInUTF8(dirp[i]);
                            if (Dir.fnmatch(magic, 0, magic.length, bs, 0, bs.length, flags) != 0) continue;
                            buf.length(0);
                            buf.append(base);
                            buf.append(Dir.BASE(base) ? SLASH : EMPTY);
                            buf.append(Dir.getBytesInUTF8(dirp[i]));
                            if (m == -1) {
                                status = func.call(buf.bytes, 0, buf.realSize, arg);
                                if (status == 0) continue;
                                break;
                            }
                            link.add(buf);
                            buf = new ByteList(20);
                        }
                    } else {
                        try {
                            ArrayList<JarEntry> dirp = new ArrayList<JarEntry>();
                            Enumeration<JarEntry> eje = jf.entries();
                            while (eje.hasMoreElements()) {
                                JarEntry je = eje.nextElement();
                                String name = je.getName();
                                int ix = name.indexOf(47, jar.length());
                                if (name.startsWith("META-INF") || ix != -1 && ix != name.length() - 1 || !"/".equals(jar) && (!name.startsWith(jar) || name.length() <= jar.length())) continue;
                                dirp.add(je);
                            }
                            for (JarEntry je : dirp) {
                                byte[] bs = Dir.getBytesInUTF8(je.getName());
                                int len = bs.length;
                                if (je.isDirectory()) {
                                    --len;
                                }
                                if (recursive) {
                                    if (Dir.fnmatch(STAR, 0, 1, bs, 0, len, flags) != 0) continue;
                                    buf.length(0);
                                    buf.append(base, 0, base.length - jar.length());
                                    buf.append(Dir.BASE(base) ? SLASH : EMPTY);
                                    buf.append(bs, 0, len);
                                    if (!je.isDirectory()) continue;
                                    int t = buf.realSize;
                                    buf.append(SLASH);
                                    buf.append(DOUBLE_STAR);
                                    buf.append(bytes, m, end - m);
                                    status = Dir.glob_helper(cwd, buf.bytes, buf.begin, buf.realSize, t, flags, func, arg);
                                    if (status == 0) continue;
                                }
                                if (Dir.fnmatch(magic, 0, magic.length, bs, 0, len, flags) != 0) continue;
                                buf.length(0);
                                buf.append(base, 0, base.length - jar.length());
                                buf.append(Dir.BASE(base) ? SLASH : EMPTY);
                                buf.append(bs, 0, len);
                                if (m == -1) {
                                    status = func.call(buf.bytes, 0, buf.realSize, arg);
                                    if (status == 0) continue;
                                }
                                link.add(buf);
                                buf = new ByteList(20);
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                if (link.size() > 0) {
                    for (ByteList b : link) {
                        if (status != 0 || !(st = b.bytes[0] == 47 || DOSISH && 2 < b.realSize && b.bytes[1] == 58 && Dir.isdirsep(b.bytes[2]) ? new File(Dir.newStringFromUTF8(b.bytes, 0, b.realSize)) : new File(cwd, Dir.newStringFromUTF8(b.bytes, 0, b.realSize))).isDirectory()) continue;
                        int len = b.realSize;
                        buf.length(0);
                        buf.append(b);
                        buf.append(bytes, m, end - m);
                        status = Dir.glob_helper(cwd, buf.bytes, 0, buf.realSize, len, flags, func, arg);
                    }
                    break;
                }
            }
            p = m;
        }
        return status;
    }

    private static byte[] getBytesInUTF8(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return s.getBytes();
        }
    }

    private static String newStringFromUTF8(byte[] buf, int offset, int len) {
        try {
            return new String(buf, offset, len, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return new String(buf, offset, len);
        }
    }

    private static String newStringFromUTF8(byte[] buf) {
        try {
            return new String(buf, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return new String(buf);
        }
    }

    static {
        CASEFOLD_FILESYSTEM = DOSISH = System.getProperty("os.name").indexOf("Windows") != -1;
        FNM_SYSCASE = CASEFOLD_FILESYSTEM ? 8 : 0;
        EMPTY = new byte[0];
        SLASH = new byte[]{47};
        STAR = new byte[]{42};
        DOUBLE_STAR = new byte[]{42, 42};
        push_pattern = new GlobFunc(){

            public int call(byte[] ptr, int p, int len, Object ary) {
                ((List)ary).add(new ByteList(ptr, p, len));
                return 0;
            }
        };
        glob_caller = new GlobFunc(){

            public int call(byte[] ptr, int p, int len, Object ary) {
                GlobArgs args = (GlobArgs)ary;
                args.c = p;
                return args.func.call(ptr, args.c, len, args.v);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GlobArgs {
        GlobFunc func;
        int c = -1;
        List<ByteList> v;

        public GlobArgs(GlobFunc func, List<ByteList> arg) {
            this.func = func;
            this.v = arg;
        }
    }

    private static interface GlobFunc {
        public int call(byte[] var1, int var2, int var3, Object var4);
    }

    private static class GlobPattern {
        byte[] bytes;
        int index;
        int begin;
        int end;
        int flags;

        public GlobPattern(ByteList bytelist, int flags) {
            this(bytelist.bytes, bytelist.begin, bytelist.begin + bytelist.realSize, flags);
        }

        public GlobPattern(byte[] bytes, int index, int end, int flags) {
            this.bytes = bytes;
            this.index = index;
            this.begin = index;
            this.end = end;
            this.flags = flags;
        }

        public int findClosingIndexOf(int leftTokenIndex) {
            byte rightToken;
            if (leftTokenIndex == -1 || leftTokenIndex > this.end) {
                return -1;
            }
            byte leftToken = this.bytes[leftTokenIndex];
            switch (leftToken) {
                case 123: {
                    rightToken = 125;
                    break;
                }
                case 91: {
                    rightToken = 93;
                    break;
                }
                default: {
                    return -1;
                }
            }
            int nest = 1;
            this.index = leftTokenIndex + 1;
            while (this.hasNext()) {
                byte c = this.next();
                if (c == leftToken) {
                    ++nest;
                    continue;
                }
                if (c != rightToken || --nest != 0) continue;
                return this.index();
            }
            return -1;
        }

        public boolean hasNext() {
            return this.index < this.end;
        }

        public void reset() {
            this.index = this.begin;
        }

        public void setIndex(int value) {
            this.index = value;
        }

        public int index() {
            return this.index - 1;
        }

        public int indexOf(byte c) {
            while (this.hasNext()) {
                if (this.next() != c) continue;
                return this.index();
            }
            return -1;
        }

        public byte next() {
            return this.bytes[this.index++];
        }
    }
}

