/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import org.jruby.ast.AndNode;
import org.jruby.ast.ArgsCatNode;
import org.jruby.ast.ArgsPushNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.AttrAssignOneArgNode;
import org.jruby.ast.AttrAssignThreeArgNode;
import org.jruby.ast.AttrAssignTwoArgNode;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BeginNode;
import org.jruby.ast.BignumNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.BreakNode;
import org.jruby.ast.CallNoArgBlockNode;
import org.jruby.ast.CallNoArgBlockPassNode;
import org.jruby.ast.CallNoArgNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.CallOneArgBlockNode;
import org.jruby.ast.CallOneArgBlockPassNode;
import org.jruby.ast.CallOneArgNode;
import org.jruby.ast.CallThreeArgBlockNode;
import org.jruby.ast.CallThreeArgBlockPassNode;
import org.jruby.ast.CallThreeArgNode;
import org.jruby.ast.CallTwoArgBlockNode;
import org.jruby.ast.CallTwoArgBlockPassNode;
import org.jruby.ast.CallTwoArgNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.DotNode;
import org.jruby.ast.EvStrNode;
import org.jruby.ast.FCallNoArgBlockNode;
import org.jruby.ast.FCallNoArgBlockPassNode;
import org.jruby.ast.FCallNoArgNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.FCallOneArgBlockNode;
import org.jruby.ast.FCallOneArgBlockPassNode;
import org.jruby.ast.FCallOneArgNode;
import org.jruby.ast.FCallThreeArgBlockNode;
import org.jruby.ast.FCallThreeArgBlockPassNode;
import org.jruby.ast.FCallThreeArgNode;
import org.jruby.ast.FCallTwoArgBlockNode;
import org.jruby.ast.FCallTwoArgBlockPassNode;
import org.jruby.ast.FCallTwoArgNode;
import org.jruby.ast.FalseNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FlipNode;
import org.jruby.ast.FloatNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.Match2Node;
import org.jruby.ast.Match3Node;
import org.jruby.ast.MatchNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.NilImplicitNode;
import org.jruby.ast.NilNode;
import org.jruby.ast.Node;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.OrNode;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.RootNode;
import org.jruby.ast.SValueNode;
import org.jruby.ast.SelfNode;
import org.jruby.ast.SplatNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.SuperNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.TrueNode;
import org.jruby.ast.YieldNode;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.types.INameNode;
import org.jruby.common.IRubyWarnings;
import org.jruby.lexer.yacc.IDESourcePosition;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.ISourcePositionHolder;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.lexer.yacc.Token;
import org.jruby.parser.BlockStaticScope;
import org.jruby.parser.LocalStaticScope;
import org.jruby.parser.ParserConfiguration;
import org.jruby.parser.RubyParserResult;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.util.ByteList;

public class ParserSupport {
    private StaticScope currentScope;
    private int inSingleton;
    private boolean inDefinition;
    private IRubyWarnings warnings;
    private ParserConfiguration configuration;
    private RubyParserResult result;

    public void reset() {
        this.inSingleton = 0;
        this.inDefinition = false;
    }

    public void allowDubyExtension(ISourcePosition position) {
        if (!this.configuration.isDubyExtensionsEnabled()) {
            throw new SyntaxException(SyntaxException.PID.DUBY_EXTENSIONS_OFF, position, "Duby extensions not configured", new Object[0]);
        }
    }

    public StaticScope getCurrentScope() {
        return this.currentScope;
    }

    public ParserConfiguration getConfiguration() {
        return this.configuration;
    }

    public void popCurrentScope() {
        this.currentScope = this.currentScope.getEnclosingScope();
    }

    public void pushBlockScope() {
        this.currentScope = new BlockStaticScope(this.currentScope);
    }

    public void pushLocalScope() {
        this.currentScope = new LocalStaticScope(this.currentScope);
    }

    public Node arg_concat(ISourcePosition position, Node node1, Node node2) {
        return node2 == null ? node1 : new ArgsCatNode(position, node1, node2);
    }

    public Node arg_blk_pass(Node firstNode, BlockPassNode secondNode) {
        if (secondNode != null) {
            secondNode.setArgsNode(firstNode);
            return secondNode;
        }
        return firstNode;
    }

    public Node gettable2(Node node) {
        switch (node.nodeId) {
            case DASGNNODE: 
            case LOCALASGNNODE: {
                return this.currentScope.declare(node.getPosition(), ((INameNode)((Object)node)).getName());
            }
            case CONSTDECLNODE: {
                return this.currentScope.declare(node.getPosition(), ((INameNode)((Object)node)).getName());
            }
            case INSTASGNNODE: {
                return new InstVarNode(node.getPosition(), ((INameNode)((Object)node)).getName());
            }
            case CLASSVARDECLNODE: 
            case CLASSVARASGNNODE: {
                return new ClassVarNode(node.getPosition(), ((INameNode)((Object)node)).getName());
            }
            case GLOBALASGNNODE: {
                return new GlobalVarNode(node.getPosition(), ((INameNode)((Object)node)).getName());
            }
        }
        throw new SyntaxException(SyntaxException.PID.BAD_IDENTIFIER, node.getPosition(), "identifier " + ((INameNode)((Object)node)).getName() + " is not valid", ((INameNode)((Object)node)).getName());
    }

    public Node gettable(Token token) {
        switch (token.getType()) {
            case 286: {
                return new SelfNode(token.getPosition());
            }
            case 287: {
                return new NilNode(token.getPosition());
            }
            case 288: {
                return new TrueNode(token.getPosition());
            }
            case 289: {
                return new FalseNode(token.getPosition());
            }
            case 303: {
                return new StrNode(token.getPosition(), ByteList.create(token.getPosition().getFile()));
            }
            case 302: {
                return new FixnumNode(token.getPosition(), token.getPosition().getEndLine() + 1);
            }
            case 304: {
                return this.currentScope.declare(token.getPosition(), (String)token.getValue());
            }
            case 308: {
                return new ConstNode(token.getPosition(), (String)token.getValue());
            }
            case 307: {
                return new InstVarNode(token.getPosition(), (String)token.getValue());
            }
            case 309: {
                return new ClassVarNode(token.getPosition(), (String)token.getValue());
            }
            case 306: {
                return new GlobalVarNode(token.getPosition(), (String)token.getValue());
            }
        }
        throw new SyntaxException(SyntaxException.PID.BAD_IDENTIFIER, token.getPosition(), "identifier " + (String)token.getValue() + " is not valid", token.getValue());
    }

    public AssignableNode assignable(Token lhs, Node value) {
        this.checkExpression(value);
        switch (lhs.getType()) {
            case 286: {
                throw new SyntaxException(SyntaxException.PID.CANNOT_CHANGE_SELF, lhs.getPosition(), "Can't change the value of self", new Object[0]);
            }
            case 287: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), "Can't assign to nil", "nil");
            }
            case 288: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), "Can't assign to true", "true");
            }
            case 289: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), "Can't assign to false", "false");
            }
            case 303: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), "Can't assign to __FILE__", "__FILE__");
            }
            case 302: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), "Can't assign to __LINE__", "__LINE__");
            }
            case 304: {
                return this.currentScope.assign(value != NilImplicitNode.NIL ? this.union(lhs, value) : lhs.getPosition(), (String)lhs.getValue(), this.makeNullNil(value));
            }
            case 308: {
                if (this.isInDef() || this.isInSingle()) {
                    throw new SyntaxException(SyntaxException.PID.DYNAMIC_CONSTANT_ASSIGNMENT, lhs.getPosition(), "dynamic constant assignment", new Object[0]);
                }
                return new ConstDeclNode(lhs.getPosition(), (String)lhs.getValue(), null, value);
            }
            case 307: {
                return new InstAsgnNode(lhs.getPosition(), (String)lhs.getValue(), value);
            }
            case 309: {
                if (this.isInDef() || this.isInSingle()) {
                    return new ClassVarAsgnNode(lhs.getPosition(), (String)lhs.getValue(), value);
                }
                return new ClassVarDeclNode(lhs.getPosition(), (String)lhs.getValue(), value);
            }
            case 306: {
                return new GlobalAsgnNode(lhs.getPosition(), (String)lhs.getValue(), value);
            }
        }
        throw new SyntaxException(SyntaxException.PID.BAD_IDENTIFIER, lhs.getPosition(), "identifier " + (String)lhs.getValue() + " is not valid", lhs.getValue());
    }

    public Node newline_node(Node node, ISourcePosition position) {
        if (node == null) {
            return null;
        }
        return node instanceof NewlineNode ? node : new NewlineNode(position, node);
    }

    public ISourcePosition union(ISourcePositionHolder first, ISourcePositionHolder second) {
        while (first instanceof NewlineNode) {
            first = ((NewlineNode)first).getNextNode();
        }
        while (second instanceof NewlineNode) {
            second = ((NewlineNode)second).getNextNode();
        }
        if (second == null) {
            return first.getPosition();
        }
        if (first == null) {
            return second.getPosition();
        }
        return first.getPosition().union(second.getPosition());
    }

    public ISourcePosition union(ISourcePosition first, ISourcePosition second) {
        if (first.getStartOffset() < second.getStartOffset()) {
            return first.union(second);
        }
        return second.union(first);
    }

    public Node addRootNode(Node topOfAST, ISourcePosition position) {
        ISourcePosition iSourcePosition = position = topOfAST != null ? topOfAST.getPosition() : position;
        if (this.result.getBeginNodes().size() == 0) {
            if (topOfAST == null) {
                topOfAST = NilImplicitNode.NIL;
            }
            return new RootNode(position, this.result.getScope(), topOfAST);
        }
        BlockNode newTopOfAST = new BlockNode(position);
        for (Node beginNode : this.result.getBeginNodes()) {
            this.appendToBlock(newTopOfAST, beginNode);
        }
        if (topOfAST != null) {
            newTopOfAST.add(topOfAST);
        }
        return new RootNode(position, this.result.getScope(), newTopOfAST);
    }

    public Node appendToBlock(Node head, Node tail) {
        if (tail == null) {
            return head;
        }
        if (head == null) {
            return tail;
        }
        if (!this.configuration.hasExtraPositionInformation()) {
            head = this.compactNewlines(head);
        }
        if (!(head instanceof BlockNode)) {
            head = new BlockNode(head.getPosition()).add(head);
        }
        if (this.warnings.isVerbose() && this.isBreakStatement(((ListNode)head).getLast())) {
            this.warnings.warning(IRubyWarnings.ID.STATEMENT_NOT_REACHED, tail.getPosition(), "Statement not reached.", new Object[0]);
        }
        ((ListNode)head).addAll(tail);
        head.setPosition(this.union(head, tail));
        return head;
    }

    public Node getOperatorCallNode(Node firstNode, String operator) {
        this.checkExpression(firstNode);
        return new CallNoArgNode(firstNode.getPosition(), firstNode, operator);
    }

    public Node getOperatorCallNode(Node firstNode, String operator, Node secondNode) {
        return this.getOperatorCallNode(firstNode, operator, secondNode, null);
    }

    public Node getOperatorCallNode(Node firstNode, String operator, Node secondNode, ISourcePosition defaultPosition) {
        if (defaultPosition != null) {
            firstNode = this.checkForNilNode(firstNode, defaultPosition);
            secondNode = this.checkForNilNode(secondNode, defaultPosition);
        }
        this.checkExpression(firstNode);
        this.checkExpression(secondNode);
        return new CallOneArgNode(this.union(firstNode.getPosition(), secondNode.getPosition()), firstNode, operator, new ArrayNode(secondNode.getPosition(), secondNode));
    }

    public Node getMatchNode(Node firstNode, Node secondNode) {
        if (firstNode instanceof DRegexpNode || firstNode instanceof RegexpNode) {
            return new Match2Node(firstNode.getPosition(), firstNode, secondNode);
        }
        if (secondNode instanceof DRegexpNode || secondNode instanceof RegexpNode) {
            return new Match3Node(firstNode.getPosition(), secondNode, firstNode);
        }
        return this.getOperatorCallNode(firstNode, "=~", secondNode);
    }

    public Node aryset(Node receiver, Node index) {
        this.checkExpression(receiver);
        return this.new_attrassign(receiver.getPosition(), receiver, "[]=", index);
    }

    public Node attrset(Node receiver, String name) {
        this.checkExpression(receiver);
        return this.new_attrassign(receiver.getPosition(), receiver, name + "=", null);
    }

    public void backrefAssignError(Node node) {
        if (node instanceof NthRefNode) {
            String varName = "$" + ((NthRefNode)node).getMatchNumber();
            throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, node.getPosition(), "Can't set variable " + varName + '.', varName);
        }
        if (node instanceof BackRefNode) {
            String varName = "$" + ((BackRefNode)node).getType();
            throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, node.getPosition(), "Can't set variable " + varName + '.', varName);
        }
    }

    public Node arg_add(ISourcePosition position, Node node1, Node node2) {
        if (node1 == null) {
            if (node2 == null) {
                return new ArrayNode(position, NilImplicitNode.NIL);
            }
            return new ArrayNode(node2.getPosition(), node2);
        }
        if (node1 instanceof ArrayNode) {
            return ((ArrayNode)node1).add(node2);
        }
        return new ArgsPushNode(position, node1, node2);
    }

    public Node node_assign(Node lhs, Node rhs) {
        if (lhs == null) {
            return null;
        }
        Node newNode = lhs;
        this.checkExpression(rhs);
        if (lhs instanceof AssignableNode) {
            ((AssignableNode)lhs).setValueNode(rhs);
            lhs.setPosition(this.union(lhs, rhs));
        } else if (lhs instanceof IArgumentNode) {
            IArgumentNode invokableNode = (IArgumentNode)((Object)lhs);
            return invokableNode.setArgsNode(this.arg_add(lhs.getPosition(), invokableNode.getArgsNode(), rhs));
        }
        return newNode;
    }

    public Node ret_args(Node node, ISourcePosition position) {
        if (node != null) {
            if (node instanceof BlockPassNode) {
                throw new SyntaxException(SyntaxException.PID.DYNAMIC_CONSTANT_ASSIGNMENT, position, "Dynamic constant assignment.", new Object[0]);
            }
            if (node instanceof ArrayNode && ((ArrayNode)node).size() == 1) {
                node = ((ArrayNode)node).get(0);
            } else if (node instanceof SplatNode) {
                node = new SValueNode(position, node);
            }
        }
        return node;
    }

    public boolean isBreakStatement(Node node) {
        block4: while (true) {
            if (node == null) {
                return false;
            }
            switch (node.nodeId) {
                case NEWLINENODE: {
                    node = ((NewlineNode)node).getNextNode();
                    continue block4;
                }
                case BREAKNODE: 
                case NEXTNODE: 
                case REDONODE: 
                case RETRYNODE: 
                case RETURNNODE: {
                    return true;
                }
            }
            break;
        }
        return false;
    }

    public void warnUnlessEOption(IRubyWarnings.ID id, Node node, String message) {
        if (!this.configuration.isInlineSource()) {
            this.warnings.warn(id, node.getPosition(), message, new Object[0]);
        }
    }

    public void warningUnlessEOption(IRubyWarnings.ID id, Node node, String message) {
        if (!this.configuration.isInlineSource()) {
            this.warnings.warning(id, node.getPosition(), message, new Object[0]);
        }
    }

    public void checkExpression(Node node) {
        if (!this.isExpression(node)) {
            this.warnings.warning(IRubyWarnings.ID.VOID_VALUE_EXPRESSION, node.getPosition(), "void value expression", new Object[0]);
        }
    }

    private Node compactNewlines(Node head) {
        Node nextNode;
        while (head instanceof NewlineNode && (nextNode = ((NewlineNode)head).getNextNode()) instanceof NewlineNode) {
            head = nextNode;
        }
        return head;
    }

    private boolean isExpression(Node node) {
        block8: while (true) {
            if (node == null) {
                return true;
            }
            switch (node.nodeId) {
                case BEGINNODE: {
                    node = ((BeginNode)node).getBodyNode();
                    continue block8;
                }
                case BLOCKNODE: {
                    node = ((BlockNode)node).getLast();
                    continue block8;
                }
                case BREAKNODE: {
                    node = ((BreakNode)node).getValueNode();
                    continue block8;
                }
                case NEXTNODE: 
                case REDONODE: 
                case RETRYNODE: 
                case RETURNNODE: 
                case CLASSNODE: 
                case DEFNNODE: 
                case DEFSNODE: 
                case MODULENODE: 
                case UNTILNODE: 
                case WHILENODE: {
                    return false;
                }
                case IFNODE: {
                    return this.isExpression(((IfNode)node).getThenBody()) && this.isExpression(((IfNode)node).getElseBody());
                }
                case NEWLINENODE: {
                    node = ((NewlineNode)node).getNextNode();
                    continue block8;
                }
            }
            break;
        }
        return true;
    }

    public boolean isLiteral(Node node) {
        return node != null && (node instanceof FixnumNode || node instanceof BignumNode || node instanceof FloatNode || node instanceof SymbolNode || node instanceof RegexpNode && (((RegexpNode)node).getOptions() & 0xFFFFFF7F) == 0);
    }

    private void handleUselessWarn(Node node, String useless) {
        this.warnings.warn(IRubyWarnings.ID.USELESS_EXPRESSION, node.getPosition(), "Useless use of " + useless + " in void context.", useless);
    }

    public void checkUselessStatement(Node node) {
        if (!this.warnings.isVerbose()) {
            return;
        }
        block11: while (true) {
            if (node == null) {
                return;
            }
            switch (node.nodeId) {
                case NEWLINENODE: {
                    node = ((NewlineNode)node).getNextNode();
                    continue block11;
                }
                case CALLNODE: {
                    String name = ((CallNode)node).getName();
                    if (name == "+" || name == "-" || name == "*" || name == "/" || name == "%" || name == "**" || name == "+@" || name == "-@" || name == "|" || name == "^" || name == "&" || name == "<=>" || name == ">" || name == ">=" || name == "<" || name == "<=" || name == "==" || name == "!=") {
                        this.handleUselessWarn(node, name);
                    }
                    return;
                }
                case BACKREFNODE: 
                case DVARNODE: 
                case GLOBALVARNODE: 
                case LOCALVARNODE: 
                case NTHREFNODE: 
                case CLASSVARNODE: 
                case INSTVARNODE: {
                    this.handleUselessWarn(node, "a variable");
                    return;
                }
                case BIGNUMNODE: 
                case DREGEXPNODE: 
                case DSTRNODE: 
                case DSYMBOLNODE: 
                case FIXNUMNODE: 
                case FLOATNODE: 
                case REGEXPNODE: 
                case STRNODE: 
                case SYMBOLNODE: {
                    this.handleUselessWarn(node, "a literal");
                    return;
                }
                case DOTNODE: {
                    this.handleUselessWarn(node, ((DotNode)node).isExclusive() ? "..." : "..");
                    return;
                }
                case DEFINEDNODE: {
                    this.handleUselessWarn(node, "defined?");
                    return;
                }
                case FALSENODE: {
                    this.handleUselessWarn(node, "false");
                    return;
                }
                case NILNODE: {
                    this.handleUselessWarn(node, "nil");
                    return;
                }
                case TRUENODE: {
                    this.handleUselessWarn(node, "true");
                    return;
                }
            }
            break;
        }
    }

    public void checkUselessStatements(BlockNode blockNode) {
        if (this.warnings.isVerbose()) {
            Node lastNode = blockNode.getLast();
            for (int i = 0; i < blockNode.size(); ++i) {
                Node currentNode = blockNode.get(i);
                if (lastNode == currentNode) continue;
                this.checkUselessStatement(currentNode);
            }
        }
    }

    private boolean checkAssignmentInCondition(Node node) {
        if (node instanceof MultipleAsgnNode) {
            throw new SyntaxException(SyntaxException.PID.MULTIPLE_ASSIGNMENT_IN_CONDITIONAL, node.getPosition(), "Multiple assignment in conditional.", new Object[0]);
        }
        if (node instanceof LocalAsgnNode || node instanceof DAsgnNode || node instanceof GlobalAsgnNode || node instanceof InstAsgnNode) {
            Node valueNode = ((AssignableNode)node).getValueNode();
            if (valueNode instanceof ILiteralNode || valueNode instanceof NilNode || valueNode instanceof TrueNode || valueNode instanceof FalseNode) {
                this.warnings.warn(IRubyWarnings.ID.ASSIGNMENT_IN_CONDITIONAL, node.getPosition(), "Found '=' in conditional, should be '=='.", new Object[0]);
            }
            return true;
        }
        return false;
    }

    private Node makeNullNil(Node node) {
        return node == null ? NilImplicitNode.NIL : node;
    }

    private Node cond0(Node node) {
        this.checkAssignmentInCondition(node);
        Node leftNode = null;
        Node rightNode = null;
        switch (node.nodeId) {
            case DREGEXPNODE: {
                ISourcePosition position = node.getPosition();
                return new Match2Node(position, node, new GlobalVarNode(position, "$_"));
            }
            case ANDNODE: {
                leftNode = this.cond0(((AndNode)node).getFirstNode());
                rightNode = this.cond0(((AndNode)node).getSecondNode());
                return new AndNode(node.getPosition(), this.makeNullNil(leftNode), this.makeNullNil(rightNode));
            }
            case ORNODE: {
                leftNode = this.cond0(((OrNode)node).getFirstNode());
                rightNode = this.cond0(((OrNode)node).getSecondNode());
                return new OrNode(node.getPosition(), this.makeNullNil(leftNode), this.makeNullNil(rightNode));
            }
            case DOTNODE: {
                DotNode dotNode = (DotNode)node;
                if (dotNode.isLiteral()) {
                    return node;
                }
                String label = String.valueOf("FLIP" + node.hashCode());
                this.currentScope.getLocalScope().addVariable(label);
                int slot = this.currentScope.isDefined(label);
                return new FlipNode(node.getPosition(), this.getFlipConditionNode(((DotNode)node).getBeginNode()), this.getFlipConditionNode(((DotNode)node).getEndNode()), dotNode.isExclusive(), slot);
            }
            case REGEXPNODE: {
                this.warningUnlessEOption(IRubyWarnings.ID.REGEXP_LITERAL_IN_CONDITION, node, "regex literal in condition");
                return new MatchNode(node.getPosition(), node);
            }
        }
        return node;
    }

    public Node getConditionNode(Node node) {
        if (node == null) {
            return NilImplicitNode.NIL;
        }
        if (node instanceof NewlineNode) {
            return new NewlineNode(node.getPosition(), this.cond0(((NewlineNode)node).getNextNode()));
        }
        return this.cond0(node);
    }

    private Node getFlipConditionNode(Node node) {
        if (!this.configuration.isInlineSource()) {
            return node;
        }
        if ((node = this.getConditionNode(node)) instanceof NewlineNode) {
            return ((NewlineNode)node).getNextNode();
        }
        if (node instanceof FixnumNode) {
            this.warnUnlessEOption(IRubyWarnings.ID.LITERAL_IN_CONDITIONAL_RANGE, node, "integer literal in conditional range");
            return this.getOperatorCallNode(node, "==", new GlobalVarNode(node.getPosition(), "$."));
        }
        return node;
    }

    public SplatNode newSplatNode(ISourcePosition position, Node node) {
        return new SplatNode(position, this.makeNullNil(node));
    }

    public ArrayNode newArrayNode(ISourcePosition position, Node firstNode) {
        return new ArrayNode(position, this.makeNullNil(firstNode));
    }

    public AndNode newAndNode(ISourcePosition position, Node left, Node right) {
        this.checkExpression(left);
        if (left == null && right == null) {
            return new AndNode(position, this.makeNullNil(left), this.makeNullNil(right));
        }
        return new AndNode(this.union(left, right), this.makeNullNil(left), this.makeNullNil(right));
    }

    public OrNode newOrNode(ISourcePosition position, Node left, Node right) {
        this.checkExpression(left);
        if (left == null && right == null) {
            return new OrNode(position, this.makeNullNil(left), this.makeNullNil(right));
        }
        return new OrNode(this.union(left, right), this.makeNullNil(left), this.makeNullNil(right));
    }

    public Node getReturnArgsNode(Node node) {
        if (node instanceof ArrayNode && ((ArrayNode)node).size() == 1) {
            return ((ListNode)node).get(0);
        }
        if (node instanceof BlockPassNode) {
            throw new SyntaxException(SyntaxException.PID.BLOCK_ARG_UNEXPECTED, node.getPosition(), "Block argument should not be given.", new Object[0]);
        }
        return node;
    }

    public Node new_attrassign(ISourcePosition position, Node receiver, String name, Node args) {
        if (!(args instanceof ArrayNode)) {
            return new AttrAssignNode(position, receiver, name, args);
        }
        ArrayNode argsNode = (ArrayNode)args;
        switch (argsNode.size()) {
            case 1: {
                return new AttrAssignOneArgNode(position, receiver, name, argsNode);
            }
            case 2: {
                return new AttrAssignTwoArgNode(position, receiver, name, argsNode);
            }
            case 3: {
                return new AttrAssignThreeArgNode(position, receiver, name, argsNode);
            }
        }
        return new AttrAssignNode(position, receiver, name, argsNode);
    }

    private Node new_call_noargs(Node receiver, Token name, IterNode iter) {
        ISourcePosition position = this.union(receiver, name);
        if (receiver == null) {
            receiver = NilImplicitNode.NIL;
        }
        if (iter != null) {
            return new CallNoArgBlockNode(position, receiver, (String)name.getValue(), iter);
        }
        return new CallNoArgNode(position, receiver, (String)name.getValue());
    }

    private Node new_call_complexargs(Node receiver, Token name, Node args, Node iter) {
        if (args instanceof BlockPassNode) {
            if (iter != null) {
                throw new SyntaxException(SyntaxException.PID.BLOCK_ARG_AND_BLOCK_GIVEN, iter.getPosition(), "Both block arg and actual block given.", new Object[0]);
            }
            return this.new_call_blockpass(receiver, name, (BlockPassNode)args);
        }
        return new CallNode(this.union(receiver, args), receiver, (String)name.getValue(), args, iter);
    }

    private Node new_call_blockpass(Node receiver, Token operation, BlockPassNode blockPass) {
        ISourcePosition position = this.union(receiver, blockPass);
        String name = (String)operation.getValue();
        Node args = blockPass.getArgsNode();
        if (args == null) {
            return new CallNoArgBlockPassNode(position, receiver, name, args, blockPass);
        }
        if (!(args instanceof ArrayNode)) {
            return new CallNode(position, receiver, name, args, blockPass);
        }
        switch (((ArrayNode)args).size()) {
            case 0: {
                return new CallNoArgBlockPassNode(position, receiver, name, args, blockPass);
            }
            case 1: {
                return new CallOneArgBlockPassNode(position, receiver, name, (ArrayNode)args, blockPass);
            }
            case 2: {
                return new CallTwoArgBlockPassNode(position, receiver, name, (ArrayNode)args, blockPass);
            }
            case 3: {
                return new CallThreeArgBlockPassNode(position, receiver, name, (ArrayNode)args, blockPass);
            }
        }
        return new CallNode(position, receiver, name, args, blockPass);
    }

    public Node new_call(Node receiver, Token name, Node argsNode, Node iter) {
        if (argsNode == null) {
            return this.new_call_noargs(receiver, name, (IterNode)iter);
        }
        if (!(argsNode instanceof ArrayNode)) {
            return this.new_call_complexargs(receiver, name, argsNode, iter);
        }
        ArrayNode args = (ArrayNode)argsNode;
        switch (args.size()) {
            case 0: {
                if (iter != null) {
                    return new CallNoArgBlockNode(this.union(receiver, args), receiver, (String)name.getValue(), (Node)args, (IterNode)iter);
                }
                return new CallNoArgNode(this.union(receiver, args), receiver, args, (String)name.getValue());
            }
            case 1: {
                if (iter != null) {
                    return new CallOneArgBlockNode(this.union(receiver, args), receiver, (String)name.getValue(), args, (IterNode)iter);
                }
                return new CallOneArgNode(this.union(receiver, args), receiver, (String)name.getValue(), args);
            }
            case 2: {
                if (iter != null) {
                    return new CallTwoArgBlockNode(this.union(receiver, args), receiver, (String)name.getValue(), args, (IterNode)iter);
                }
                return new CallTwoArgNode(this.union(receiver, args), receiver, (String)name.getValue(), args);
            }
            case 3: {
                if (iter != null) {
                    return new CallThreeArgBlockNode(this.union(receiver, args), receiver, (String)name.getValue(), args, (IterNode)iter);
                }
                return new CallThreeArgNode(this.union(receiver, args), receiver, (String)name.getValue(), args);
            }
        }
        return new CallNode(this.union(receiver, args), receiver, (String)name.getValue(), args, iter);
    }

    private Node new_fcall_noargs(Token operation, IterNode iter) {
        if (iter != null) {
            return new FCallNoArgBlockNode(operation.getPosition(), (String)operation.getValue(), iter);
        }
        return new FCallNoArgNode(operation.getPosition(), (String)operation.getValue());
    }

    private Node new_fcall_simpleargs(Token operation, ArrayNode args, Node iter) {
        String name = (String)operation.getValue();
        switch (args.size()) {
            case 0: {
                if (iter != null) {
                    return new FCallNoArgBlockNode(this.union(operation, args), name, (Node)args, (IterNode)iter);
                }
                return new FCallNoArgNode(this.union(operation, args), args, name);
            }
            case 1: {
                if (iter != null) {
                    return new FCallOneArgBlockNode(this.union(operation, args), name, args, (IterNode)iter);
                }
                return new FCallOneArgNode(this.union(operation, args), name, args);
            }
            case 2: {
                if (iter != null) {
                    return new FCallTwoArgBlockNode(this.union(operation, args), name, args, (IterNode)iter);
                }
                return new FCallTwoArgNode(this.union(operation, args), name, args);
            }
            case 3: {
                if (iter != null) {
                    return new FCallThreeArgBlockNode(this.union(operation, args), name, args, (IterNode)iter);
                }
                return new FCallThreeArgNode(this.union(operation, args), name, args);
            }
        }
        return new FCallNode(this.union(operation, args), name, args, iter);
    }

    private Node new_fcall_blockpass(Token operation, BlockPassNode blockPass) {
        ISourcePosition position = this.union(operation, blockPass);
        String name = (String)operation.getValue();
        Node args = blockPass.getArgsNode();
        if (args == null) {
            return new FCallNoArgBlockPassNode(position, name, args, blockPass);
        }
        if (!(args instanceof ArrayNode)) {
            return new FCallNode(position, name, args, blockPass);
        }
        switch (((ArrayNode)args).size()) {
            case 0: {
                return new FCallNoArgBlockPassNode(position, name, args, blockPass);
            }
            case 1: {
                return new FCallOneArgBlockPassNode(position, name, (ArrayNode)args, blockPass);
            }
            case 2: {
                return new FCallTwoArgBlockPassNode(position, name, (ArrayNode)args, blockPass);
            }
            case 3: {
                return new FCallThreeArgBlockPassNode(position, name, (ArrayNode)args, blockPass);
            }
        }
        return new FCallNode(position, name, args, blockPass);
    }

    public Node new_fcall(Token operation, Node args, Node iter) {
        if (args == null) {
            return this.new_fcall_noargs(operation, (IterNode)iter);
        }
        if (args instanceof ArrayNode) {
            return this.new_fcall_simpleargs(operation, (ArrayNode)args, iter);
        }
        String name = (String)operation.getValue();
        if (args instanceof BlockPassNode) {
            if (iter != null) {
                throw new SyntaxException(SyntaxException.PID.BLOCK_ARG_AND_BLOCK_GIVEN, iter.getPosition(), "Both block arg and actual block given.", new Object[0]);
            }
            return this.new_fcall_blockpass(operation, (BlockPassNode)args);
        }
        return new FCallNode(this.union(operation, args), name, args, iter);
    }

    public Node new_super(Node args, Token operation) {
        if (args != null && args instanceof BlockPassNode) {
            return new SuperNode(this.union(operation, args), ((BlockPassNode)args).getArgsNode(), args);
        }
        return new SuperNode(operation.getPosition(), args);
    }

    public void initTopLocalVariables() {
        DynamicScope scope = this.configuration.getScope();
        this.currentScope = scope.getStaticScope();
        this.result.setScope(scope);
    }

    public boolean isInSingle() {
        return this.inSingleton != 0;
    }

    public void setInSingle(int inSingle) {
        this.inSingleton = inSingle;
    }

    public boolean isInDef() {
        return this.inDefinition;
    }

    public void setInDef(boolean inDef) {
        this.inDefinition = inDef;
    }

    public int getInSingle() {
        return this.inSingleton;
    }

    public RubyParserResult getResult() {
        return this.result;
    }

    public void setResult(RubyParserResult result) {
        this.result = result;
    }

    public void setConfiguration(ParserConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setWarnings(IRubyWarnings warnings) {
        this.warnings = warnings;
    }

    public Node literal_concat(ISourcePosition position, Node head, Node tail) {
        if (head == null) {
            return tail;
        }
        if (tail == null) {
            return head;
        }
        if (head instanceof EvStrNode) {
            head = new DStrNode(this.union(head.getPosition(), position)).add(head);
        }
        if (tail instanceof StrNode) {
            if (head instanceof StrNode) {
                return new StrNode(this.union(head, tail), (StrNode)head, (StrNode)tail);
            }
            head.setPosition(this.union(head, tail));
            return ((ListNode)head).add(tail);
        }
        if (tail instanceof DStrNode) {
            if (head instanceof StrNode) {
                ((DStrNode)tail).prepend(head);
                return tail;
            }
            return ((ListNode)head).addAll(tail);
        }
        if (head instanceof StrNode) {
            if (((StrNode)head).getValue().length() == 0) {
                head = new DStrNode(head.getPosition());
            } else {
                head.getPosition().adjustStartOffset(-1);
                head = new DStrNode(head.getPosition()).add(head);
            }
        }
        return ((DStrNode)head).add(tail);
    }

    public Node newEvStrNode(ISourcePosition position, Node node) {
        Node head = node;
        while (node != null) {
            if (node instanceof StrNode || node instanceof DStrNode || node instanceof EvStrNode) {
                return node;
            }
            if (!(node instanceof NewlineNode)) break;
            node = ((NewlineNode)node).getNextNode();
        }
        return new EvStrNode(position, head);
    }

    public Node new_yield(ISourcePosition position, Node node) {
        boolean state = true;
        if (node != null) {
            if (node instanceof BlockPassNode) {
                throw new SyntaxException(SyntaxException.PID.BLOCK_ARG_UNEXPECTED, node.getPosition(), "Block argument should not be given.", new Object[0]);
            }
            if (node instanceof ArrayNode && ((ArrayNode)node).size() == 1) {
                node = ((ArrayNode)node).get(0);
                state = false;
            }
            if (node != null && node instanceof SplatNode) {
                state = true;
            }
        } else {
            state = false;
        }
        return new YieldNode(position, node, state);
    }

    public Node negateInteger(Node integerNode) {
        if (integerNode instanceof FixnumNode) {
            FixnumNode fixnumNode = (FixnumNode)integerNode;
            fixnumNode.setValue(-fixnumNode.getValue());
            return fixnumNode;
        }
        if (integerNode instanceof BignumNode) {
            BignumNode bignumNode = (BignumNode)integerNode;
            bignumNode.setValue(bignumNode.getValue().negate());
        }
        return integerNode;
    }

    public FloatNode negateFloat(FloatNode floatNode) {
        floatNode.setValue(-floatNode.getValue());
        return floatNode;
    }

    public ISourcePosition createEmptyArgsNodePosition(ISourcePosition pos) {
        return new IDESourcePosition(pos.getFile(), pos.getStartLine(), pos.getEndLine(), pos.getEndOffset() - 1, pos.getEndOffset() - 1);
    }

    public Node unwrapNewlineNode(Node node) {
        if (node instanceof NewlineNode) {
            return ((NewlineNode)node).getNextNode();
        }
        return node;
    }

    private Node checkForNilNode(Node node, ISourcePosition defaultPosition) {
        return node == null ? new NilNode(defaultPosition) : node;
    }

    public ArgumentNode getRestArgNode(Token token) {
        int index = (Integer)token.getValue();
        if (index < 0) {
            return null;
        }
        String name = this.getCurrentScope().getLocalScope().getVariables()[index];
        IDESourcePosition position = new IDESourcePosition(token.getPosition().getFile(), token.getPosition().getStartLine(), token.getPosition().getEndLine(), token.getPosition().getStartOffset(), token.getPosition().getEndOffset() + name.length());
        return new ArgumentNode((ISourcePosition)position, name);
    }
}

