/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectProxyCache<T, A> {
    private static final int DEFAULT_SEGMENTS = 16;
    private static final int DEFAULT_SEGMENT_SIZE = 8;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int MAX_CAPACITY = 0x40000000;
    private static final int MAX_SEGMENTS = 65536;
    private static final int VULTURE_RUN_FREQ_SECONDS = 5;
    private static int _nextId = 0;
    private final ReferenceType referenceType;
    private final Segment<T, A>[] segments;
    private final int segmentShift;
    private final int segmentMask;
    private final Thread vulture;
    private final int id;

    private static synchronized int nextId() {
        return ++_nextId;
    }

    public ObjectProxyCache() {
        this(16, 8, ReferenceType.WEAK);
    }

    public ObjectProxyCache(ReferenceType refType) {
        this(16, 8, refType);
    }

    public ObjectProxyCache(int numSegments, int initialSegCapacity, ReferenceType refType) {
        int cap;
        int ssize;
        if (numSegments <= 0 || initialSegCapacity <= 0 || refType == null) {
            throw new IllegalArgumentException();
        }
        this.id = ObjectProxyCache.nextId();
        this.referenceType = refType;
        if (numSegments > 65536) {
            numSegments = 65536;
        }
        int sshift = 0;
        for (ssize = 1; ssize < numSegments; ssize <<= 1) {
            ++sshift;
        }
        this.segmentShift = 24 - sshift;
        this.segmentMask = ssize - 1;
        this.segments = Segment.newArray(ssize);
        if (initialSegCapacity > 0x40000000) {
            initialSegCapacity = 0x40000000;
        }
        for (cap = 1; cap < initialSegCapacity; cap <<= 1) {
        }
        int i = ssize;
        while (--i >= 0) {
            this.segments[i] = new Segment(cap, this);
        }
        this.vulture = new Thread("ObjectProxyCache " + this.id + " vulture"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    boolean dump;
                    try {
                        1.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    boolean bl = dump = ObjectProxyCache.this.size() > 200;
                    if (dump) {
                        System.err.println("***Vulture " + ObjectProxyCache.this.id + " waking, stats:");
                        System.err.println(ObjectProxyCache.this.stats());
                    }
                    int i = ObjectProxyCache.this.segments.length;
                    while (--i >= 0) {
                        Segment seg = ObjectProxyCache.this.segments[i];
                        seg.lock();
                        try {
                            seg.expunge();
                        }
                        finally {
                            seg.unlock();
                        }
                        1.yield();
                    }
                    if (!dump) continue;
                    System.err.println("***Vulture " + ObjectProxyCache.this.id + " sleeping, stats:");
                    System.err.println(ObjectProxyCache.this.stats());
                }
            }
        };
        try {
            this.vulture.setDaemon(true);
        }
        catch (SecurityException e) {
            // empty catch block
        }
    }

    public abstract T allocateProxy(Object var1, A var2);

    public T get(Object javaObject) {
        if (javaObject == null) {
            return null;
        }
        int hash = ObjectProxyCache.hash(javaObject);
        return this.segmentFor(hash).get(javaObject, hash);
    }

    public T getOrCreate(Object javaObject, A allocator) {
        if (javaObject == null || allocator == null) {
            return null;
        }
        int hash = ObjectProxyCache.hash(javaObject);
        return this.segmentFor(hash).getOrCreate(javaObject, hash, allocator);
    }

    public void put(Object javaObject, T proxy2) {
        if (javaObject == null || proxy2 == null) {
            return;
        }
        int hash = ObjectProxyCache.hash(javaObject);
        this.segmentFor(hash).put(javaObject, hash, proxy2);
    }

    private static int hash(Object javaObject) {
        int h = System.identityHashCode(javaObject);
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    private Segment<T, A> segmentFor(int hash) {
        return this.segments[hash >>> this.segmentShift & this.segmentMask];
    }

    public int size() {
        int size = 0;
        for (Segment<T, A> seg : this.segments) {
            size += seg.tableSize;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String stats() {
        StringBuilder b = new StringBuilder();
        int n = 0;
        int size = 0;
        int alloc = 0;
        b.append("Segments: ").append(this.segments.length).append("\n");
        for (Segment<T, A> seg : this.segments) {
            int ssize = 0;
            int salloc = 0;
            seg.lock();
            try {
                ssize = ((Segment)seg).count();
                salloc = seg.entryTable.length;
            }
            finally {
                seg.unlock();
            }
            size += ssize;
            alloc += salloc;
            b.append("seg[").append(n++).append("]:  size: ").append(ssize).append("  alloc: ").append(salloc).append("\n");
        }
        b.append("Total: size: ").append(size).append("  alloc: ").append(alloc).append("\n");
        return b.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Segment<T, A>
    extends ReentrantLock {
        final ObjectProxyCache<T, A> cache;
        final ReferenceQueue<Object> referenceQueue = new ReferenceQueue();
        volatile Entry<T>[] entryTable;
        int tableSize;
        int threshold;

        Segment(int capacity, ObjectProxyCache<T, A> cache) {
            this.threshold = (int)((float)capacity * 0.75f);
            this.entryTable = Entry.newArray(capacity);
            this.cache = cache;
        }

        private void expunge() {
            EntryRef ref;
            Entry<T>[] table = this.entryTable;
            ReferenceQueue<Object> queue = this.referenceQueue;
            block0: while ((ref = (EntryRef)((Object)queue.poll())) != null) {
                int hash = ref.hash();
                Entry<T> e = table[hash & table.length - 1];
                while (e != null) {
                    if (hash == e.hash && (ref == e.objectRef || ref == e.proxyRef)) {
                        this.remove(table, hash, e);
                        continue block0;
                    }
                    e = e.next;
                }
            }
        }

        private void remove(Entry<T>[] table, int hash, Entry<T> e) {
            Entry<T> first;
            int index = hash & table.length - 1;
            Entry<T> n = first = table[index];
            while (n != null) {
                if (n == e) {
                    Entry newFirst = n.next;
                    Entry<T> p = first;
                    while (p != n) {
                        newFirst = new Entry(p.objectRef, p.hash, p.proxyRef, newFirst);
                        p = p.next;
                    }
                    table[index] = newFirst;
                    --this.tableSize;
                    this.entryTable = table;
                    return;
                }
                n = n.next;
            }
        }

        private int count() {
            int count = 0;
            for (Entry<T> e : this.entryTable) {
                while (e != null) {
                    ++count;
                    e = e.next;
                }
            }
            return count;
        }

        private Entry<T>[] rehash() {
            assert (this.tableSize == this.count()) : "tableSize " + this.tableSize + " != count() " + this.count();
            Entry<T>[] oldTable = this.entryTable;
            int oldCapacity = oldTable.length;
            if (oldCapacity >= 0x40000000) {
                return oldTable;
            }
            int newCapacity = oldCapacity << 1;
            int sizeMask = newCapacity - 1;
            this.threshold = (int)((float)newCapacity * 0.75f);
            Entry<T>[] newTable = Entry.newArray(newCapacity);
            int i = oldCapacity;
            while (--i >= 0) {
                int k;
                Entry<T> e = oldTable[i];
                if (e == null) continue;
                int idx = e.hash & sizeMask;
                Entry next = e.next;
                if (next == null) {
                    newTable[idx] = e;
                    continue;
                }
                int lastIdx = idx;
                Entry<T> lastRun = e;
                Entry last = next;
                while (last != null) {
                    k = last.hash & sizeMask;
                    if (k != lastIdx) {
                        lastIdx = k;
                        lastRun = last;
                    }
                    last = last.next;
                }
                newTable[lastIdx] = lastRun;
                Entry<T> p = e;
                while (p != lastRun) {
                    k = p.hash & sizeMask;
                    Entry m = new Entry(p.objectRef, p.hash, p.proxyRef, newTable[k]);
                    newTable[k] = m;
                    p = p.next;
                }
            }
            this.entryTable = newTable;
            return newTable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void put(Object object, int hash, T proxy2) {
            this.lock();
            try {
                this.expunge();
                int potentialNewSize = this.tableSize + 1;
                Entry<T>[] table = potentialNewSize > this.threshold ? this.rehash() : this.entryTable;
                int index = hash & table.length - 1;
                Entry<T> e = table[index];
                while (e != null) {
                    if (hash == e.hash && object == e.objectRef.get()) {
                        if (proxy2 == e.proxyRef.get()) {
                            return;
                        }
                        this.remove(table, hash, e);
                        --potentialNewSize;
                        break;
                    }
                    e = e.next;
                }
                table[index] = e = new Entry<T>(object, hash, proxy2, ((ObjectProxyCache)this.cache).referenceType, table[index], this.referenceQueue);
                this.tableSize = potentialNewSize;
                this.entryTable = table;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        T getOrCreate(Object object, int hash, A allocator) {
            Object proxy2;
            Entry<T>[] table = this.entryTable;
            Entry<T> e = this.entryTable[hash & table.length - 1];
            while (e != null) {
                if (hash == e.hash && object == e.objectRef.get()) {
                    proxy2 = e.proxyRef.get();
                    if (proxy2 == null) break;
                    return proxy2;
                }
                e = e.next;
            }
            this.lock();
            try {
                this.expunge();
                int potentialNewSize = this.tableSize + 1;
                table = potentialNewSize > this.threshold ? this.rehash() : this.entryTable;
                int index = hash & table.length - 1;
                Entry<T> e2 = table[index];
                while (e2 != null) {
                    if (hash == e2.hash && object == e2.objectRef.get()) {
                        proxy2 = e2.proxyRef.get();
                        if (proxy2 != null) {
                            Object t = proxy2;
                            return t;
                        }
                        this.remove(table, hash, e2);
                        --potentialNewSize;
                        break;
                    }
                    e2 = e2.next;
                }
                proxy2 = this.cache.allocateProxy(object, allocator);
                table[index] = e2 = new Entry(object, hash, proxy2, ((ObjectProxyCache)this.cache).referenceType, table[index], this.referenceQueue);
                this.tableSize = potentialNewSize;
                this.entryTable = table;
                Object t = proxy2;
                return t;
            }
            finally {
                this.unlock();
            }
        }

        T get(Object object, int hash) {
            Entry<T>[] table = this.entryTable;
            Entry<T> e = this.entryTable[hash & table.length - 1];
            while (e != null) {
                if (hash == e.hash && object == e.objectRef.get()) {
                    return e.proxyRef.get();
                }
                e = e.next;
            }
            return null;
        }

        static final <T, A> Segment<T, A>[] newArray(int size) {
            return new Segment[size];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Entry<T> {
        final EntryRef<Object> objectRef;
        final int hash;
        final EntryRef<T> proxyRef;
        final Entry<T> next;

        Entry(Object object, int hash, T proxy2, ReferenceType type, Entry<T> next, ReferenceQueue<Object> queue) {
            this.hash = hash;
            this.next = next;
            if (type == ReferenceType.WEAK) {
                this.objectRef = new WeakEntryRef<Object>(hash, object, queue);
                this.proxyRef = new WeakEntryRef<T>(hash, proxy2, queue);
            } else {
                this.objectRef = new SoftEntryRef<Object>(hash, object, queue);
                this.proxyRef = new SoftEntryRef<T>(hash, proxy2, queue);
            }
        }

        Entry(EntryRef<Object> objectRef, int hash, EntryRef<T> proxyRef, Entry<T> next) {
            this.objectRef = objectRef;
            this.hash = hash;
            this.proxyRef = proxyRef;
            this.next = next;
        }

        static final <T> Entry<T>[] newArray(int size) {
            return new Entry[size];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SoftEntryRef<T>
    extends SoftReference<T>
    implements EntryRef<T> {
        final int hash;

        SoftEntryRef(int hash, T rawObject, ReferenceQueue<Object> queue) {
            super(rawObject, queue);
            this.hash = hash;
        }

        @Override
        public int hash() {
            return this.hash;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WeakEntryRef<T>
    extends WeakReference<T>
    implements EntryRef<T> {
        final int hash;

        WeakEntryRef(int hash, T rawObject, ReferenceQueue<Object> queue) {
            super(rawObject, queue);
            this.hash = hash;
        }

        @Override
        public int hash() {
            return this.hash;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface EntryRef<T> {
        public T get();

        public int hash();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReferenceType {
        WEAK,
        SOFT;

    }
}

