/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.NoFunctionalitySignalFacade;
import org.jruby.util.SignalFacade;

@JRubyModule(name={"Signal"})
public class RubySignal {
    private static final SignalFacade SIGNALS = RubySignal.getSignalFacade();
    public static final String[] NAMES = new String[]{"EXIT", "HUP", "INT", "QUIT", "ILL", "TRAP", "ABRT", "EMT", "FPE", "KILL", "BUS", "SEGV", "SYS", "PIPE", "ALRM", "TERM", "URG", "STOP", "TSTP", "CONT", "CHLD", "TTIN", "TTOU", "IO", "XCPU", "XFSZ", "VTALRM", "PROF", "WINCH", "INFO", "USR1", "USR2"};

    private static final SignalFacade getSignalFacade() {
        try {
            Class<?> realFacadeClass = Class.forName("org.jruby.util.SunSignalFacade");
            return (SignalFacade)realFacadeClass.newInstance();
        }
        catch (Throwable e) {
            return new NoFunctionalitySignalFacade();
        }
    }

    public static void createSignal(Ruby runtime) {
        RubyModule mSignal = runtime.defineModule("Signal");
        mSignal.defineAnnotatedMethods(RubySignal.class);
    }

    @JRubyMethod(name={"trap"}, required=1, optional=1, frame=true, meta=true)
    public static IRubyObject trap(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block block) {
        Ruby runtime = recv.getRuntime();
        runtime.getLoadService().require("jsignal");
        return RuntimeHelpers.invoke(context, (IRubyObject)runtime.getKernel(), "__jtrap", args, CallType.FUNCTIONAL, block);
    }

    @JRubyMethod(name={"list"}, meta=true)
    public static IRubyObject list(ThreadContext context, IRubyObject recv) {
        Ruby runtime = recv.getRuntime();
        RubyHash names = RubyHash.newHash(runtime);
        for (int i = 0; i < NAMES.length; ++i) {
            names.op_aset(context, runtime.newString(NAMES[i]), runtime.newFixnum(i));
        }
        names.op_aset(context, runtime.newString("IOT"), runtime.newFixnum(6));
        names.op_aset(context, runtime.newString("CLD"), runtime.newFixnum(20));
        return names;
    }

    @JRubyMethod(name={"__jtrap_kernel"}, required=3, meta=true)
    public static IRubyObject __jtrap_kernel(IRubyObject recv, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        return SIGNALS.trap(recv, arg1, arg2, arg3);
    }
}

