/*
 * Decompiled with CFR 0.152.
 */
package org.joni.util;

import org.joni.util.Hash;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntHash<V>
extends Hash<V> {
    public IntHash() {
    }

    public IntHash(int size) {
        super(size);
    }

    public V put(int key, V value) {
        this.checkResize();
        int hash = IntHash.hashValue(key);
        int i = IntHash.bucketIndex(hash, this.table.length);
        OniIntHashEntry entry = (OniIntHashEntry)this.table[i];
        while (entry != null) {
            if (entry.hash == hash) {
                entry.value = value;
                return value;
            }
            entry = (OniIntHashEntry)entry.next;
        }
        this.table[i] = new OniIntHashEntry<V>(hash, this.table[i], value);
        ++this.size;
        return null;
    }

    public void putDirect(int key, V value) {
        this.checkResize();
        int hash = IntHash.hashValue(key);
        int i = IntHash.bucketIndex(hash, this.table.length);
        this.table[i] = new OniIntHashEntry<V>(hash, this.table[i], value);
        ++this.size;
    }

    public V get(int key) {
        int hash = IntHash.hashValue(key);
        OniIntHashEntry entry = (OniIntHashEntry)this.table[IntHash.bucketIndex(hash, this.table.length)];
        while (entry != null) {
            if (entry.hash == hash) {
                return (V)entry.value;
            }
            entry = (OniIntHashEntry)entry.next;
        }
        return null;
    }

    public V delete(int key) {
        int hash = IntHash.hashValue(key);
        int i = IntHash.bucketIndex(hash, this.table.length);
        OniIntHashEntry entry = (OniIntHashEntry)this.table[i];
        if (entry == null) {
            return null;
        }
        if (entry.hash == hash) {
            this.table[i] = entry.next;
            --this.size;
            return (V)entry.value;
        }
        while (entry.next != null) {
            Hash.OniHashEntry tmp = entry.next;
            if (tmp.hash == hash && entry.equals(key)) {
                entry.next = entry.next.next;
                --this.size;
                return tmp.value;
            }
            entry = (OniIntHashEntry)entry.next;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OniIntHashEntry<V>
    extends Hash.OniHashEntry<V> {
        public OniIntHashEntry(int hash, Hash.OniHashEntry<V> next, V value) {
            super(hash, next, value);
        }
    }
}

