/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.internal.swt;

import org.eclipse.jface.internal.databinding.provisional.observable.Diffs;
import org.eclipse.jface.internal.databinding.provisional.observable.value.AbstractObservableValue;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;

public class CComboObservableValue
extends AbstractObservableValue {
    private final CCombo ccombo;
    private final String attribute;
    private boolean updating = false;
    private String currentValue;

    public CComboObservableValue(CCombo ccombo, String attribute) {
        this.ccombo = ccombo;
        this.attribute = attribute;
        if (!attribute.equals("selection") && !attribute.equals("text")) {
            throw new IllegalArgumentException();
        }
        this.currentValue = ccombo.getText();
        ccombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!CComboObservableValue.this.updating) {
                    String oldValue = CComboObservableValue.this.currentValue;
                    CComboObservableValue.this.currentValue = CComboObservableValue.this.ccombo.getText();
                    CComboObservableValue.this.fireValueChange(Diffs.createValueDiff(oldValue, CComboObservableValue.this.currentValue));
                }
            }
        });
    }

    public void setValue(Object value) {
        String oldValue = this.ccombo.getText();
        try {
            this.updating = true;
            if (this.attribute.equals("text")) {
                String stringValue = value != null ? value.toString() : "";
                this.ccombo.setText(stringValue);
            } else if (this.attribute.equals("selection")) {
                String[] items = this.ccombo.getItems();
                int index = -1;
                if (items != null && value != null) {
                    int i = 0;
                    while (i < items.length) {
                        if (value.equals(items[i])) {
                            index = i;
                            break;
                        }
                        ++i;
                    }
                    if (index == -1) {
                        this.ccombo.setText((String)value);
                    } else {
                        this.ccombo.select(index);
                    }
                }
            }
        }
        finally {
            this.updating = false;
        }
        this.fireValueChange(Diffs.createValueDiff(oldValue, this.ccombo.getText()));
    }

    public Object doGetValue() {
        if (this.attribute.equals("text")) {
            return this.ccombo.getText();
        }
        Assert.isTrue((boolean)this.attribute.equals("selection"), (String)("unexpected attribute: " + this.attribute));
        return this.ccombo.getText();
    }

    public Object getValueType() {
        Assert.isTrue((this.attribute.equals("text") || this.attribute.equals("selection") ? 1 : 0) != 0, (String)("unexpected attribute: " + this.attribute));
        return String.class;
    }
}

