/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.properties.tabbed.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.views.properties.tabbed.ISectionDescriptor;
import org.eclipse.ui.views.properties.tabbed.ITypeMapper;

public class TabbedPropertyRegistryClassSectionFilter {
    private ITypeMapper typeMapper = null;

    protected TabbedPropertyRegistryClassSectionFilter(ITypeMapper typeMapper) {
        this.typeMapper = typeMapper;
    }

    protected boolean appliesToSelection(ISectionDescriptor descriptor, ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            if (descriptor.getEnablesFor() != -1 && ((IStructuredSelection)selection).size() != descriptor.getEnablesFor()) {
                return false;
            }
            IFilter filter = descriptor.getFilter();
            if (filter != null) {
                for (Object object : (IStructuredSelection)selection) {
                    if (filter == null || filter.select(object)) continue;
                    return false;
                }
                return true;
            }
            HashSet<Class> effectiveTypes = new HashSet<Class>();
            for (Object object : (IStructuredSelection)selection) {
                Class remapType = object.getClass();
                if (this.typeMapper != null) {
                    remapType = this.typeMapper.mapType(object);
                }
                if (!effectiveTypes.add(remapType) || this.appliesToEffectiveType(descriptor, remapType)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean appliesToEffectiveType(ISectionDescriptor descriptor, Class inputClass) {
        ArrayList classTypes = this.getClassTypes(inputClass);
        List sectionInputTypes = descriptor.getInputTypes();
        for (String type : sectionInputTypes) {
            if (!classTypes.contains(type)) continue;
            return true;
        }
        return false;
    }

    protected ArrayList getClassTypes(Class target) {
        ArrayList<String> result = new ArrayList<String>();
        List classes = this.computeClassOrder(target);
        Iterator i = classes.iterator();
        while (i.hasNext()) {
            result.add(((Class)i.next()).getName());
        }
        result.addAll(this.computeInterfaceOrder(classes));
        return result;
    }

    private List computeClassOrder(Class target) {
        ArrayList result = new ArrayList(4);
        Class clazz = target;
        while (clazz != null) {
            result.add(clazz);
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    private List computeInterfaceOrder(List classes) {
        ArrayList result = new ArrayList(4);
        HashMap seen = new HashMap(4);
        Iterator iter = classes.iterator();
        while (iter.hasNext()) {
            Class[] interfaces = ((Class)iter.next()).getInterfaces();
            this.internalComputeInterfaceOrder(interfaces, result, seen);
        }
        return result;
    }

    private void internalComputeInterfaceOrder(Class[] interfaces, List result, Map seen) {
        ArrayList<Class> newInterfaces = new ArrayList<Class>(seen.size());
        int i = 0;
        while (i < interfaces.length) {
            Class interfac = interfaces[i];
            if (seen.get(interfac) == null) {
                result.add(interfac.getName());
                seen.put(interfac, interfac);
                newInterfaces.add(interfac);
            }
            ++i;
        }
        Iterator iter = newInterfaces.iterator();
        while (iter.hasNext()) {
            this.internalComputeInterfaceOrder(((Class)iter.next()).getInterfaces(), result, seen);
        }
    }
}

