/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.properties.tabbed.view;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.views.properties.tabbed.TabbedPropertyViewPlugin;
import org.eclipse.ui.internal.views.properties.tabbed.l10n.TabbedPropertyMessages;
import org.eclipse.ui.internal.views.properties.tabbed.view.SectionDescriptor;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabDescriptor;
import org.eclipse.ui.views.properties.tabbed.IActionProvider;
import org.eclipse.ui.views.properties.tabbed.ISectionDescriptor;
import org.eclipse.ui.views.properties.tabbed.ISectionDescriptorProvider;
import org.eclipse.ui.views.properties.tabbed.ITypeMapper;

public class TabbedPropertyRegistry {
    private static final String NO_TAB_ERROR = TabbedPropertyMessages.TabbedPropertyRegistry_Non_existing_tab;
    private static final String CONTRIBUTOR_ERROR = TabbedPropertyMessages.TabbedPropertyRegistry_contributor_error;
    private static final String EXTPT_CONTRIBUTOR = "propertyContributor";
    private static final String EXTPT_TABS = "propertyTabs";
    private static final String EXTPT_SECTIONS = "propertySections";
    private static final String ELEMENT_TAB = "propertyTab";
    private static final String ELEMENT_SECTION = "propertySection";
    private static final String ELEMENT_PROPERTY_CATEGORY = "propertyCategory";
    private static final String ATT_CATEGORY = "category";
    private static final String ATT_CONTRIBUTOR_ID = "contributorId";
    private static final String ATT_TYPE_MAPPER = "typeMapper";
    private static final String ATT_LABEL_PROVIDER = "labelProvider";
    private static final String ATT_ACTION_PROVIDER = "actionProvider";
    private static final String TOP = "top";
    protected String contributorId;
    protected IConfigurationElement contributorConfigurationElement;
    protected List propertyCategories;
    protected ILabelProvider labelProvider;
    protected IActionProvider actionProvider;
    protected ITypeMapper typeMapper;
    protected ISectionDescriptorProvider sectionDescriptorProvider;
    protected TabDescriptor[] tabDescriptors;
    protected static final TabDescriptor[] EMPTY_DESCRIPTOR_ARRAY = new TabDescriptor[0];

    protected TabbedPropertyRegistry(String id) {
        this.contributorId = id;
        this.propertyCategories = new ArrayList();
        IConfigurationElement[] extensions = this.getConfigurationElements(EXTPT_CONTRIBUTOR);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement configurationElement = extensions[i];
            String contributor = configurationElement.getAttribute(ATT_CONTRIBUTOR_ID);
            if (contributor != null && id.equals(contributor)) {
                this.contributorConfigurationElement = configurationElement;
                try {
                    if (configurationElement.getAttribute(ATT_LABEL_PROVIDER) != null) {
                        this.labelProvider = (ILabelProvider)configurationElement.createExecutableExtension(ATT_LABEL_PROVIDER);
                    }
                    if (configurationElement.getAttribute(ATT_ACTION_PROVIDER) != null) {
                        this.actionProvider = (IActionProvider)configurationElement.createExecutableExtension(ATT_ACTION_PROVIDER);
                    }
                    if (configurationElement.getAttribute(ATT_TYPE_MAPPER) != null) {
                        this.typeMapper = (ITypeMapper)configurationElement.createExecutableExtension(ATT_TYPE_MAPPER);
                    }
                }
                catch (CoreException exception) {
                    this.handleConfigurationError(id, exception);
                }
                this.addPropertyCategories(configurationElement);
            }
            ++i;
        }
        if (this.propertyCategories == null || this.contributorId == null || this.contributorConfigurationElement == null) {
            this.handleConfigurationError(id, null);
            this.contributorId = null;
        }
    }

    private void addPropertyCategories(IConfigurationElement configurationElement) {
        IConfigurationElement[] elements = configurationElement.getChildren(ELEMENT_PROPERTY_CATEGORY);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            this.propertyCategories.add(element.getAttribute(ATT_CATEGORY));
            ++i;
        }
    }

    private void handleConfigurationError(String id, CoreException exception) {
        String message = MessageFormat.format((String)CONTRIBUTOR_ERROR, (Object[])new Object[]{id});
        Status status = new Status(4, TabbedPropertyViewPlugin.getPlugin().getBundle().getSymbolicName(), 4, message, (Throwable)exception);
        TabbedPropertyViewPlugin.getPlugin().getLog().log((IStatus)status);
    }

    protected ISectionDescriptor[] readSectionDescriptors() {
        ArrayList<SectionDescriptor> result = new ArrayList<SectionDescriptor>();
        IConfigurationElement[] extensions = this.getConfigurationElements(EXTPT_SECTIONS);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement extension = extensions[i];
            IConfigurationElement[] sections = extension.getChildren(ELEMENT_SECTION);
            int j = 0;
            while (j < sections.length) {
                IConfigurationElement section = sections[j];
                SectionDescriptor descriptor = new SectionDescriptor(section, this.typeMapper);
                result.add(descriptor);
                ++j;
            }
            ++i;
        }
        return result.toArray(new ISectionDescriptor[result.size()]);
    }

    protected IConfigurationElement[] getConfigurationElements(String extensionPointId) {
        if (this.contributorId == null) {
            return new IConfigurationElement[0];
        }
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(TabbedPropertyViewPlugin.getPlugin().getBundle().getSymbolicName(), extensionPointId);
        IConfigurationElement[] extensions = point.getConfigurationElements();
        ArrayList<IConfigurationElement> unordered = new ArrayList<IConfigurationElement>(extensions.length);
        int i = 0;
        while (i < extensions.length) {
            String contributor;
            IConfigurationElement extension = extensions[i];
            if (extension.getName().equals(extensionPointId) && this.contributorId.equals(contributor = extension.getAttribute(ATT_CONTRIBUTOR_ID))) {
                unordered.add(extension);
            }
            ++i;
        }
        return unordered.toArray(new IConfigurationElement[unordered.size()]);
    }

    private int getIndex(Object[] array, Object target) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(target)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public TabDescriptor[] getTabDescriptors(IWorkbenchPart part, ISelection selection) {
        if (selection == null || selection.isEmpty()) {
            return EMPTY_DESCRIPTOR_ARRAY;
        }
        TabDescriptor[] allDescriptors = this.getAllTabDescriptors();
        TabDescriptor[] result = this.filterTabDescriptors(allDescriptors, part, selection);
        return result;
    }

    protected TabDescriptor[] filterTabDescriptors(TabDescriptor[] descriptors, IWorkbenchPart part, ISelection selection) {
        ArrayList<TabDescriptor> result = new ArrayList<TabDescriptor>();
        int i = 0;
        while (i < descriptors.length) {
            TabDescriptor descriptor = this.adaptDescriptorFor(descriptors[i], part, selection);
            if (!descriptor.getSectionDescriptors().isEmpty()) {
                result.add(descriptor);
            }
            ++i;
        }
        if (result.size() == 0) {
            return EMPTY_DESCRIPTOR_ARRAY;
        }
        return result.toArray(new TabDescriptor[result.size()]);
    }

    protected TabDescriptor adaptDescriptorFor(TabDescriptor target, IWorkbenchPart part, ISelection selection) {
        ArrayList<ISectionDescriptor> filteredSectionDescriptors = new ArrayList<ISectionDescriptor>();
        List descriptors = target.getSectionDescriptors();
        for (ISectionDescriptor descriptor : descriptors) {
            if (!descriptor.appliesTo(part, selection)) continue;
            filteredSectionDescriptors.add(descriptor);
        }
        TabDescriptor result = (TabDescriptor)target.clone();
        result.setSectionDescriptors(filteredSectionDescriptors);
        return result;
    }

    protected TabDescriptor[] getAllTabDescriptors() {
        if (this.tabDescriptors == null) {
            List temp = this.readTabDescriptors();
            this.populateWithSectionDescriptors(temp);
            temp = this.sortTabDescriptorsByCategory(temp);
            temp = this.sortTabDescriptorsByAfterTab(temp);
            this.tabDescriptors = temp.toArray(new TabDescriptor[temp.size()]);
        }
        return this.tabDescriptors;
    }

    protected List readTabDescriptors() {
        ArrayList<TabDescriptor> result = new ArrayList<TabDescriptor>();
        IConfigurationElement[] extensions = this.getConfigurationElements(EXTPT_TABS);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement extension = extensions[i];
            IConfigurationElement[] tabs = extension.getChildren(ELEMENT_TAB);
            int j = 0;
            while (j < tabs.length) {
                IConfigurationElement tab = tabs[j];
                TabDescriptor descriptor = new TabDescriptor(tab);
                result.add(descriptor);
                ++j;
            }
            ++i;
        }
        return result;
    }

    protected void populateWithSectionDescriptors(List aTabDescriptors) {
        ISectionDescriptor[] sections = null;
        sections = this.sectionDescriptorProvider != null ? this.sectionDescriptorProvider.getSectionDescriptors() : this.readSectionDescriptors();
        int i = 0;
        while (i < sections.length) {
            ISectionDescriptor section = sections[i];
            this.appendToTabDescriptor(section, aTabDescriptors);
            ++i;
        }
    }

    protected void appendToTabDescriptor(ISectionDescriptor section, List aTabDescriptors) {
        for (TabDescriptor tab : aTabDescriptors) {
            if (!tab.append(section)) continue;
            return;
        }
        String message = MessageFormat.format((String)NO_TAB_ERROR, (Object[])new Object[]{section.getId(), section.getTargetTab()});
        Status status = new Status(4, TabbedPropertyViewPlugin.getPlugin().getBundle().getSymbolicName(), 1, message, null);
        TabbedPropertyViewPlugin.getPlugin().getLog().log((IStatus)status);
    }

    protected List sortTabDescriptorsByCategory(List descriptors) {
        Collections.sort(descriptors, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                TabDescriptor one = (TabDescriptor)arg0;
                TabDescriptor two = (TabDescriptor)arg1;
                String categoryOne = one.getCategory();
                String categoryTwo = two.getCategory();
                int categoryOnePosition = TabbedPropertyRegistry.this.getIndex(TabbedPropertyRegistry.this.propertyCategories.toArray(), categoryOne);
                int categoryTwoPosition = TabbedPropertyRegistry.this.getIndex(TabbedPropertyRegistry.this.propertyCategories.toArray(), categoryTwo);
                return categoryOnePosition - categoryTwoPosition;
            }
        });
        return descriptors;
    }

    protected List sortTabDescriptorsByAfterTab(List tabs) {
        if (tabs.size() == 0 || this.propertyCategories == null) {
            return tabs;
        }
        ArrayList sorted = new ArrayList();
        int categoryIndex = 0;
        int i = 0;
        while (i < this.propertyCategories.size()) {
            ArrayList categoryList = new ArrayList();
            String category = (String)this.propertyCategories.get(i);
            int topOfCategory = categoryIndex;
            int endOfCategory = categoryIndex;
            while (endOfCategory < tabs.size() && ((TabDescriptor)tabs.get(endOfCategory)).getCategory().equals(category)) {
                ++endOfCategory;
            }
            int j = topOfCategory;
            while (j < endOfCategory) {
                TabDescriptor tab = (TabDescriptor)tabs.get(j);
                if (tab.getAfterTab().equals(TOP)) {
                    categoryList.add(0, tabs.get(j));
                } else {
                    categoryList.add(tabs.get(j));
                }
                ++j;
            }
            Collections.sort(categoryList, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    TabDescriptor one = (TabDescriptor)arg0;
                    TabDescriptor two = (TabDescriptor)arg1;
                    if (two.getAfterTab().equals(one.getId())) {
                        return -1;
                    }
                    if (one.getAfterTab().equals(two.getId())) {
                        return 1;
                    }
                    return 0;
                }
            });
            j = 0;
            while (j < categoryList.size()) {
                sorted.add(categoryList.get(j));
                ++j;
            }
            categoryIndex = endOfCategory;
            ++i;
        }
        return sorted;
    }

    public ITypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public IActionProvider getActionProvider() {
        return this.actionProvider;
    }

    public void setSectionDescriptorProvider(ISectionDescriptorProvider sectionDescriptorProvider) {
        this.sectionDescriptorProvider = sectionDescriptorProvider;
    }
}

