/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.structuremergeviewer;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.IDocumentRange;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;

public class DocumentRangeNode
implements IDocumentRange,
IStructureComparator,
IEditableContent,
IEncodedStreamContentAccessor {
    private static final boolean POS_UPDATE = true;
    private static final String UTF_16 = "UTF-16";
    private IDocument fBaseDocument;
    private Position fRange;
    private int fTypeCode;
    private String fID;
    private Position fAppendPosition;
    private ArrayList fChildren;

    public DocumentRangeNode(int typeCode, String id, IDocument document, int start, int length) {
        this.fTypeCode = typeCode;
        this.fID = id;
        this.fBaseDocument = document;
        this.fBaseDocument.addPositionCategory("DocumentRangeCategory");
        this.fRange = new Position(start, length);
        try {
            document.addPosition("DocumentRangeCategory", this.fRange);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
        }
        catch (BadLocationException badLocationException) {}
    }

    public IDocument getDocument() {
        return this.fBaseDocument;
    }

    public Position getRange() {
        return this.fRange;
    }

    public int getTypeCode() {
        return this.fTypeCode;
    }

    public String getId() {
        return this.fID;
    }

    public void setId(String id) {
        this.fID = id;
    }

    public void addChild(DocumentRangeNode node) {
        if (this.fChildren == null) {
            this.fChildren = new ArrayList();
        }
        this.fChildren.add(node);
    }

    public Object[] getChildren() {
        if (this.fChildren != null) {
            return this.fChildren.toArray();
        }
        return new Object[0];
    }

    public void setLength(int length) {
        this.getRange().setLength(length);
    }

    public void setAppendPosition(int pos) {
        this.fBaseDocument.removePosition(this.fAppendPosition);
        try {
            Position p = new Position(pos);
            this.fBaseDocument.addPosition("DocumentRangeCategory", p);
            this.fAppendPosition = p;
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
        }
        catch (BadLocationException badLocationException) {}
    }

    public Position getAppendPosition() {
        if (this.fAppendPosition == null) {
            try {
                Position p = new Position(this.fBaseDocument.getLength());
                this.fBaseDocument.addPosition("DocumentRangeCategory", p);
                this.fAppendPosition = p;
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
            }
            catch (BadLocationException badLocationException) {}
        }
        return this.fAppendPosition;
    }

    public boolean equals(Object other) {
        if (other != null && other.getClass() == this.getClass()) {
            DocumentRangeNode tn = (DocumentRangeNode)other;
            return this.fTypeCode == tn.fTypeCode && this.fID.equals(tn.fID);
        }
        return super.equals(other);
    }

    public int hashCode() {
        return this.fID.hashCode();
    }

    private Position findCorrespondingPosition(DocumentRangeNode otherParent, DocumentRangeNode child) {
        int ix;
        if (child != null && this.fChildren != null && (ix = otherParent.fChildren.indexOf(child)) >= 0) {
            int i2;
            DocumentRangeNode c1;
            int i = ix - 1;
            while (i >= 0) {
                c1 = (DocumentRangeNode)otherParent.fChildren.get(i);
                i2 = this.fChildren.indexOf(c1);
                if (i2 >= 0) {
                    DocumentRangeNode c = (DocumentRangeNode)this.fChildren.get(i2);
                    Position p = c.fRange;
                    Position po = new Position(p.getOffset() + p.getLength() + 1, 0);
                    return po;
                }
                --i;
            }
            i = ix;
            while (i < otherParent.fChildren.size()) {
                c1 = (DocumentRangeNode)otherParent.fChildren.get(i);
                i2 = this.fChildren.indexOf(c1);
                if (i2 >= 0) {
                    DocumentRangeNode c = (DocumentRangeNode)this.fChildren.get(i2);
                    Position p = c.fRange;
                    Position po = new Position(p.getOffset(), 0);
                    return po;
                }
                ++i;
            }
        }
        return this.getAppendPosition();
    }

    private void add(String s, DocumentRangeNode parent, DocumentRangeNode child) {
        Position p = this.findCorrespondingPosition(parent, child);
        if (p != null) {
            try {
                this.fBaseDocument.replace(p.getOffset(), p.getLength(), s);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public InputStream getContents() {
        String s;
        try {
            s = this.fBaseDocument.get(this.fRange.getOffset(), this.fRange.getLength());
        }
        catch (BadLocationException badLocationException) {
            s = "";
        }
        return new ByteArrayInputStream(Utilities.getBytes(s, UTF_16));
    }

    public boolean isEditable() {
        return true;
    }

    public ITypedElement replace(ITypedElement child, ITypedElement other) {
        DocumentRangeNode src = null;
        String srcContents = "";
        if (other != null) {
            src = (DocumentRangeNode)((Object)child);
            if (other instanceof IStreamContentAccessor) {
                try {
                    srcContents = Utilities.readString((IStreamContentAccessor)((Object)other));
                }
                catch (CoreException coreException) {}
            }
        }
        if (child == null) {
            this.add(srcContents, null, src);
        }
        return child;
    }

    public void setContent(byte[] content) {
    }

    public String getCharset() {
        return UTF_16;
    }
}

